/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.PortableInterceptor;

import java.util.logging.Logger;
import org.apache.yoko.orb.IOP.ServiceContexts;
import org.apache.yoko.orb.OB.Downcall;
import org.apache.yoko.orb.OB.ORBInstance;
import org.apache.yoko.orb.PortableInterceptor.ArgumentStrategy;
import org.apache.yoko.orb.PortableInterceptor.Current_impl;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.MinorCodes;
import org.omg.CORBA.Any;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Policy;
import org.omg.CORBA.TypeCode;
import org.omg.Dynamic.Parameter;
import org.omg.IOP.IOR;
import org.omg.IOP.ServiceContext;
import org.omg.PortableInterceptor.InvalidSlot;
import org.omg.PortableInterceptor.RequestInfo;

public class RequestInfo_impl
extends LocalObject
implements RequestInfo {
    static final Logger logger = Logger.getLogger(RequestInfo_impl.class.getName());
    private final int id;
    private final boolean requestIsOneWay;
    protected static final short NO_REPLY_SC = -2;
    protected static final short NO_REPLY = -1;
    protected final ORB orb;
    protected final ORBInstance orbInstance;
    protected final String operationName;
    protected final Policy[] policies;
    protected final ServiceContexts requestContexts;
    protected final ServiceContexts replyContexts;
    protected final Current_impl piCurrent;
    protected short replyStatus;
    protected IOR forwardReference;
    protected ArgumentStrategy argStrategy;
    protected Exception receivedException;
    protected String receivedId;
    protected Any[] requestSlotData;
    protected boolean currentNeedsPopping;

    public int request_id() {
        return this.id;
    }

    public String operation() {
        return this.operationName;
    }

    public Parameter[] arguments() {
        return this.argStrategy.arguments();
    }

    public TypeCode[] exceptions() {
        return this.argStrategy.exceptions();
    }

    public String[] contexts() {
        throw new NO_IMPLEMENT();
    }

    public String[] operation_context() {
        throw new NO_IMPLEMENT();
    }

    public Any result() {
        return this.argStrategy.result();
    }

    public boolean response_expected() {
        return !this.requestIsOneWay;
    }

    public short sync_scope() {
        throw new NO_IMPLEMENT();
    }

    public short reply_status() {
        if (this.replyStatus < 0) {
            throw this.newBadInvOrder();
        }
        return this.replyStatus;
    }

    public Object forward_reference() {
        if (this.replyStatus != 3) {
            throw this.newBadInvOrder();
        }
        Assert.ensure((this.forwardReference != null ? 1 : 0) != 0);
        return this.orbInstance.getObjectFactory().createObject(this.forwardReference);
    }

    public Any get_slot(int id) throws InvalidSlot {
        if (id >= this.requestSlotData.length || id < 0) {
            throw new InvalidSlot("No slot for id " + id);
        }
        logger.fine("getting slot " + id + " for operation " + this.operationName);
        Any result = this.orb.create_any();
        if (null != this.requestSlotData[id]) {
            result.read_value(this.requestSlotData[id].create_input_stream(), this.requestSlotData[id].type());
        }
        return result;
    }

    public ServiceContext get_request_service_context(int id) {
        ServiceContext ctx = this.requestContexts.get(id);
        if (ctx == null) {
            throw this.newBadParam(id);
        }
        return ctx;
    }

    public ServiceContext get_reply_service_context(int id) {
        if (this.replyStatus < 0) {
            throw this.newBadInvOrder();
        }
        ServiceContext result = this.replyContexts.get(id);
        if (result == null) {
            throw this.newBadParam(id);
        }
        return result;
    }

    private BAD_INV_ORDER newBadInvOrder() {
        int code = 1330446350;
        return new BAD_INV_ORDER(MinorCodes.describeBadInvOrder((int)1330446350), 1330446350, CompletionStatus.COMPLETED_NO);
    }

    private BAD_PARAM newBadParam(int id) {
        int code = 1330446362;
        return new BAD_PARAM(MinorCodes.describeBadParam((int)1330446362) + ": " + id, 1330446362, CompletionStatus.COMPLETED_NO);
    }

    public RequestInfo_impl(ORB orb, ORBInstance orbInstance, Current_impl current, Downcall dc) {
        this(orb, dc.requestId(), dc.operation(), dc.responseExpected(), dc.requestContexts, dc.replyContexts, orbInstance, dc.policies().value, current);
    }

    protected RequestInfo_impl(ORB orb, int id, String op, boolean responseExpected, ServiceContexts requestContexts, ServiceContexts replyContexts, ORBInstance orbInstance, Policy[] policies, Current_impl current) {
        this.orb = orb;
        this.id = id;
        this.operationName = op;
        this.requestIsOneWay = !responseExpected;
        this.orbInstance = orbInstance;
        this.policies = policies;
        this.requestContexts = requestContexts;
        this.replyContexts = replyContexts;
        this.piCurrent = current;
    }

    public void _OB_setReplyStatus(short status) {
        this.replyStatus = status;
    }

    public void _OB_setForwardReference(IOR ior) {
        Assert.ensure((this.replyStatus == 3 ? 1 : 0) != 0);
        this.forwardReference = ior;
    }

    public void _OB_setReceivedException(Exception ex, String id) {
        this.receivedException = ex;
        this.receivedId = id;
    }

    void popCurrent() {
        if (this.currentNeedsPopping) {
            this.currentNeedsPopping = false;
            this.piCurrent._OB_popSlotData();
        }
    }
}

