/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.client;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.utils.ras.SibTr;
import com.ibm.wsspi.sib.core.DestinationListener;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class DestinationListenerCache {
    public static final String $sccsid = "@(#) 1.5 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/DestinationListenerCache.java, SIB.comms, WASX.SIB, uu1215.01 07/09/27 09:50:53 [4/12/12 22:13:38]";
    private static final TraceComponent tc = SibTr.register(DestinationListenerCache.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private final Map<Short, DestinationListener> cache = Collections.synchronizedMap(new HashMap());

    public boolean contains(DestinationListener dl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)dl);
        }
        boolean rc = this.cache.containsValue(dl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)rc);
        }
        return rc;
    }

    public boolean contains(short id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"contains", (Object)id);
        }
        boolean rc = this.cache.containsKey(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"contains", (Object)rc);
        }
        return rc;
    }

    public DestinationListener get(short id) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"get", (Object)id);
        }
        DestinationListener rc = this.cache.get(id);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"get", (Object)rc);
        }
        return rc;
    }

    public synchronized short add(DestinationListener dl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)dl);
        }
        short rc = 0;
        if (this.cache.containsValue(dl)) {
            for (Short s : this.cache.keySet()) {
                if (!this.cache.get((short)s).equals(dl)) continue;
                rc = s;
                break;
            }
        } else {
            for (short s = 1; s <= Short.MAX_VALUE; s = (short)(s + 1)) {
                if (this.cache.containsKey(s)) continue;
                rc = s;
                break;
            }
            if (rc == 0) {
                throw new RuntimeException("Cache full - no free Id values");
            }
            this.cache.put(rc, dl);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add", (Object)rc);
        }
        return rc;
    }

    public synchronized void add(short id, DestinationListener dl) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"add", (Object)new Object[]{id, dl});
        }
        this.cache.put(id, dl);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"add");
        }
    }

    public String toString() {
        return "cache=" + this.cache.toString();
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#) 1.5 SIB/ws/code/sib.comms.client.impl/src/com/ibm/ws/sib/comms/client/DestinationListenerCache.java, SIB.comms, WASX.SIB, uu1215.01 07/09/27 09:50:53 [4/12/12 22:13:38]");
        }
    }
}

