/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.translator.compiler;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.JspCoreException;
import com.ibm.ws.jsp.JspOptions;
import com.ibm.ws.jsp.translator.compiler.JspCompilerResultImpl;
import com.ibm.ws.jsp.translator.compiler.utils.JspFileManager;
import com.ibm.ws.jsp.translator.compiler.utils.JspFileObject;
import com.ibm.wsspi.jsp.compiler.JspCompiler;
import com.ibm.wsspi.jsp.compiler.JspCompilerResult;
import com.ibm.wsspi.jsp.compiler.JspLineId;
import com.ibm.wsspi.jsp.context.JspClassloaderContext;
import com.ibm.wsspi.jsp.resource.translation.JspResources;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.ToolProvider;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class StandardJspCompiler
implements JspCompiler {
    protected static final Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private static final String CLASS_NAME = "com.ibm.ws.jsp.translator.compiler.StandardJspCompiler";
    private static final long NANOS_IN_A_MILLISECOND = 1000000L;
    private static String separatorString = System.getProperty("line.separator");
    protected boolean isClassDebugInfo;
    protected boolean isDebugEnabled;
    protected boolean isVerbose;
    protected boolean isDeprecation;
    protected int jdkSourceLevel;
    protected Integer javaSourceLevel;
    protected String javaEncoding;
    protected String outputDir;
    protected JavaCompiler compiler;
    protected ClassLoader classLoader;
    protected DiagnosticCollector<JavaFileObject> diagnostics;
    protected StandardJavaFileManager fileManager;
    protected JspFileManager fileManagerImpl;
    static final long serialVersionUID = 3928160982574397140L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public StandardJspCompiler(JspClassloaderContext context, JspOptions options, String optimizedClasspath, boolean useOptimizedClasspath) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[]{context, options, optimizedClasspath, useOptimizedClasspath});
        }
        this.isClassDebugInfo = false;
        this.isDebugEnabled = false;
        this.isVerbose = false;
        this.isDeprecation = false;
        this.javaEncoding = null;
        this.outputDir = null;
        this.classLoader = null;
        this.compiler = ToolProvider.getSystemJavaCompiler();
        this.classLoader = context.getClassLoader();
        this.diagnostics = new DiagnosticCollector();
        this.fileManager = this.compiler.getStandardFileManager(this.diagnostics, null, null);
        this.fileManagerImpl = new JspFileManager(this.fileManager, this.classLoader);
        this.isClassDebugInfo = options.isClassDebugInfo();
        this.isDebugEnabled = options.isDebugEnabled();
        this.isVerbose = options.isVerbose();
        this.isDeprecation = options.isDeprecation();
        this.javaEncoding = options.getJavaEncoding();
        this.jdkSourceLevel = options.getJdkSourceLevel();
        this.javaSourceLevel = options.getJavaSourceLevel();
        this.outputDir = options.getOutputDir().getPath();
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "StandardJspCompiler", "Entering StandardJspCompiler.");
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerResult compile(JspResources[] jspResources, JspResources[] dependencyResources, Collection jspLineIds, List compilerOptions) {
        JspCompilerResultImpl result;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "compile", new Object[]{jspResources, dependencyResources, jspLineIds, compilerOptions});
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.compile");
        }
        boolean rc = false;
        rc = this.runCompile(jspResources, dependencyResources, compilerOptions);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "compile", "rc = " + rc);
        }
        int rci = rc ? 0 : 1;
        String output = null;
        if ((rci != 0 || rci == 0 && (this.isVerbose || this.isDeprecation)) && rci != 0) {
            output = this.getJspLineErrors(jspLineIds);
        }
        JspCompilerResultImpl jspCompilerResultImpl = result = new JspCompilerResultImpl(rci, output);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerResultImpl = jspCompilerResultImpl;
            logger.exiting(CLASS_NAME, "compile", jspCompilerResultImpl);
        }
        return jspCompilerResultImpl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean runCompile(JspResources[] jspResources, JspResources[] dependencyResources, List compilerOptions) {
        long end;
        boolean success;
        long start;
        block14: {
            if (logger != null && logger.isLoggable(Level.FINER)) {
                logger.entering(CLASS_NAME, "runCompile", new Object[]{jspResources, dependencyResources, compilerOptions});
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                logger.logp(Level.FINE, CLASS_NAME, "compile", "Entering StandardJspCompiler.runCompile");
            }
            List<String> argList = null;
            if (jspResources.length > 1) {
                argList = this.buildArgList(compilerOptions, this.outputDir);
                this.fileManagerImpl.setAreTagFiles(true);
            } else {
                argList = this.buildArgList(compilerOptions, jspResources[0].getGeneratedSourceFile().getParent());
            }
            ArrayList<JspFileObject> classesToCompile = new ArrayList<JspFileObject>();
            this.fileManagerImpl.addDependencies(dependencyResources);
            for (JspResources jspResource : jspResources) {
                classesToCompile.add(new JspFileObject(jspResource, JavaFileObject.Kind.SOURCE, this.javaEncoding));
            }
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
                for (JspResources jspResource : jspResources) {
                    logger.logp(Level.FINE, CLASS_NAME, "runCompile", "compiling " + jspResource.getGeneratedSourceFile().getPath());
                }
                if (dependencyResources != null) {
                    logger.logp(Level.FINE, CLASS_NAME, "runCompile", "Dependencies: ");
                    for (JspResources jspDependency : dependencyResources) {
                        logger.logp(Level.FINE, CLASS_NAME, "runCompile", "Dependency resource: " + jspDependency.getGeneratedSourceFile().getPath());
                    }
                }
                logger.logp(Level.FINE, CLASS_NAME, "runCompile", "classloader [" + this.classLoader + "]");
            }
            JavaCompiler.CompilationTask task = this.compiler.getTask(null, this.fileManagerImpl, this.diagnostics, argList, null, classesToCompile);
            start = System.nanoTime();
            success = task.call();
            end = System.nanoTime();
            try {
                this.fileManager.close();
                this.fileManagerImpl.close();
            }
            catch (IOException e) {
                if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINE)) break block14;
                logger.logp(Level.FINE, CLASS_NAME, "runCompile", "Problem closing FileManagers", e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            for (JspResources jspResource : jspResources) {
                logger.logp(Level.FINE, CLASS_NAME, "runCompile", "Compilation completed for " + jspResource.getGeneratedSourceFile().getPath());
            }
            logger.logp(Level.FINE, CLASS_NAME, "runCompile", "Compilation completed in " + (end - start) / 1000000L + " Milliseconds; success = " + success);
        }
        boolean bl = success;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting(CLASS_NAME, "runCompile", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private List<String> buildArgList(List compilerOptions, String outputDirectory) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "buildArgList", new Object[]{compilerOptions, outputDirectory});
        }
        ArrayList<String> argList = new ArrayList<String>();
        if (this.isClassDebugInfo || this.isDebugEnabled) {
            argList.add("-g");
        }
        if (this.isVerbose) {
            argList.add("-verbose");
        }
        if (this.isDeprecation) {
            argList.add("-deprecation");
        }
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "StandardJspCompiler", "source options are - javaSourceLevel: " + this.javaSourceLevel + " and jdkSourceLevel: " + this.jdkSourceLevel);
        }
        argList.add("-source");
        if (this.javaSourceLevel != -1) {
            argList.add(this.javaSourceLevel.toString());
        } else if (this.jdkSourceLevel == 14) {
            argList.add("1.4");
        } else if (this.jdkSourceLevel == 15) {
            argList.add("1.5");
        } else if (this.jdkSourceLevel == 16) {
            argList.add("1.6");
        } else if (this.jdkSourceLevel == 17) {
            argList.add("1.7");
        } else if (this.jdkSourceLevel == 18) {
            argList.add("1.8");
        } else {
            argList.add("1.3");
        }
        argList.add("-proc:none");
        argList.add("-encoding");
        argList.add(this.javaEncoding);
        argList.add("-XDjsrlimit=1000");
        argList.add("-d");
        argList.add(outputDirectory);
        if (compilerOptions != null) {
            for (int i = 0; i < compilerOptions.size(); ++i) {
                String compilerOption = (String)compilerOptions.get(i);
                if (compilerOption.equals("-verbose")) {
                    this.isVerbose = true;
                }
                if (compilerOption.equals("-deprecation")) {
                    this.isDeprecation = true;
                }
                argList.add(compilerOption);
            }
        }
        ArrayList<String> arrayList = argList;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            logger.exiting(CLASS_NAME, "buildArgList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public String getJspLineErrors(Collection jspLineIds) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "getJspLineErrors", new Object[]{jspLineIds});
        }
        StringBuffer errorMsg = new StringBuffer();
        for (Diagnostic<JavaFileObject> diagnostic : this.diagnostics.getDiagnostics()) {
            String mapping;
            if (!diagnostic.getKind().equals((Object)Diagnostic.Kind.ERROR) && !this.isVerbose && !this.isDeprecation) continue;
            String string = mapping = diagnostic.getSource() == null ? null : this.findMapping(jspLineIds, diagnostic.getLineNumber(), new File(diagnostic.getSource().toUri().getSchemeSpecificPart()).getPath());
            if (mapping == null) {
                errorMsg.append(separatorString);
            } else {
                errorMsg.append(mapping);
                errorMsg.append(separatorString);
            }
            errorMsg.append(diagnostic.toString());
            errorMsg.append(separatorString);
        }
        String string = errorMsg.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "getJspLineErrors", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String findMapping(Collection jspLineIds, long lineNr, String javaName) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "findMapping", new Object[]{jspLineIds, lineNr, javaName});
        }
        String errorMsg = null;
        for (JspLineId lineId : jspLineIds) {
            if (!lineId.getGeneratedFilePath().equals(javaName)) continue;
            if (lineId.getStartGeneratedLineCount() <= 1 && (long)lineId.getStartGeneratedLineNum() == lineNr) {
                errorMsg = this.createErrorMsg(lineId, lineNr);
                break;
            }
            if ((long)lineId.getStartGeneratedLineNum() > lineNr || (long)(lineId.getStartGeneratedLineNum() + lineId.getStartGeneratedLineCount() - 1) < lineNr) continue;
            errorMsg = this.createErrorMsg(lineId, lineNr);
            break;
        }
        String string = errorMsg;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "findMapping", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private String createErrorMsg(JspLineId jspLineId, long errorLineNr) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "createErrorMsg", new Object[]{jspLineId, errorLineNr});
        }
        StringBuffer compilerOutput = new StringBuffer();
        if (jspLineId.getSourceLineCount() <= 1) {
            Object[] objArray = new Object[]{jspLineId.getStartSourceLineNum(), jspLineId.getFilePath()};
            if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
            } else {
                compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
            }
        } else {
            long actualLineNum = (long)jspLineId.getStartSourceLineNum() + (errorLineNr - (long)jspLineId.getStartGeneratedLineNum());
            if (actualLineNum >= (long)jspLineId.getStartSourceLineNum() && actualLineNum <= (long)(jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1)) {
                Object[] objArray = new Object[]{actualLineNum, jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.single.line.number.included.file", objArray));
                }
            } else {
                Object[] objArray = new Object[]{jspLineId.getStartSourceLineNum(), jspLineId.getStartSourceLineNum() + jspLineId.getSourceLineCount() - 1, jspLineId.getFilePath()};
                if (jspLineId.getFilePath().equals(jspLineId.getParentFile())) {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number", objArray));
                } else {
                    compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.multiple.line.number.included.file", objArray));
                }
            }
        }
        compilerOutput.append(separatorString + JspCoreException.getMsg("jsp.error.corresponding.servlet", new Object[]{jspLineId.getParentFile()}) + separatorString);
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.logp(Level.FINER, CLASS_NAME, "createErrorMsg", "The value of the JSP attribute jdkSourceLevel is [" + this.jdkSourceLevel + "]");
        }
        String string = compilerOutput.toString();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            string = string;
            logger.exiting(CLASS_NAME, "createErrorMsg", string);
        }
        return string;
    }

    @Override
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public JspCompilerResult compile(String arg0, Collection arg1, List arg2) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "compile", new Object[]{arg0, arg1, arg2});
        }
        JspCompilerResult jspCompilerResult = null;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            jspCompilerResult = jspCompilerResult;
            logger.exiting(CLASS_NAME, "compile", jspCompilerResult);
        }
        return jspCompilerResult;
    }
}

