/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.registry.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.PasswordCheckFailedException;
import com.ibm.websphere.security.Result;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.registry.CertificateMapFailedException;
import com.ibm.ws.security.registry.CertificateMapNotSupportedException;
import com.ibm.ws.security.registry.CustomRegistryException;
import com.ibm.ws.security.registry.EntryNotFoundException;
import com.ibm.ws.security.registry.ExternalUserRegistryWrapper;
import com.ibm.ws.security.registry.NotImplementedException;
import com.ibm.ws.security.registry.RegistryException;
import com.ibm.ws.security.registry.SearchResult;
import com.ibm.ws.security.registry.UserRegistry;
import java.rmi.RemoteException;
import java.security.cert.X509Certificate;
import java.util.List;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CustomUserRegistryWrapper
implements UserRegistry,
ExternalUserRegistryWrapper {
    private static final TraceComponent tc = Tr.register(CustomUserRegistryWrapper.class, (String)"UserRegistry", (String)"com.ibm.ws.security.registry.internal.resources.LoggingMessages");
    private static final String DEFAULT_REALM = "Default Realm";
    private static final String CUSTOM_REALM = "customRealm";
    private final com.ibm.websphere.security.UserRegistry customUserRegistry;
    static final long serialVersionUID = 7388210076329137900L;

    public CustomUserRegistryWrapper(com.ibm.websphere.security.UserRegistry customUserRegistry) {
        this.customUserRegistry = customUserRegistry;
    }

    @Override
    public com.ibm.websphere.security.UserRegistry getExternalUserRegistry() {
        return this.customUserRegistry;
    }

    @Override
    @FFDCIgnore(value={PasswordCheckFailedException.class})
    public String checkPassword(String userSecurityName, @Sensitive String password) throws RegistryException {
        try {
            return this.customUserRegistry.checkPassword(userSecurityName, password);
        }
        catch (PasswordCheckFailedException e) {
            return null;
        }
        catch (Exception e) {
            Object[] objectArray = new Object[2];
            objectArray[0] = userSecurityName;
            objectArray[1] = "<sensitive java.lang.String>";
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"72", (Object)this, (Object[])objectArray);
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getGroupDisplayName(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getGroupDisplayName(groupSecurityName);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"85", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getGroupSecurityName(String uniqueGroupId) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getGroupSecurityName(uniqueGroupId);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"98", (Object)this, (Object[])new Object[]{uniqueGroupId});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SearchResult getGroups(String pattern, int limit) throws RegistryException {
        try {
            Result result = this.customUserRegistry.getGroups(pattern, limit);
            return new SearchResult(result.getList(), result.hasMore());
        }
        catch (Exception result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"109", (Object)this, (Object[])new Object[]{pattern, limit});
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public List<String> getGroupsForUser(String userSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getGroupsForUser(userSecurityName);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"122", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getRealm() {
        try {
            String realmName = this.customUserRegistry.getRealm();
            if (realmName == null || realmName.trim().isEmpty()) {
                realmName = CUSTOM_REALM;
            }
            return realmName;
        }
        catch (Exception realmName) {
            FFDCFilter.processException((Throwable)realmName, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"136", (Object)this, (Object[])new Object[0]);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)"Exception caught on getRealm", (Object[])new Object[]{this.customUserRegistry, e});
            }
            return DEFAULT_REALM;
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getUniqueGroupId(String groupSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getUniqueGroupId(groupSecurityName);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"152", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public List<String> getUniqueGroupIdsForUser(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getUniqueGroupIds(uniqueUserId);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"165", (Object)this, (Object[])new Object[]{uniqueUserId});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getUniqueUserId(String userSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getUniqueUserId(userSecurityName);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"178", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getUserDisplayName(String userSecurityName) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getUserDisplayName(userSecurityName);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"191", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.EntryNotFoundException.class})
    public String getUserSecurityName(String uniqueUserId) throws EntryNotFoundException, RegistryException {
        try {
            return this.customUserRegistry.getUserSecurityName(uniqueUserId);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException e) {
            throw new EntryNotFoundException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"204", (Object)this, (Object[])new Object[]{uniqueUserId});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SearchResult getUsers(String pattern, int limit) throws RegistryException {
        try {
            Result result = this.customUserRegistry.getUsers(pattern, limit);
            return new SearchResult(result.getList(), result.hasMore());
        }
        catch (Exception result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"215", (Object)this, (Object[])new Object[]{pattern, limit});
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidGroup(String groupSecurityName) throws RegistryException {
        try {
            return this.customUserRegistry.isValidGroup(groupSecurityName);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"225", (Object)this, (Object[])new Object[]{groupSecurityName});
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isValidUser(String userSecurityName) throws RegistryException {
        try {
            return this.customUserRegistry.isValidUser(userSecurityName);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"235", (Object)this, (Object[])new Object[]{userSecurityName});
            throw new RegistryException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @FFDCIgnore(value={com.ibm.websphere.security.CertificateMapFailedException.class})
    public String mapCertificate(X509Certificate[] chain) throws CertificateMapNotSupportedException, CertificateMapFailedException, RegistryException {
        try {
            return this.customUserRegistry.mapCertificate(chain);
        }
        catch (com.ibm.websphere.security.CertificateMapNotSupportedException certificateMapNotSupportedException) {
            void e;
            FFDCFilter.processException((Throwable)certificateMapNotSupportedException, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"246", (Object)this, (Object[])new Object[]{chain});
            throw new CertificateMapNotSupportedException(e.getMessage());
        }
        catch (com.ibm.websphere.security.CertificateMapFailedException e) {
            throw new CertificateMapFailedException(e.getMessage(), e);
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"250", (Object)this, (Object[])new Object[]{chain});
            throw new RegistryException(e.getMessage(), e);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SearchResult getUsersForGroup(String groupSecurityName, int limit) throws NotImplementedException, EntryNotFoundException, CustomRegistryException, RemoteException, RegistryException {
        Result result = null;
        try {
            result = this.customUserRegistry.getUsersForGroup(groupSecurityName, limit);
        }
        catch (com.ibm.websphere.security.EntryNotFoundException entryNotFoundException) {
            void e;
            FFDCFilter.processException((Throwable)entryNotFoundException, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"263", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new EntryNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (RemoteException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"265", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new RemoteException(e.getMessage(), e);
        }
        catch (com.ibm.websphere.security.NotImplementedException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"267", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new NotImplementedException(e.getMessage(), e);
        }
        catch (com.ibm.websphere.security.CustomRegistryException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.registry.internal.CustomUserRegistryWrapper", (String)"269", (Object)this, (Object[])new Object[]{groupSecurityName, limit});
            throw new CustomRegistryException(e.getMessage(), e);
        }
        return new SearchResult(result.getList(), result.hasMore());
    }

    @Override
    public String getType() {
        return "CUSTOM";
    }
}

