/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import jakarta.servlet.ServletInputStream;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

class CacheProxyInputStream
extends ServletInputStream {
    BufferedInputStream bis = null;
    protected int buffer = -1;
    boolean canMark = false;

    public CacheProxyInputStream(InputStream is, int s) {
        this.bis = new BufferedInputStream(is, s);
        this.bis.mark(s);
        this.buffer = s;
    }

    protected void setCanMark(boolean b) {
        this.canMark = b;
    }

    public boolean markSupported() {
        return this.canMark;
    }

    public int available() throws IOException {
        return this.bis.available();
    }

    public void close() throws IOException {
    }

    public void mark(int readlimit) {
        if (!this.canMark) {
            throw new IllegalStateException("ServletInputStream/CacheProxyInputStream does not support mark");
        }
        this.bis.mark(readlimit);
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public void reset() throws IOException {
        if (!this.canMark) {
            throw new IllegalStateException("ServletInputStream/CacheProxyInputStream does not support mark/reset");
        }
        this.bis.reset();
    }

    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }
}

