/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.rsadapter.impl;

import com.ibm.ws.rsadapter.AdapterUtil;
import com.ibm.ws.rsadapter.impl.StatementCacheKey;

public class PSCacheKey
extends StatementCacheKey {
    public static final int PREPARED_STATEMENT = 1;

    public PSCacheKey(String theSQL, int theType, int theConcurrency, int theHoldability, int theAutoGeneratedKeys, int isoLev, String dbSchema) {
        this.type = theType;
        this.concurrency = theConcurrency;
        this.sql = theSQL;
        this.hCode = this.sql.hashCode();
        this.statementType = 1;
        this.holdability = theHoldability;
        this.autoGeneratedKeys = theAutoGeneratedKeys;
        this.statementIsoLevel = isoLev;
        this.schema = dbSchema;
    }

    public final boolean equals(Object keyToCheck) {
        try {
            if (keyToCheck == null) {
                return false;
            }
            StatementCacheKey k = (StatementCacheKey)keyToCheck;
            return (this.sql == k.sql || this.sql.equals(k.sql)) && this.statementType == k.statementType && this.holdability == k.holdability && this.autoGeneratedKeys == k.autoGeneratedKeys && this.type == k.type && this.concurrency == k.concurrency && this.statementIsoLevel == k.statementIsoLevel && AdapterUtil.match(this.schema, k.schema);
        }
        catch (Exception ex) {
            return false;
        }
    }

    @Override
    public final String toString() {
        StringBuffer sb = new StringBuffer("PSTMT: ").append(this.sql).append(' ').append(this.type).append(' ');
        sb.append(this.concurrency).append(' ').append(this.holdability).append(' ').append(this.autoGeneratedKeys).append(' ');
        sb.append(this.statementIsoLevel);
        if (this.schema != null) {
            sb.append(' ').append(this.schema);
        }
        return sb.toString();
    }
}

