/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.client;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.client.WebServicesClientConfigHolder;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.jaxws.jaxb.IgnoreUnexpectedElementValidationEventHandler;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class LibertyWebServiceClientInInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final TraceComponent tc = Tr.register(LibertyWebServiceClientInInterceptor.class, null, null);
    static final long serialVersionUID = 8873305871322868932L;

    public LibertyWebServiceClientInInterceptor() {
        super("receive");
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"The LibertyWebServiceClientInInterceptor has been registered to the Interceptor chain.", (Object[])new Object[0]);
        }
    }

    public void handleMessage(Message message) throws Fault {
        boolean debug;
        boolean bl = debug = TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
        if (!WebServicesClientConfigHolder.isConfigExists()) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"No configuration found. Returning.", (Object[])new Object[0]);
            }
            return;
        }
        String messageServiceName = message.getExchange().getService().getName().getLocalPart();
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)("Obtained name of the Service from the message - messageServiceName = " + messageServiceName), (Object[])new Object[0]);
        }
        Object enableSchemaValidation = null;
        Object ignoreUnexpectedElements = null;
        Object enableDefaultValidation = null;
        if (messageServiceName != null) {
            if (WebServicesClientConfigHolder.getEnableSchemaValidation(messageServiceName) != null) {
                enableSchemaValidation = WebServicesClientConfigHolder.getEnableSchemaValidation(messageServiceName);
            } else if (WebServicesClientConfigHolder.getEnableSchemaValidation("default") != null) {
                enableSchemaValidation = WebServicesClientConfigHolder.getEnableSchemaValidation("default");
            }
            if (WebServicesClientConfigHolder.getIgnoreUnexpectedElements(messageServiceName) != null) {
                ignoreUnexpectedElements = WebServicesClientConfigHolder.getIgnoreUnexpectedElements(messageServiceName);
            } else if (WebServicesClientConfigHolder.getIgnoreUnexpectedElements("default") != null) {
                ignoreUnexpectedElements = WebServicesClientConfigHolder.getIgnoreUnexpectedElements("default");
            }
            if (WebServicesClientConfigHolder.getEnableDefaultValidation(messageServiceName) != null) {
                enableDefaultValidation = WebServicesClientConfigHolder.getEnableDefaultValidation(messageServiceName);
            } else if (WebServicesClientConfigHolder.getEnableDefaultValidation("default") != null) {
                enableDefaultValidation = WebServicesClientConfigHolder.getEnableDefaultValidation("default");
            }
        } else {
            enableSchemaValidation = WebServicesClientConfigHolder.getEnableSchemaValidation("default") != null ? WebServicesClientConfigHolder.getEnableSchemaValidation("default") : null;
            ignoreUnexpectedElements = WebServicesClientConfigHolder.getIgnoreUnexpectedElements("default") != null ? WebServicesClientConfigHolder.getIgnoreUnexpectedElements("default") : null;
            Object object = enableDefaultValidation = WebServicesClientConfigHolder.getEnableDefaultValidation("default") != null ? WebServicesClientConfigHolder.getEnableDefaultValidation("default") : null;
        }
        if (enableSchemaValidation == null && ignoreUnexpectedElements == null && enableDefaultValidation == null) {
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)"No webServiceClient configuration found. returning.", (Object[])new Object[0]);
            }
            return;
        }
        if (debug) {
            Tr.debug((TraceComponent)tc, (String)("enableSchemaValidation   value: " + enableSchemaValidation), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("ignoreUnexpectedElements value: " + ignoreUnexpectedElements), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("enableDefaultValidation  value: " + enableDefaultValidation), (Object[])new Object[0]);
        }
        if (enableSchemaValidation != null) {
            if (((Boolean)enableSchemaValidation).booleanValue()) {
                message.put((Object)"schema-validation-enabled", (Object)true);
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)"Set schema-validation-enabled to true", (Object[])new Object[0]);
                }
            } else if (!((Boolean)enableSchemaValidation).booleanValue()) {
                message.put((Object)"schema-validation-enabled", (Object)false);
                if (debug) {
                    Tr.debug((TraceComponent)tc, (String)"Set schema-validation-enabled to false", (Object[])new Object[0]);
                }
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)"enableSchemaValdiation was null, not configuring schema-validation-enabled on client the client", (Object[])new Object[0]);
        }
        if (ignoreUnexpectedElements != null && ((Boolean)ignoreUnexpectedElements).booleanValue()) {
            message.put((Object)"set-jaxb-validation-event-handler", (Object)true);
            IgnoreUnexpectedElementValidationEventHandler unexpectedElementValidationEventHandler = new IgnoreUnexpectedElementValidationEventHandler();
            message.put((Object)"jaxb-reader-validation-event-handler", (Object)unexpectedElementValidationEventHandler);
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("Set JAXBDataBinding.SET_VALIDATION_EVENT_HANDLER to  " + (Boolean)ignoreUnexpectedElements + " for ignoreUnexpectedElements"), (Object[])new Object[0]);
            }
            if (enableDefaultValidation != null && !((Boolean)enableDefaultValidation).booleanValue()) {
                return;
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)("ignoreUnexpectedElements was " + ignoreUnexpectedElements + " not configuring ignoreUnexpectedElements on the client"), (Object[])new Object[0]);
        }
        if (enableDefaultValidation != null) {
            message.put((Object)"set-jaxb-validation-event-handler", enableDefaultValidation);
            if (debug) {
                Tr.debug((TraceComponent)tc, (String)("Set JAXBDataBinding.SET_VALIDATION_EVENT_HANDLER to " + enableDefaultValidation + " for enableDefaultValidation"), (Object[])new Object[0]);
            }
        } else if (debug) {
            Tr.debug((TraceComponent)tc, (String)("enableDefaultValidation was " + enableDefaultValidation + " not configuring enableDefaultValidation on the client"), (Object[])new Object[0]);
        }
    }
}

