/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.container.service.app.deploy.ApplicationInfo;
import com.ibm.ws.container.service.state.ApplicationStateListener;
import com.ibm.ws.container.service.state.StateChangeException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.microprofile.health.internal.AppTracker;
import com.ibm.ws.microprofile.health.internal.AppTrackerImpl;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.application.ApplicationState;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import io.openliberty.microprofile.health40.internal.HealthCheck40Service;
import io.openliberty.microprofile.health40.internal.HealthCheck40ServiceImpl;
import io.openliberty.microprofile.health40.internal.HealthFileUtils;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.management.MBeanInfo;
import javax.management.ObjectName;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={AppTracker.class, ApplicationStateListener.class}, configurationPolicy=ConfigurationPolicy.IGNORE, immediate=true, property={"service.vendor=IBM"})
public class AppTracker40Impl
extends AppTrackerImpl
implements AppTracker,
ApplicationStateListener {
    private static final TraceComponent tc = Tr.register(AppTracker40Impl.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private static AtomicBoolean isOneAppStarted = new AtomicBoolean(false);
    static final long serialVersionUID = -9143530349306889606L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void applicationStarted(ApplicationInfo appInfo) throws StateChangeException {
        String appName = appInfo.getDeploymentName();
        this.lock.writeLock().lock();
        try {
            if (this.appStateMap.containsKey(appName)) {
                this.appStateMap.replace(appName, ApplicationState.STARTING, ApplicationState.STARTED);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("applicationStarted(): started app updated in appStateMap = " + this.appStateMap.toString() + " for app: " + appName), (Object[])new Object[0]);
                }
            }
            if (this.healthCheckService != null && this.healthCheckService instanceof HealthCheck40Service) {
                HealthCheck40Service hc40serv = (HealthCheck40Service)this.healthCheckService;
                if (!isOneAppStarted.getAndSet(true)) {
                    CheckpointPhase.onRestore(() -> hc40serv.startFileHealthCheckProcesses());
                } else {
                    hc40serv.performFileHealthCheck(HealthFileUtils.getStartFile(), "START");
                }
                HealthCheck40ServiceImpl h40impl = (HealthCheck40ServiceImpl)this.healthCheckService;
                h40impl.startedApplication(appName);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected String getApplicationMBean(String appName) {
        String state;
        block2: {
            MBeanInfo bean = null;
            state = "";
            try {
                ObjectName objectName = new ObjectName("WebSphere:service=com.ibm.websphere.application.ApplicationMBean,name=" + appName);
                bean = mbeanServer.getMBeanInfo(objectName);
                state = (String)mbeanServer.getAttribute(objectName, "State");
            }
            catch (Exception objectName) {
                void e;
                FFDCFilter.processException((Throwable)objectName, (String)"io.openliberty.microprofile.health40.internal.AppTracker40Impl", (String)"139", (Object)this, (Object[])new Object[]{appName});
                if (!tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("getApplicationMBean() : Failed to retrieve MBean for app: " + appName + " : \n" + e.getMessage()), (Object[])new Object[0]);
            }
        }
        return state;
    }

    @Override
    public void applicationStopping(ApplicationInfo appInfo) {
        if (this.healthCheckService != null && this.healthCheckService instanceof HealthCheck40Service) {
            HealthCheck40ServiceImpl h40impl = (HealthCheck40ServiceImpl)this.healthCheckService;
            h40impl.stoppingApplication(appInfo.getDeploymentName());
        }
    }
}

