/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.internal.loader.classpath;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.eclipse.osgi.container.Module;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleContainerAdaptor;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.framework.util.ArrayMap;
import org.eclipse.osgi.internal.debug.Debug;
import org.eclipse.osgi.internal.framework.EquinoxConfiguration;
import org.eclipse.osgi.internal.hookregistry.ClassLoaderHook;
import org.eclipse.osgi.internal.hookregistry.HookRegistry;
import org.eclipse.osgi.internal.loader.ModuleClassLoader;
import org.eclipse.osgi.internal.loader.classpath.ClasspathEntry;
import org.eclipse.osgi.internal.loader.classpath.FragmentClasspath;
import org.eclipse.osgi.internal.loader.classpath.ManifestPackageAttributes;
import org.eclipse.osgi.internal.loader.classpath.TitleVersionVendor;
import org.eclipse.osgi.internal.messages.Msg;
import org.eclipse.osgi.internal.weaving.WeavingHookConfigurator;
import org.eclipse.osgi.storage.BundleInfo;
import org.eclipse.osgi.storage.Storage;
import org.eclipse.osgi.storage.bundlefile.BundleEntry;
import org.eclipse.osgi.storage.bundlefile.BundleFile;
import org.eclipse.osgi.util.NLS;
import org.osgi.framework.BundleException;
import org.osgi.framework.FrameworkListener;

public class ClasspathManager {
    private static final FragmentClasspath[] emptyFragments = new FragmentClasspath[0];
    private static final String[] DEFAULT_CLASSPATH = new String[]{"."};
    private final BundleInfo.Generation generation;
    private final ModuleClassLoader classloader;
    private final HookRegistry hookRegistry;
    private final Debug debug;
    private final ClasspathEntry[] entries;
    private volatile FragmentClasspath[] fragments;
    private ArrayMap<String, String> loadedLibraries = null;
    private ThreadLocal<DefineContext> currentDefineContext = new ThreadLocal();

    public ClasspathManager(BundleInfo.Generation generation, ModuleClassLoader classloader) {
        EquinoxConfiguration configuration = generation.getBundleInfo().getStorage().getConfiguration();
        this.debug = configuration.getDebug();
        this.hookRegistry = configuration.getHookRegistry();
        this.generation = generation;
        this.classloader = classloader;
        String[] cp = ClasspathManager.getClassPath(generation.getRevision());
        this.fragments = this.buildFragmentClasspaths(this.classloader, this);
        this.entries = this.buildClasspath(cp, this, this.generation);
    }

    private static String[] getClassPath(ModuleRevision revision) {
        List<ModuleCapability> moduleDatas = revision.getModuleCapabilities("equinox.module.data");
        List cp = moduleDatas.isEmpty() ? null : (List)moduleDatas.get(0).getAttributes().get("classpath");
        return cp == null ? DEFAULT_CLASSPATH : cp.toArray(new String[cp.size()]);
    }

    private FragmentClasspath[] buildFragmentClasspaths(ModuleClassLoader hostloader, ClasspathManager manager) {
        if (hostloader == null) {
            return emptyFragments;
        }
        List<ModuleWire> fragmentWires = hostloader.getBundleLoader().getWiring().getProvidedModuleWires("osgi.wiring.host");
        if (fragmentWires == null || fragmentWires.isEmpty()) {
            return emptyFragments;
        }
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(fragmentWires.size());
        for (ModuleWire fragmentWire : fragmentWires) {
            ModuleRevision revision = fragmentWire.getRequirer();
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)revision.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(revision);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, manager, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        return result.toArray(new FragmentClasspath[result.size()]);
    }

    private static void insertFragment(FragmentClasspath fragClasspath, List<FragmentClasspath> existing) {
        long fragID = fragClasspath.getGeneration().getRevision().getRevisions().getModule().getId();
        ListIterator<FragmentClasspath> iExisting = existing.listIterator();
        while (iExisting.hasNext()) {
            long otherID = iExisting.next().getGeneration().getRevision().getRevisions().getModule().getId();
            if (fragID >= otherID) continue;
            iExisting.previous();
            iExisting.add(fragClasspath);
            return;
        }
        existing.add(fragClasspath);
    }

    public void close() {
        FragmentClasspath[] currentFragments;
        for (ClasspathEntry entry : this.entries) {
            if (entry == null) continue;
            try {
                entry.close();
            }
            catch (IOException e) {
                this.generation.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.ERROR, this.generation.getRevision().getRevisions().getModule(), e, new FrameworkListener[0]);
            }
        }
        for (FragmentClasspath currentFragment : currentFragments = this.getFragmentClasspaths()) {
            currentFragment.close();
        }
    }

    private ClasspathEntry[] buildClasspath(String[] cp, ClasspathManager hostloader, BundleInfo.Generation source) {
        ArrayList<ClasspathEntry> result = new ArrayList<ClasspathEntry>(cp.length);
        for (String cpEntry : cp) {
            this.findClassPathEntry(result, cpEntry, hostloader, source);
        }
        return result.toArray(new ClasspathEntry[result.size()]);
    }

    private void findClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostloader, BundleInfo.Generation sourceGeneration) {
        List<ClassLoaderHook> loaderHooks = this.hookRegistry.getClassLoaderHooks();
        boolean hookAdded = false;
        for (ClassLoaderHook hook : loaderHooks) {
            hookAdded |= hook.addClassPathEntry(result, cp, hostloader, sourceGeneration);
        }
        if (!this.addClassPathEntry(result, cp, hostloader, sourceGeneration) && !hookAdded) {
            BundleException be = new BundleException(NLS.bind(Msg.BUNDLE_CLASSPATH_ENTRY_NOT_FOUND_EXCEPTION, cp, sourceGeneration.getRevision().toString()), 3);
            sourceGeneration.getBundleInfo().getStorage().getAdaptor().publishContainerEvent(ModuleContainerAdaptor.ContainerEvent.INFO, sourceGeneration.getRevision().getRevisions().getModule(), be, new FrameworkListener[0]);
        }
    }

    public boolean addClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        return ClasspathManager.addStandardClassPathEntry(result, cp, hostManager, source) || this.addEclipseClassPathEntry(result, cp, hostManager, source);
    }

    public static boolean addStandardClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation generation) {
        if (cp.equals(".")) {
            result.add(hostManager.createClassPathEntry(generation.getBundleFile(), generation));
            return true;
        }
        ClasspathEntry element = hostManager.getClasspath(cp, generation);
        if (element != null) {
            result.add(element);
            return true;
        }
        if (hostManager.generation == generation) {
            FragmentClasspath[] hostFrags;
            for (FragmentClasspath fragCP : hostFrags = hostManager.getFragmentClasspaths()) {
                element = hostManager.getClasspath(cp, fragCP.getGeneration());
                if (element == null) continue;
                result.add(element);
                return true;
            }
        }
        return false;
    }

    private boolean addEclipseClassPathEntry(ArrayList<ClasspathEntry> result, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        String var = ClasspathManager.hasPrefix(cp);
        if (var != null) {
            return this.addInternalClassPath(var, result, cp, hostManager, source);
        }
        if (cp.startsWith("external:")) {
            cp = cp.substring("external:".length());
            ClasspathEntry cpEntry = hostManager.getExternalClassPath(source.getBundleInfo().getStorage().getConfiguration().substituteVars(cp), source);
            if (cpEntry != null) {
                result.add(cpEntry);
                return true;
            }
        }
        return false;
    }

    private boolean addInternalClassPath(String var, ArrayList<ClasspathEntry> cpEntries, String cp, ClasspathManager hostManager, BundleInfo.Generation source) {
        EquinoxConfiguration configuration = source.getBundleInfo().getStorage().getConfiguration();
        if (var.equals("ws")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "ws/" + configuration.getWS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("os")) {
            return ClasspathManager.addStandardClassPathEntry(cpEntries, "os/" + configuration.getOS() + cp.substring(4), hostManager, source);
        }
        if (var.equals("nl")) {
            cp = cp.substring(4);
            List<String> NL_JAR_VARIANTS = source.getBundleInfo().getStorage().getConfiguration().ECLIPSE_NL_JAR_VARIANTS;
            for (String nlVariant : NL_JAR_VARIANTS) {
                if (!ClasspathManager.addStandardClassPathEntry(cpEntries, "nl/" + nlVariant + cp, hostManager, source)) continue;
                return true;
            }
        }
        return false;
    }

    private static String hasPrefix(String libPath) {
        if (libPath.startsWith("$ws$")) {
            return "ws";
        }
        if (libPath.startsWith("$os$")) {
            return "os";
        }
        if (libPath.startsWith("$nl$")) {
            return "nl";
        }
        return null;
    }

    public ClasspathEntry getClasspath(String cp, BundleInfo.Generation cpGeneration) {
        BundleFile bundlefile = null;
        BundleEntry cpEntry = cpGeneration.getBundleFile().getEntry(cp);
        if (cpEntry != null && cpEntry.getName().endsWith("/")) {
            bundlefile = ClasspathManager.createBundleFile(cp, cpGeneration);
        } else {
            File file = cpGeneration.getBundleFile().getFile(cp, false);
            if (file != null) {
                bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
            }
        }
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public ClasspathEntry getExternalClassPath(String cp, BundleInfo.Generation cpGeneration) {
        File file = new File(cp);
        if (!file.isAbsolute()) {
            return null;
        }
        BundleFile bundlefile = ClasspathManager.createBundleFile(file, cpGeneration);
        if (bundlefile != null) {
            return this.createClassPathEntry(bundlefile, cpGeneration);
        }
        return null;
    }

    public synchronized void loadFragments(Collection<ModuleRevision> addedFragments) {
        ArrayList<FragmentClasspath> result = new ArrayList<FragmentClasspath>(Arrays.asList(this.fragments));
        for (ModuleRevision addedFragment : addedFragments) {
            BundleInfo.Generation fragGeneration = (BundleInfo.Generation)addedFragment.getRevisionInfo();
            String[] cp = ClasspathManager.getClassPath(addedFragment);
            ClasspathEntry[] fragEntries = this.buildClasspath(cp, this, fragGeneration);
            FragmentClasspath fragClasspath = new FragmentClasspath(fragGeneration, fragEntries);
            ClasspathManager.insertFragment(fragClasspath, result);
        }
        this.fragments = result.toArray(new FragmentClasspath[result.size()]);
    }

    private static BundleFile createBundleFile(File content, BundleInfo.Generation generation) {
        if (!content.exists()) {
            return null;
        }
        return generation.getBundleInfo().getStorage().createBundleFile(content, generation, content.isDirectory(), false);
    }

    private static BundleFile createBundleFile(String nestedDir, BundleInfo.Generation generation) {
        return generation.getBundleInfo().getStorage().createNestedBundleFile(nestedDir, generation.getBundleFile(), generation);
    }

    private ClasspathEntry createClassPathEntry(BundleFile bundlefile, BundleInfo.Generation source) {
        ClasspathEntry entry = this.classloader != null ? this.classloader.createClassPathEntry(bundlefile, source) : new ClasspathEntry(bundlefile, source.getDomain(), source);
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public URL findLocalResource(String resource) {
        List<ClassLoaderHook> hooks = this.hookRegistry.getClassLoaderHooks();
        boolean hookFailed = false;
        for (ClassLoaderHook hook : hooks) {
            try {
                hook.preFindLocalResource(resource, this);
            }
            catch (NoSuchElementException e) {
                hookFailed = true;
            }
        }
        URL result = null;
        try {
            if (!hookFailed) {
                result = this.findLocalResourceImpl(resource, -1);
            }
        }
        finally {
            for (ClassLoaderHook hook : hooks) {
                try {
                    hook.postFindLocalResource(resource, result, this);
                }
                catch (NoSuchElementException e) {
                    result = null;
                }
            }
        }
        return result;
    }

    private URL findLocalResourceImpl(String resource, int classPathIndex) {
        Module m = this.generation.getRevision().getRevisions().getModule();
        URL result = null;
        int[] curIndex = new int[]{0};
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(resource, this);
            if (hookEntries == null) continue;
            return this.findLocalResourceImpl(resource, hookEntries, m, classPathIndex, curIndex);
        }
        curIndex[0] = 0;
        result = this.findLocalResourceImpl(resource, this.entries, m, classPathIndex, curIndex);
        if (result != null) {
            return result;
        }
        for (FragmentClasspath fragCP : this.getFragmentClasspaths()) {
            result = this.findLocalResourceImpl(resource, fragCP.getEntries(), m, classPathIndex, curIndex);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private URL findLocalResourceImpl(String resource, ClasspathEntry[] cpEntries, Module m, int classPathIndex, int[] curIndex) {
        for (ClasspathEntry cpEntry : cpEntries) {
            URL result;
            if (cpEntry != null && (result = cpEntry.findResource(resource, m, curIndex[0])) != null && (classPathIndex == -1 || classPathIndex == curIndex[0])) {
                return result;
            }
            curIndex[0] = curIndex[0] + 1;
        }
        return null;
    }

    public Enumeration<URL> findLocalResources(String resource) {
        Module m = this.generation.getRevision().getRevisions().getModule();
        ArrayList<URL> resources = new ArrayList<URL>(6);
        int[] classPathIndex = new int[]{0};
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(resource, this);
            if (hookEntries == null) continue;
            this.findLocalResources(resource, hookEntries, m, classPathIndex, resources);
            return resources.size() > 0 ? Collections.enumeration(resources) : Collections.emptyEnumeration();
        }
        classPathIndex[0] = 0;
        this.findLocalResources(resource, this.entries, m, classPathIndex, resources);
        for (FragmentClasspath fragCP : this.getFragmentClasspaths()) {
            this.findLocalResources(resource, fragCP.getEntries(), m, classPathIndex, resources);
        }
        if (resources.size() > 0) {
            return Collections.enumeration(resources);
        }
        return Collections.emptyEnumeration();
    }

    private void findLocalResources(String resource, ClasspathEntry[] cpEntries, Module m, int[] classPathIndex, List<URL> resources) {
        for (ClasspathEntry cpEntry : cpEntries) {
            URL url;
            if (cpEntry != null && (url = cpEntry.findResource(resource, m, classPathIndex[0])) != null) {
                resources.add(url);
            }
            classPathIndex[0] = classPathIndex[0] + 1;
        }
    }

    public BundleEntry findLocalEntry(String path) {
        return this.findLocalEntry(path, -1);
    }

    public BundleEntry findLocalEntry(String path, int classPathIndex) {
        BundleEntry result = null;
        int[] curIndex = new int[]{0};
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(path, this);
            if (hookEntries == null) continue;
            return this.findLocalEntry(path, hookEntries, classPathIndex, curIndex);
        }
        curIndex[0] = 0;
        result = this.findLocalEntry(path, this.entries, classPathIndex, curIndex);
        if (result != null) {
            return result;
        }
        for (FragmentClasspath fragCP : this.getFragmentClasspaths()) {
            result = this.findLocalEntry(path, fragCP.getEntries(), classPathIndex, curIndex);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private BundleEntry findLocalEntry(String path, ClasspathEntry[] cpEntries, int classPathIndex, int[] curIndex) {
        for (ClasspathEntry cpEntry : cpEntries) {
            BundleEntry result;
            if (cpEntry != null && (classPathIndex == -1 || classPathIndex == curIndex[0]) && (result = cpEntry.findEntry(path)) != null) {
                return result;
            }
            curIndex[0] = curIndex[0] + 1;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Class<?> findLocalClass(String classname) throws ClassNotFoundException {
        Class<?> result = null;
        List<ClassLoaderHook> hooks = this.hookRegistry.getClassLoaderHooks();
        try {
            Class<?> clazz;
            for (ClassLoaderHook hook : hooks) {
                hook.preFindLocalClass(classname, this);
            }
            result = this.classloader.publicFindLoaded(classname);
            if (result != null) {
                clazz = result;
                return clazz;
            }
            clazz = result = this.findLocalClassImpl(classname, hooks);
            return clazz;
        }
        finally {
            for (ClassLoaderHook hook : hooks) {
                hook.postFindLocalClass(classname, result, this);
            }
        }
    }

    private Class<?> findLocalClassImpl(String classname, List<ClassLoaderHook> hooks) {
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(classname, this);
            if (hookEntries == null) continue;
            return this.findLocalClassImpl(classname, hookEntries, hooks);
        }
        Class<?> result = this.findLocalClassImpl(classname, this.entries, hooks);
        if (result != null) {
            return result;
        }
        for (FragmentClasspath fragCP : this.getFragmentClasspaths()) {
            result = this.findLocalClassImpl(classname, fragCP.getEntries(), hooks);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    private Class<?> findLocalClassImpl(String classname, ClasspathEntry[] cpEntries, List<ClassLoaderHook> hooks) {
        for (ClasspathEntry cpEntry : cpEntries) {
            Class<?> result;
            if (cpEntry == null || (result = this.findClassImpl(classname, cpEntry, hooks)) == null) continue;
            return result;
        }
        return null;
    }

    private Class<?> findClassImpl(String name, ClasspathEntry classpathEntry, List<ClassLoaderHook> hooks) {
        byte[] classbytes;
        String filename;
        BundleEntry entry;
        String loaderTrace = this.debug.loaderWithClass(name);
        if (loaderTrace != null) {
            this.debug.trace(loaderTrace, "ModuleClassLoader[" + this.classloader.getBundleLoader() + " - " + classpathEntry.getBundleFile() + "].findClassImpl(" + name + ")");
        }
        if ((entry = classpathEntry.findEntry(filename = name.replace('.', '/').concat(".class"))) == null) {
            return null;
        }
        try {
            classbytes = entry.getBytes();
        }
        catch (IOException e) {
            if (loaderTrace != null) {
                this.debug.trace(loaderTrace, "  IOException reading " + filename + " from " + classpathEntry.getBundleFile());
            }
            throw (LinkageError)new LinkageError("Error reading class bytes: " + name).initCause(e);
        }
        if (loaderTrace != null) {
            this.debug.trace(loaderTrace, "  read " + classbytes.length + " bytes from " + classpathEntry.getBundleFile() + "!/" + filename);
            this.debug.trace(loaderTrace, "  defining class " + name);
        }
        try {
            return this.defineClass(name, classbytes, classpathEntry, entry, hooks);
        }
        catch (Error e) {
            if (loaderTrace != null) {
                this.debug.trace(loaderTrace, "  error defining class " + name);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private Class<?> defineClass(String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, List<ClassLoaderHook> hooks) {
        block24: {
            block21: {
                block22: {
                    block18: {
                        block19: {
                            result = null;
                            recursionDetected = false;
                            this.definePackage(name, classpathEntry);
                            context = this.currentDefineContext.get();
                            if (context == null) {
                                context = new DefineContext();
                                this.currentDefineContext.set(context);
                            }
                            if (this.hookRegistry.getContainer().isProcessClassRecursionSupportedByAll()) ** GOTO lbl34
                            if (!context.currentlyProcessing.contains(name)) break block18;
                            recursionDetected = true;
                            var9_9 = null;
                            if (recursionDetected) break block19;
                            defined = result != null && result.defined != false ? result.clazz : null;
                            for (ClassLoaderHook hook : hooks) {
                                hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                            }
                        }
                        return var9_9;
                    }
                    context.currentlyProcessing.add(name);
                    try {
                        for (ClassLoaderHook hook : hooks) {
                            if (hook.isProcessClassRecursionSupported()) continue;
                            classbytes = this.processClass(hook, name, classbytes, classpathEntry, entry, this, hooks);
                        }
                    }
                    finally {
                        context.currentlyProcessing.remove(name);
                    }
                    for (ClassLoaderHook hook : hooks) {
                        if (!hook.isProcessClassRecursionSupported()) continue;
                        classbytes = this.processClass(hook, name, classbytes, classpathEntry, entry, this, hooks);
                    }
                    if (!context.currentlyDefining.contains(name)) break block21;
                    var9_10 = null;
                    if (recursionDetected) break block22;
                    defined = result != null && result.defined != false ? result.clazz : null;
                    for (ClassLoaderHook hook : hooks) {
                        hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                    }
                }
                return var9_10;
            }
            try {
                context.currentlyDefining.add(name);
                try {
                    result = this.classloader.defineClass(name, classbytes, classpathEntry);
                }
                finally {
                    context.currentlyDefining.remove(name);
                }
                if (recursionDetected) break block24;
                defined = result != null && result.defined != false ? result.clazz : null;
            }
            catch (Throwable var15_19) {
                if (!recursionDetected) {
                    defined = result != null && result.defined != false ? result.clazz : null;
                    for (ClassLoaderHook hook : hooks) {
                        hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
                    }
                }
                throw var15_19;
            }
            for (ClassLoaderHook hook : hooks) {
                hook.recordClassDefine(name, defined, classbytes, classpathEntry, entry, this);
            }
        }
        return result == null ? null : result.clazz;
    }

    private byte[] processClass(ClassLoaderHook hook, String name, byte[] classbytes, ClasspathEntry classpathEntry, BundleEntry entry, ClasspathManager classpathManager, List<ClassLoaderHook> hooks) {
        byte[] modifiedBytes = hook.processClass(name, classbytes, classpathEntry, entry, this);
        if (modifiedBytes != null) {
            if (!(hook instanceof WeavingHookConfigurator)) {
                for (ClassLoaderHook rejectHook : hooks) {
                    if (!rejectHook.rejectTransformation(name, modifiedBytes, classpathEntry, entry, this)) continue;
                    modifiedBytes = null;
                    break;
                }
            }
            if (modifiedBytes != null) {
                classbytes = modifiedBytes;
            }
        }
        return classbytes;
    }

    private void definePackage(String name, ClasspathEntry classpathEntry) {
        int lastIndex = name.lastIndexOf(46);
        if (lastIndex < 0) {
            return;
        }
        String packageName = name.substring(0, lastIndex);
        Package pkg = this.classloader.publicGetPackage(packageName);
        if (pkg != null) {
            return;
        }
        String specTitle = null;
        String specVersion = null;
        String specVendor = null;
        String implTitle = null;
        String implVersion = null;
        String implVendor = null;
        if (this.generation.getBundleInfo().getStorage().getConfiguration().DEFINE_PACKAGE_ATTRIBUTES) {
            ManifestPackageAttributes manifestPackageAttributes = classpathEntry.manifestPackageAttributesFor(packageName);
            TitleVersionVendor specification = manifestPackageAttributes.getSpecification();
            TitleVersionVendor implementation = manifestPackageAttributes.getImplementation();
            specTitle = specification.getTitle();
            specVersion = specification.getVersion();
            specVendor = specification.getVendor();
            implTitle = implementation.getTitle();
            implVersion = implementation.getVersion();
            implVendor = implementation.getVendor();
        }
        this.classloader.publicDefinePackage(packageName, specTitle, specVersion, specVendor, implTitle, implVersion, implVendor, null);
    }

    public FragmentClasspath[] getFragmentClasspaths() {
        return this.fragments;
    }

    public ClasspathEntry[] getHostClasspathEntries() {
        return this.entries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String findLibrary(String libname) {
        Object object = this;
        synchronized (object) {
            if (this.loadedLibraries == null) {
                this.loadedLibraries = new ArrayMap(1);
            }
        }
        object = this.loadedLibraries;
        synchronized (object) {
            String libpath = this.loadedLibraries.get(libname);
            if (libpath != null) {
                return libpath;
            }
            libpath = this.findLibrary0(libname);
            if (libpath != null) {
                this.loadedLibraries.put(libname, libpath);
            }
            return libpath;
        }
    }

    private String findLibrary0(String libname) {
        List<ClassLoaderHook> hooks = this.hookRegistry.getClassLoaderHooks();
        String result = null;
        for (ClassLoaderHook hook : hooks) {
            try {
                result = hook.preFindLibrary(libname, this.classloader);
                if (result == null) continue;
                return result;
            }
            catch (FileNotFoundException e) {
                return null;
            }
        }
        result = this.generation.findLibrary(libname);
        if (result != null) {
            return result;
        }
        FragmentClasspath[] currentFragments = this.getFragmentClasspaths();
        for (FragmentClasspath fragment : currentFragments) {
            result = fragment.getGeneration().findLibrary(libname);
            if (result == null) continue;
            return result;
        }
        for (ClassLoaderHook hook : hooks) {
            result = hook.postFindLibrary(libname, this.classloader);
            if (result == null) continue;
            return result;
        }
        return result;
    }

    public List<URL> findEntries(String path, String filePattern, int options) {
        FragmentClasspath[] currentFragments;
        ArrayList<BundleInfo.Generation> generations = new ArrayList<BundleInfo.Generation>();
        generations.add(this.generation);
        for (FragmentClasspath fragmentClasspath : currentFragments = this.getFragmentClasspaths()) {
            generations.add(fragmentClasspath.getGeneration());
        }
        Enumeration<URL> eURLs = Storage.findEntries(generations, path, filePattern, options);
        if (eURLs == null) {
            return Collections.emptyList();
        }
        return Collections.unmodifiableList(Collections.list(eURLs));
    }

    public Collection<String> listLocalResources(String path, String filePattern, int options) {
        ArrayList<BundleFile> bundleFiles = new ArrayList<BundleFile>();
        for (ClassLoaderHook hook : this.hookRegistry.getClassLoaderHooks()) {
            ClasspathEntry[] hookEntries = hook.getClassPathEntries(path, this);
            if (hookEntries == null) continue;
            for (ClasspathEntry cpEntry : hookEntries) {
                cpEntry.addBundleFiles(bundleFiles);
            }
            return Storage.listEntryPaths(bundleFiles, path, filePattern, options);
        }
        ClasspathEntry[] cpEntries = this.getHostClasspathEntries();
        for (ClasspathEntry cpEntry : cpEntries) {
            cpEntry.addBundleFiles(bundleFiles);
        }
        for (FragmentClasspath fragmentClasspath : this.getFragmentClasspaths()) {
            for (ClasspathEntry cpEntry : fragmentClasspath.getEntries()) {
                cpEntry.addBundleFiles(bundleFiles);
            }
        }
        return Storage.listEntryPaths(bundleFiles, path, filePattern, options);
    }

    public BundleInfo.Generation getGeneration() {
        return this.generation;
    }

    public ModuleClassLoader getClassLoader() {
        return this.classloader;
    }

    static class DefineContext {
        Collection<String> currentlyProcessing = new ArrayList<String>(5);
        Collection<String> currentlyDefining = new ArrayList<String>(5);

        DefineContext() {
        }
    }
}

