/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.sdk.trace;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.internal.ExtendedSpanProcessor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;

final class MultiSpanProcessor
implements ExtendedSpanProcessor {
    private final List<SpanProcessor> spanProcessorsStart;
    private final List<ExtendedSpanProcessor> spanProcessorsEnding;
    private final List<SpanProcessor> spanProcessorsEnd;
    private final List<SpanProcessor> spanProcessorsAll;
    private final AtomicBoolean isShutdown = new AtomicBoolean(false);

    static SpanProcessor create(List<SpanProcessor> spanProcessorList) {
        return new MultiSpanProcessor(new ArrayList<SpanProcessor>((Collection)Objects.requireNonNull(spanProcessorList, "spanProcessorList")));
    }

    public void onStart(Context parentContext, ReadWriteSpan readWriteSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsStart) {
            spanProcessor.onStart(parentContext, readWriteSpan);
        }
    }

    public boolean isStartRequired() {
        return !this.spanProcessorsStart.isEmpty();
    }

    public void onEnd(ReadableSpan readableSpan) {
        for (SpanProcessor spanProcessor : this.spanProcessorsEnd) {
            spanProcessor.onEnd(readableSpan);
        }
    }

    public boolean isEndRequired() {
        return !this.spanProcessorsEnd.isEmpty();
    }

    public void onEnding(ReadWriteSpan span) {
        for (ExtendedSpanProcessor spanProcessor : this.spanProcessorsEnding) {
            spanProcessor.onEnding(span);
        }
    }

    public boolean isOnEndingRequired() {
        return !this.spanProcessorsEnding.isEmpty();
    }

    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            return CompletableResultCode.ofSuccess();
        }
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            results.add(spanProcessor.shutdown());
        }
        return CompletableResultCode.ofAll(results);
    }

    public CompletableResultCode forceFlush() {
        ArrayList<CompletableResultCode> results = new ArrayList<CompletableResultCode>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            results.add(spanProcessor.forceFlush());
        }
        return CompletableResultCode.ofAll(results);
    }

    private MultiSpanProcessor(List<SpanProcessor> spanProcessors) {
        this.spanProcessorsAll = spanProcessors;
        this.spanProcessorsStart = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        this.spanProcessorsEnd = new ArrayList<SpanProcessor>(this.spanProcessorsAll.size());
        this.spanProcessorsEnding = new ArrayList<ExtendedSpanProcessor>(this.spanProcessorsAll.size());
        for (SpanProcessor spanProcessor : this.spanProcessorsAll) {
            ExtendedSpanProcessor extendedSpanProcessor;
            if (spanProcessor.isStartRequired()) {
                this.spanProcessorsStart.add(spanProcessor);
            }
            if (spanProcessor instanceof ExtendedSpanProcessor && (extendedSpanProcessor = (ExtendedSpanProcessor)spanProcessor).isOnEndingRequired()) {
                this.spanProcessorsEnding.add(extendedSpanProcessor);
            }
            if (!spanProcessor.isEndRequired()) continue;
            this.spanProcessorsEnd.add(spanProcessor);
        }
    }

    public String toString() {
        return "MultiSpanProcessor{spanProcessorsStart=" + this.spanProcessorsStart + ", spanProcessorsEnding=" + this.spanProcessorsEnding + ", spanProcessorsEnd=" + this.spanProcessorsEnd + ", spanProcessorsAll=" + this.spanProcessorsAll + '}';
    }
}

