/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.objectManager;

import com.ibm.ws.objectManager.Collection;
import com.ibm.ws.objectManager.FileLogOutput;
import com.ibm.ws.objectManager.InvalidStateException;
import com.ibm.ws.objectManager.LogRecord;
import com.ibm.ws.objectManager.NoRestartableObjectStoresAvailableException;
import com.ibm.ws.objectManager.ObjectManagerEventCallback;
import com.ibm.ws.objectManager.ObjectManagerException;
import com.ibm.ws.objectManager.ObjectManagerState;
import com.ibm.ws.objectManager.ObjectStore;
import com.ibm.ws.objectManager.StatisticsNameNotFoundException;
import com.ibm.ws.objectManager.Token;
import com.ibm.ws.objectManager.Transaction;
import com.ibm.ws.objectManager.TreeMap;
import com.ibm.ws.objectManager.UnexpectedExceptionException;
import com.ibm.ws.objectManager.utils.FFDC;
import com.ibm.ws.objectManager.utils.FFDCImpl;
import com.ibm.ws.objectManager.utils.NLS;
import com.ibm.ws.objectManager.utils.NLSImpl;
import com.ibm.ws.objectManager.utils.Trace;
import com.ibm.ws.objectManager.utils.TraceFactory;
import com.ibm.ws.objectManager.utils.TraceFactoryImpl;
import com.ibm.ws.objectManager.utils.Tracing;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class ObjectManager {
    public static final NLS nls = new NLSImpl("com.ibm.ws.objectManager.CWSOMMessages");
    public static final TraceFactory traceFactory = new TraceFactoryImpl(nls);
    public static final FFDC ffdc = new FFDCImpl();
    private static final Class cclass = ObjectManager.class;
    private static Trace trace = traceFactory.getTrace(ObjectManager.class, "ObjectManager");
    public static final boolean gatherStatistics = true;
    public static final boolean testInterfaces = true;
    protected static final HashMap objectManagerStates = new HashMap();
    protected ObjectManagerState objectManagerState = null;
    public static final int stateError = 0;
    public static final int stateOpeningLog = 1;
    public static final int stateReplayingLog = 2;
    public static final int stateWarmStarted = 3;
    public static final int stateColdStarted = 4;
    public static final int stateShutdownStarted = 5;
    public static final int stateStopped = 6;
    public static final int LOG_FILE_TYPE_FILE = 0;
    public static final int LOG_FILE_TYPE_NONE = 1;
    public static final int LOG_FILE_TYPE_CLEAR = 2;
    public static final String[] logFileTypeNames = new String[]{"FILE", "NONE", "CLEAR"};

    public ObjectManager(String logFileName) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", logFileName);
        }
        this.initialise(logFileName, 0, null, null);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManager(String logFileName, int logFileType) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFileName, new Integer(logFileType), logFileTypeNames[logFileType]});
        }
        this.initialise(logFileName, logFileType, null, null);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManager(String logFileName, int logFileType, Map objectStoreLocations) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFileName, new Integer(logFileType), logFileTypeNames[logFileType], objectStoreLocations});
        }
        this.initialise(logFileName, logFileType, objectStoreLocations, null);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    public ObjectManager(String logFileName, int logFileType, Map objectStoreLocations, ObjectManagerEventCallback[] callbacks) throws ObjectManagerException {
        String methodName = "<init>";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "<init>", new Object[]{logFileName, new Integer(logFileType), logFileTypeNames[logFileType], objectStoreLocations, callbacks});
        }
        this.initialise(logFileName, logFileType, objectStoreLocations, callbacks);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initialise(String logFileName, int logFileType, Map objectStoreLocations, ObjectManagerEventCallback[] callbacks) throws ObjectManagerException {
        String methodName = "initialise";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "initialise", new Object[]{logFileName, new Integer(logFileType), objectStoreLocations, callbacks});
        }
        if (objectStoreLocations == null) {
            objectStoreLocations = new HashMap();
        }
        while (true) {
            Cloneable cloneable = objectManagerStates;
            synchronized (cloneable) {
                this.objectManagerState = (ObjectManagerState)objectManagerStates.get(logFileName);
                if (this.objectManagerState == null) {
                    this.objectManagerState = this.createObjectManagerState(logFileName, logFileType, objectStoreLocations, callbacks);
                    objectManagerStates.put(logFileName, this.objectManagerState);
                }
            }
            cloneable = this.objectManagerState;
            synchronized (cloneable) {
                if (this.objectManagerState.state == 4 || this.objectManagerState.state == 3) {
                    break;
                }
                try {
                    this.objectManagerState.wait();
                }
                catch (InterruptedException exception) {
                    ffdc.processException(cclass, "initialise", exception, "1:260:1.28");
                    if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                        trace.exit((Object)this, cclass, "initialise", exception);
                    }
                    throw new UnexpectedExceptionException((Object)this, exception);
                }
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "initialise");
        }
    }

    protected ObjectManagerState createObjectManagerState(String logFileName, int logFileType, Map objectStoreLocations, ObjectManagerEventCallback[] callbacks) throws ObjectManagerException {
        return new ObjectManagerState(logFileName, this, logFileType, objectStoreLocations, callbacks);
    }

    public final boolean warmStarted() {
        String methodName = "warmStarted";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "warmStarted");
        }
        boolean isWarmStarted = false;
        if (this.objectManagerState.state == 3) {
            isWarmStarted = true;
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "warmStarted", new Boolean(isWarmStarted));
        }
        return isWarmStarted;
    }

    public final void shutdown() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutdown");
        }
        this.objectManagerState.shutdown();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "shutdown");
        }
    }

    public final void shutdownFast() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "shutdownFast");
        }
        this.objectManagerState.shutdownFast();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "shutdownFast");
        }
    }

    public final void waitForCheckpoint() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "waitForCheckpoint");
        }
        this.objectManagerState.waitForCheckpoint(true);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "waitForCheckpoint");
        }
    }

    public int getState() throws ObjectManagerException {
        String methodName = "getState";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getState");
        }
        int stateToReturn = this.objectManagerState.getObjectManagerStateState();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getState", new Object[]{new Integer(stateToReturn), ObjectManagerState.stateNames[stateToReturn]});
        }
        return stateToReturn;
    }

    public String getLogFileName() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogFileSize");
        }
        String logFileName = this.objectManagerState.logFileName;
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogFileSize", new Object[]{logFileName});
        }
        return logFileName;
    }

    public long getLogFileSize() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogFileSize");
        }
        long logFileSize = this.objectManagerState.logOutput.getLogFileSize();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogFileSize", new Object[]{new Long(logFileSize)});
        }
        return logFileSize;
    }

    public long getLogFileSpaceLeft() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getLogFileSpaceLeft");
        }
        long logFileSpaceLeft = this.objectManagerState.logOutput.getLogFileSpaceLeft();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getLogFileSpaceLeft", "returns logFileSpaceLeft=" + logFileSpaceLeft + "(long)");
        }
        return logFileSpaceLeft;
    }

    public void setLogFileSize(long newSize) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "seLogFileSize");
        }
        this.objectManagerState.logOutput.setLogFileSize(newSize);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setLogFileSize");
        }
    }

    public void simulateLogOutputFull(boolean isFull) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "simulateLogOutputFull", "isFull=" + isFull + "(boolean)");
        }
        ((FileLogOutput)this.objectManagerState.logOutput).simulateLogOutputFull(isFull);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "simulateLogOutputFull");
        }
    }

    public final Transaction getTransaction() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getTransaction");
        }
        this.objectManagerState.transactionPacing();
        Transaction transaction = this.objectManagerState.getTransaction();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransaction", "returns transaction=" + transaction + "(Transaction)");
        }
        return transaction;
    }

    public final Transaction getTransactionByXID(byte[] XID) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getTransactionByXID", "XIDe=" + XID + "(byte[]");
        }
        Transaction transaction = this.objectManagerState.getTransactionByXID(XID);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransactionByXID", "returns transaction=" + transaction + "(Transaction)");
        }
        return transaction;
    }

    public final Iterator getTransactionIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getTransactionIterator");
        }
        Iterator transactionIterator = this.objectManagerState.getTransactionIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getTransactionIterator", "returns transactionIterator" + transactionIterator + "(java.util.Iterator)");
        }
        return transactionIterator;
    }

    public final ObjectStore getObjectStore(String objectStoreName) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getObjectStore", "objectStoreName=" + objectStoreName + "(String)");
        }
        ObjectStore objectStore = this.objectManagerState.getObjectStore(objectStoreName);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStore", "returns objectStore=" + objectStore + "(ObjectStore)");
        }
        return objectStore;
    }

    public final Iterator getObjectStoreIterator() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getObjectStoreIterator");
        }
        Iterator objectStoreIterator = this.objectManagerState.getObjectStoreIterator();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getObjectStoreIterator", new Object[]{objectStoreIterator});
        }
        return objectStoreIterator;
    }

    public void print(PrintWriter printWriter) {
        printWriter.println("ObjectManager(String)");
        printWriter.println();
        this.objectManagerState.logOutput.print(printWriter);
    }

    public final Token putNamedObject(String name, Token token, Transaction transaction) throws ObjectManagerException {
        String methodName = "putNamedObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "putNamedObject", new Object[]{name, token, transaction});
        }
        Token tokenOut = null;
        if (this.objectManagerState.namedObjects == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "putNamedObject", "via NoRestartablebjectStoresAvailableException");
            }
            throw new NoRestartableObjectStoresAvailableException(this);
        }
        for (ObjectStore objectStore : this.objectManagerState.objectStores.values()) {
            if (!objectStore.getContainsRestartData()) continue;
            Token namedObjectsToken = new Token(objectStore, ObjectStore.namedObjectTreeIdentifier);
            namedObjectsToken = objectStore.like(namedObjectsToken);
            TreeMap namedObjectsTree = (TreeMap)namedObjectsToken.getManagedObject();
            tokenOut = namedObjectsTree.put(name, token, transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "putNamedObject", new Object[]{tokenOut});
        }
        return tokenOut;
    }

    public final Token getNamedObject(String name, Transaction transaction) throws ObjectManagerException {
        String methodName = "getNamedObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "getNamedObject", new Object[]{name, transaction});
        }
        if (this.objectManagerState.namedObjects == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getNamedObject", "via NoRestartableObjectStoresAvailableException");
            }
            throw new NoRestartableObjectStoresAvailableException(this);
        }
        TreeMap namedObjectsTree = (TreeMap)this.objectManagerState.namedObjects.getManagedObject();
        Token token = namedObjectsTree.get(name, transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getNamedObject", new Object[]{token});
        }
        return token;
    }

    public final Token removeNamedObject(String name, Transaction transaction) throws ObjectManagerException {
        String methodName = "removeNamedObject";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "removeNamedObject", new Object[]{name, transaction});
        }
        Token tokenOut = null;
        if (this.objectManagerState.namedObjects == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "removeNamedObject", "via NoRestartablebjectStoresAvailableException");
            }
            throw new NoRestartableObjectStoresAvailableException(this);
        }
        for (ObjectStore objectStore : this.objectManagerState.objectStores.values()) {
            if (!objectStore.getContainsRestartData()) continue;
            Token namedObjectsToken = new Token(objectStore, ObjectStore.namedObjectTreeIdentifier);
            namedObjectsToken = objectStore.like(namedObjectsToken);
            TreeMap namedObjectsTree = (TreeMap)namedObjectsToken.getManagedObject();
            tokenOut = namedObjectsTree.remove(name, transaction);
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "removeNamedObject", new Object[]{tokenOut});
        }
        return tokenOut;
    }

    public final Collection getNamedObjectNames() throws ObjectManagerException {
        String methodName = "getNamedObjectNames";
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "getNamedObjectNames");
        }
        if (this.objectManagerState.namedObjects == null) {
            if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                trace.exit((Object)this, cclass, "getNamedObjectNames", "via NoRestartableObjectStoresAvailableException");
            }
            throw new NoRestartableObjectStoresAvailableException(this);
        }
        TreeMap namedObjectsTree = (TreeMap)this.objectManagerState.namedObjects.getManagedObject();
        Collection namedObjectNames = namedObjectsTree.keyCollection();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "getNamedObjectNames", new Object[]{namedObjectNames});
        }
        return namedObjectNames;
    }

    public final void setTransactionsPerCheckpoint(long persistentTransactionsPerCheckpoint, long nonPersistentTransactionsPerCheckpoint, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setTransactionsPerCheckpoint", new Object[]{new Long(persistentTransactionsPerCheckpoint), new Long(nonPersistentTransactionsPerCheckpoint), transaction});
        }
        transaction.lock(this.objectManagerState);
        this.objectManagerState.persistentTransactionsPerCheckpoint = persistentTransactionsPerCheckpoint;
        this.objectManagerState.nonPersistentTransactionsPerCheckpoint = nonPersistentTransactionsPerCheckpoint;
        transaction.replace(this.objectManagerState);
        this.objectManagerState.saveClonedState(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setTransactionsPerCheckpoint");
        }
    }

    protected long getMaximumActiveTransactions(Transaction transaction) {
        return this.objectManagerState.maximumActiveTransactions;
    }

    public final void setMaximumActiveTransactions(int maximumActiveTransactions, Transaction transaction) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "setMaximumActiveTransactions", new Object[]{new Integer(maximumActiveTransactions), transaction});
        }
        transaction.lock(this.objectManagerState);
        this.objectManagerState.maximumActiveTransactions = maximumActiveTransactions;
        transaction.replace(this.objectManagerState);
        this.objectManagerState.saveClonedState(transaction);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "setMaximumActiveTransactions");
        }
    }

    public long writeLogRecord(LogRecord logRecord, long reservedDelta, boolean flush) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "writeLogRecord", new Object[]{logRecord, new Long(reservedDelta), new Boolean(flush)});
        }
        long logSequenceNumber = this.objectManagerState.logOutput.writeNext(logRecord, reservedDelta, true, flush);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeLogRecord", new Object[]{new Long(logSequenceNumber)});
        }
        return logSequenceNumber;
    }

    public long writeLogRecord(LogRecord logRecord) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "writeLogRecord");
        }
        long logSequenceNumber = this.objectManagerState.logOutput.writeNext(logRecord, 0L, true, false);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "writeLogRecord", "returns logSequenceNumber=" + logSequenceNumber + "(long)");
        }
        return logSequenceNumber;
    }

    public void flushLog() throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "flushLog");
        }
        ((FileLogOutput)this.objectManagerState.logOutput).flush();
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "flushLog");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map captureStatistics(String name) throws ObjectManagerException {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "captureStatistics", new Object[]{name});
        }
        HashMap statistics = new HashMap();
        ObjectManagerState objectManagerState = this.objectManagerState;
        synchronized (objectManagerState) {
            if (this.objectManagerState.state != 4 && this.objectManagerState.state != 3) {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "addEntry", new Object[]{new Integer(this.objectManagerState.state), ObjectManagerState.stateNames[this.objectManagerState.state]});
                }
                throw new InvalidStateException((Object)this, this.objectManagerState.state, ObjectManagerState.stateNames[this.objectManagerState.state]);
            }
            if (name.equals("*")) {
                statistics.putAll(this.objectManagerState.logOutput.captureStatistics());
                statistics.putAll(this.captureStatistics());
            } else if (name.equals("LogOutput")) {
                statistics.putAll(this.objectManagerState.logOutput.captureStatistics());
            } else if (name.equals("ObjectManager")) {
                statistics.putAll(this.captureStatistics());
            } else {
                if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
                    trace.exit((Object)this, cclass, "captureStatistics", new Object[]{name});
                }
                throw new StatisticsNameNotFoundException((Object)this, name);
            }
        }
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", statistics);
        }
        return statistics;
    }

    private Map captureStatistics() {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry(this, cclass, "captureStatistics");
        }
        HashMap statistics = new HashMap();
        statistics.putAll(this.objectManagerState.captureStatistics());
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit((Object)this, cclass, "captureStatistics", statistics);
        }
        return statistics;
    }

    public void registerEventCallback(ObjectManagerEventCallback callback) {
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.entry((Object)this, cclass, "registerEventCallback", callback);
        }
        this.objectManagerState.registerEventCallback(callback);
        if (Tracing.isAnyTracingEnabled() && trace.isEntryEnabled()) {
            trace.exit(this, cclass, "registerEventCallback");
        }
    }
}

