/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.metadata.ejb;

import com.ibm.ejs.container.BeanMetaData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.EJBConfigurationException;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.javaee.dd.ejb.ComponentViewableBean;
import com.ibm.ws.javaee.dd.ejb.EJBJar;
import com.ibm.ws.javaee.dd.ejb.EnterpriseBean;
import com.ibm.ws.javaee.dd.ejb.Session;
import com.ibm.ws.metadata.ejb.BeanInitData;
import com.ibm.ws.metadata.ejb.ModuleInitData;
import com.ibm.ws.metadata.ejb.WCCMMetaData;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.TreeSet;

public class WCCMMetaDataUtil {
    private static final TraceComponent tc = Tr.register(WCCMMetaDataUtil.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    private static final String MERGE = "     Merged DD ";

    private static boolean validationEnabled() {
        return ContainerProperties.ValidateMergedXML || TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled();
    }

    public static void validateMergedXML(ModuleInitData mid) throws EJBConfigurationException {
        if (!WCCMMetaDataUtil.validationEnabled()) {
            return;
        }
        EJBJar mergedEJBJar = mid.getMergedEJBJar();
        if (mergedEJBJar == null) {
            return;
        }
        ArrayList<String> errors = new ArrayList<String>();
        List mergedBeans = mergedEJBJar.getEnterpriseBeans();
        if (mergedBeans == null) {
            errors.add("     Merged DD contains no EJBs.");
            WCCMMetaDataUtil.logErrors(mid.ivJ2EEName, errors);
            return;
        }
        TreeSet<String> mergedNames = new TreeSet<String>();
        for (EnterpriseBean mergedBean : mergedBeans) {
            mergedNames.add(mergedBean.getName());
        }
        for (BeanInitData bid : mid.ivBeans) {
            mergedNames.remove(bid.ivName);
        }
        if (!mergedNames.isEmpty()) {
            errors.add("     Merged DD contains extra EJBs named " + mergedNames);
        }
        WCCMMetaDataUtil.logErrors(mid.ivJ2EEName, errors);
    }

    public static void validateMergedXML(BeanMetaData bmd) throws EJBConfigurationException {
        ComponentViewableBean cvb;
        if (!WCCMMetaDataUtil.validationEnabled()) {
            return;
        }
        if (bmd.metadataComplete || bmd.wccm == null || bmd.isManagedBean() || bmd.isEntityBean()) {
            return;
        }
        EJBJar mergedEJBJar = bmd.ivInitData.ivModuleInitData.getMergedEJBJar();
        if (mergedEJBJar == null) {
            return;
        }
        Session msb = null;
        ArrayList<String> errors = new ArrayList<String>();
        EnterpriseBean meb = WCCMMetaData.getEnterpriseBeanNamed(mergedEJBJar, bmd.enterpriseBeanName);
        if (meb == null) {
            errors.add("     Merged DD is missing an EJB named " + bmd.enterpriseBeanName);
            WCCMMetaDataUtil.logErrors(bmd.j2eeName, errors);
            return;
        }
        if (!bmd.enterpriseBeanName.equals(meb.getName())) {
            errors.add("     Merged DD <ejb-name> : " + meb.getName() + ", expected : " + bmd.enterpriseBeanName);
        }
        if (meb instanceof ComponentViewableBean) {
            String mebLocalHomeName;
            cvb = (ComponentViewableBean)meb;
            String mebHomeName = cvb.getHomeInterfaceName();
            if (!WCCMMetaDataUtil.equals(bmd.homeInterfaceClassName, mebHomeName)) {
                errors.add("     Merged DD <home> : " + mebHomeName + ", expected : " + bmd.homeInterfaceClassName);
            }
            if (!WCCMMetaDataUtil.equals(bmd.localHomeInterfaceClassName, mebLocalHomeName = cvb.getLocalHomeInterfaceName())) {
                errors.add("     Merged DD <local-home> : " + mebLocalHomeName + ", expected : " + bmd.localHomeInterfaceClassName);
            }
        }
        if (!bmd.enterpriseBeanClassName.equals(meb.getEjbClassName())) {
            errors.add("     Merged DD <ejb-class> : " + meb.getEjbClassName() + ", expected : " + bmd.enterpriseBeanClassName);
        }
        if (bmd.isSessionBean()) {
            List msbRemoteBusinessClasses;
            Object[] msbRemoteBusiness;
            if (meb.getKindValue() != 0) {
                errors.add("     Merged DD bean type is incorrect, should be <session>");
                WCCMMetaDataUtil.logErrors(bmd.j2eeName, errors);
                return;
            }
            msb = (Session)meb;
            List msbLocalBusinessClasses = msb.getLocalBusinessInterfaceNames();
            Object[] msbLocalBusiness = msbLocalBusinessClasses.toArray(new String[msbLocalBusinessClasses.size()]);
            if (!WCCMMetaDataUtil.setEquals(bmd.ivBusinessLocalInterfaceClassNames, msbLocalBusiness)) {
                errors.add("     Merged DD <business-local> : " + Arrays.toString(msbLocalBusiness) + ", expected : " + Arrays.toString(bmd.ivBusinessLocalInterfaceClassNames));
            }
            if (!WCCMMetaDataUtil.setEquals(bmd.ivBusinessRemoteInterfaceClassNames, msbRemoteBusiness = (msbRemoteBusinessClasses = msb.getRemoteBusinessInterfaceNames()).toArray(new String[msbRemoteBusinessClasses.size()]))) {
                errors.add("     Merged DD <business-remote> : " + Arrays.toString(msbRemoteBusiness) + ", expected : " + Arrays.toString(bmd.ivBusinessRemoteInterfaceClassNames));
            }
            if (bmd.ivLocalBean != msb.isLocalBean()) {
                errors.add("     Merged DD <local-bean> : " + msb.isLocalBean() + ", expected : " + bmd.ivLocalBean);
            }
            int msbSessionType = msb.getSessionTypeValue();
            if (bmd.type == 3 && msbSessionType != 1 || bmd.type == 4 && msbSessionType != 0 || bmd.type == 2 && msbSessionType != 2) {
                String msbTypeStr;
                String string = msbSessionType == -1 ? "unspecified" : (msbSessionType == 2 ? "Singleton" : (msbSessionType == 0 ? "Stateful" : (msbTypeStr = msbSessionType == 1 ? "Stateless" : "unknown")));
                String typeStr = bmd.isStatelessSessionBean() ? "Stateless" : (bmd.isStatefulSessionBean() ? "Stateful" : "Singleton");
                errors.add("     Merged DD <session-type> : " + msbTypeStr + ", expected : " + typeStr);
            }
            int mTxType = msb.getTransactionTypeValue();
            if (bmd.usesBeanManagedTx && mTxType != 0 || !bmd.usesBeanManagedTx && mTxType != 1) {
                String mTxStr = mTxType == -1 ? "unspecified" : (mTxType == 0 ? "Bean" : (mTxType == 1 ? "Container" : "unknown"));
                String txStr = bmd.usesBeanManagedTx ? "Bean" : "Container";
                errors.add("     Merged DD <transaction-type> : " + mTxStr + ", expected : " + txStr);
            }
        }
        if (bmd.fullyInitialized && meb instanceof ComponentViewableBean) {
            String localName;
            String remoteName;
            cvb = (ComponentViewableBean)meb;
            String mebRemoteName = cvb.getRemoteInterfaceName();
            String string = remoteName = bmd.remoteInterfaceClass != null ? bmd.remoteInterfaceClass.getName() : null;
            if (!WCCMMetaDataUtil.equals(remoteName, mebRemoteName)) {
                errors.add("     Merged DD <remote> : " + mebRemoteName + ", expected : " + remoteName);
            }
            String mebLocalName = cvb.getLocalInterfaceName();
            String string2 = localName = bmd.localInterfaceClass != null ? bmd.localInterfaceClass.getName() : null;
            if (!WCCMMetaDataUtil.equals(localName, mebLocalName)) {
                errors.add("     Merged DD <local> : " + mebLocalName + ", expected : " + localName);
            }
            if (msb != null && bmd.sessionTimeout != msb.getStatefulTimeout().getTimeout()) {
                errors.add("     Merged DD <session-timeout> : " + msb.getStatefulTimeout().getTimeout() + ", expected : " + bmd.sessionTimeout);
            }
        }
        WCCMMetaDataUtil.logErrors(bmd.j2eeName, errors);
    }

    static <T> boolean equals(T a, T b) {
        return a == null ? b == null : a.equals(b);
    }

    static <T> boolean setEquals(T[] a, T[] b) {
        if (a == null || a.length == 0) {
            return b == null || b.length == 0;
        }
        return new TreeSet<T>(Arrays.asList(a)).equals(new TreeSet<T>(Arrays.asList(b)));
    }

    private static void logErrors(J2EEName j2eeName, List<String> errors) throws EJBConfigurationException {
        if (errors.size() > 0) {
            String heading = "Merged EJB DD Validation results for " + j2eeName;
            if (ContainerProperties.ValidateMergedXML) {
                System.out.println(heading);
                for (String error : errors) {
                    System.out.println(error);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)heading, (Object[])new Object[0]);
                for (String error : errors) {
                    Tr.debug((TraceComponent)tc, (String)error, (Object[])new Object[0]);
                }
            }
            if (ContainerProperties.ValidateMergedXMLFail) {
                throw new EJBConfigurationException("Merged EJB DD for " + j2eeName + " is not correct. See SystemOut.log for details.");
            }
        }
    }
}

