/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.outbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.CallbackIDs;
import com.ibm.ws.http.channel.internal.outbound.HttpOutboundServiceContextImpl;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.exception.ExpectationFailedException;
import com.ibm.wsspi.http.channel.values.StatusCodes;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import java.io.IOException;

public class HttpOSC100ReadCallback
implements TCPReadCompletedCallback {
    private static final TraceComponent tc = Tr.register(HttpOSC100ReadCallback.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");
    private static final HttpOSC100ReadCallback myInstance = new HttpOSC100ReadCallback();

    private HttpOSC100ReadCallback() {
    }

    public static final HttpOSC100ReadCallback getRef() {
        return myInstance;
    }

    private boolean handleNewData(HttpOutboundServiceContextImpl sc, VirtualConnection vc) {
        if (!sc.headersParsed()) {
            try {
                return sc.parseMessage();
            }
            catch (Exception e) {
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".handleNewData"), (String)"73", (Object)this);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Caught exception: " + e.getMessage()), (Object[])new Object[0]);
                }
                sc.setPersistent(false);
                sc.getAppWriteCallback().error(vc, (Throwable)e);
                return false;
            }
        }
        return true;
    }

    public void complete(VirtualConnection vc, TCPReadRequestContext rsc) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("complete() called: vc=" + vc), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        boolean rc = false;
        while (!rc && null != vc) {
            rc = this.handleNewData(mySC, vc);
            if (rc) continue;
            vc = rsc.read(1L, (TCPReadCompletedCallback)this, false, mySC.getReadTimeout());
        }
        if (rc) {
            StatusCodes status = mySC.getResponse().getStatusCode();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("100-continue scenario received " + status), (Object[])new Object[0]);
            }
            if (status.equals(StatusCodes.CONTINUE)) {
                mySC.resetRead();
                mySC.getAppWriteCallback().complete(vc);
            } else {
                mySC.setPersistent(false);
                mySC.getAppWriteCallback().error(vc, (Throwable)new ExpectationFailedException(status.getIntCode() + " " + mySC.getResponse().getReasonPhrase()));
            }
        }
    }

    public void error(VirtualConnection vc, TCPReadRequestContext rsc, IOException ioe) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("error() called: vc=" + vc + " ioe=" + ioe), (Object[])new Object[0]);
        }
        HttpOutboundServiceContextImpl mySC = (HttpOutboundServiceContextImpl)vc.getStateMap().get(CallbackIDs.CALLBACK_HTTPOSC);
        mySC.setPersistent(false);
        mySC.reConnect(vc, ioe);
    }
}

