/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.srt;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.ServletConnection;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SRTServletConnection
implements ServletConnection {
    protected static final Logger logger = LoggerFactory.getInstance().getLogger("io.openliberty.webcontainer60.srt");
    private static final String CLASS_NAME = SRTServletConnection.class.getName();
    private String connectionID = null;
    private String protocol = null;
    private boolean isSSL = false;

    public SRTServletConnection() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "constructor", "this [" + String.valueOf(this) + "]");
        }
    }

    protected void setConnectionID(String id) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setConnectionID", "this [" + String.valueOf(this) + "] , connection id [" + id + "]");
        }
        this.connectionID = id;
    }

    protected void setConnectionSecure(boolean secure) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setConnectionSecure", "this [" + String.valueOf(this) + "] , secure [" + secure + "]");
        }
        this.isSSL = secure;
    }

    protected void setProtocol(String prot) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "setProtocol", "this [" + String.valueOf(this) + "] , protocol [" + prot + "]");
        }
        this.protocol = prot;
    }

    public String getConnectionId() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getConnectionId", "this [" + String.valueOf(this) + "] , connection id [" + this.connectionID + "]");
        }
        return this.connectionID;
    }

    public String getProtocol() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getProtocol", "this [" + String.valueOf(this) + "] , protocol [" + this.protocol + "]");
        }
        if (this.protocol == null || this.protocol.isBlank()) {
            return "unknown";
        }
        return this.protocol;
    }

    public String getProtocolConnectionId() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "getProtocolConnectionId", "this [" + String.valueOf(this) + "] , return empty string");
        }
        return "";
    }

    public boolean isSecure() {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.logp(Level.FINE, CLASS_NAME, "isSecure", "this [" + String.valueOf(this) + "] , isSecure [" + this.isSSL + "]");
        }
        return this.isSSL;
    }
}

