/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.library.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.library.internal.FilesetListener;
import com.ibm.ws.library.internal.SharedLibraryConstants;
import com.ibm.ws.library.internal.SharedLibraryImpl;
import com.ibm.ws.library.internal.Util;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.artifact.ArtifactContainer;
import com.ibm.wsspi.classloading.ApiType;
import com.ibm.wsspi.config.Fileset;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Dictionary;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
final class LibraryGeneration {
    private static final TraceComponent tc = Tr.register(LibraryGeneration.class, (String)"SharedLibrary", (String)"com.ibm.ws.classloading.internal.resources.ClassLoadingServiceMessages");
    private static final AtomicInteger nextInt = new AtomicInteger();
    private final String libraryId;
    private final int genId = nextInt.getAndIncrement();
    private final Dictionary<? extends String, ? extends Object> libraryProps;
    private final List<? extends String> filesetRefs;
    private final EnumSet<? extends ApiType> apiTypeVisibility;
    private final Collection<? extends File> files;
    private final Collection<? extends File> folders;
    private final Collection<? extends ArtifactContainer> fileAndFolderContainers;
    private final Collection<Fileset> filesets;
    private final ConcurrentLinkedQueue<ServiceRegistration<?>> filesetListenerRegs = new ConcurrentLinkedQueue();
    private volatile boolean cancelled;
    private final SharedLibraryImpl library;
    static final long serialVersionUID = 6965220007121905717L;

    LibraryGeneration(SharedLibraryImpl library, String libraryId, Dictionary<String, Object> props) {
        this.library = library;
        this.libraryId = libraryId;
        Dictionary<String, Object> libraryProps = Util.copy(props);
        this.libraryProps = libraryProps;
        String displayId = (String)props.get("config.displayId");
        if (displayId == null) {
            displayId = this.libraryId;
        }
        String[] fsRefs = null;
        EnumSet<ApiType> apiTypeVisibility = EnumSet.noneOf(ApiType.class);
        String[] fileRef = null;
        String[] folderRef = null;
        String[] pathRef = null;
        block7: for (SharedLibraryConstants.SharedLibraryAttribute attr : SharedLibraryConstants.SharedLibraryAttribute.values()) {
            Object o = props.get(attr.toString());
            switch (attr) {
                case filesetRef: {
                    fsRefs = (String[])o;
                    continue block7;
                }
                case apiTypeVisibility: {
                    apiTypeVisibility = ApiType.createApiTypeSet((String)o);
                    continue block7;
                }
                case fileRef: {
                    fileRef = (String[])o;
                    continue block7;
                }
                case folderRef: {
                    folderRef = (String[])o;
                    continue block7;
                }
                case pathRef: {
                    pathRef = (String[])o;
                    continue block7;
                }
                default: {
                    continue block7;
                }
            }
        }
        Collection<File> files = library.retrieveClasspaths(SharedLibraryImpl.ClasspathType.FILE, libraryId, fileRef, displayId);
        Collection<File> folders = library.retrieveClasspaths(SharedLibraryImpl.ClasspathType.FOLDER, libraryId, folderRef, displayId);
        Collection<File> paths = library.retrieveClasspaths(SharedLibraryImpl.ClasspathType.PATH, libraryId, pathRef, displayId);
        for (File p : paths) {
            if (p.isDirectory()) {
                folders.add(p);
                continue;
            }
            files.add(p);
        }
        this.filesetRefs = fsRefs == null ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(fsRefs));
        this.fileAndFolderContainers = this.initContainers(files, folders);
        this.files = files;
        this.folders = folders;
        this.apiTypeVisibility = apiTypeVisibility;
        this.filesets = this.filesetRefs.isEmpty() ? Collections.emptyList() : new ArrayBlockingQueue<Fileset>(this.filesetRefs.size());
    }

    private List<ArtifactContainer> initContainers(Collection<File> files, Collection<File> folders) {
        if (files.isEmpty() && folders.isEmpty()) {
            return Collections.emptyList();
        }
        LinkedList<ArtifactContainer> result = new LinkedList<ArtifactContainer>();
        for (File f : files) {
            if (!Util.isArchive(f)) continue;
            this.addContainerFromFile(f, result);
        }
        for (File f : folders) {
            this.addContainerFromFile(f, result);
        }
        return result;
    }

    void addContainerFromFile(File f, Collection<ArtifactContainer> containers) {
        ArtifactContainer ac;
        String filename = String.format("%s/%s_%s_%s", "libcont", this.libraryId, this.genId, f.getName());
        File wc = this.library.ctx.getBundle().getDataFile(filename);
        boolean ok = wc.mkdir();
        if (!ok && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"cannot create cache dir for container:", (Object[])new Object[]{f.getName()});
        }
        if ((ac = this.library.artifactContainerFactory.getContainer(wc, (Object)f)) != null) {
            containers.add(ac);
        }
    }

    void cancel() {
        ServiceRegistration<?> listener;
        this.cancelled = true;
        while ((listener = this.filesetListenerRegs.poll()) != null) {
            listener.unregister();
        }
    }

    void fetchFilesets() {
        if (this.isCancelled() || this.library.isDeleted()) {
            return;
        }
        if (this.filesetRefs.isEmpty()) {
            this.library.publishGeneration(this);
        } else {
            new FilesetListener(this.library, this, this.filesetRefs, this.filesets, this.filesetListenerRegs);
        }
    }

    EnumSet<ApiType> getApiTypeVisibility() {
        return EnumSet.copyOf(this.apiTypeVisibility);
    }

    Collection<File> getFiles() {
        return Util.freeze(this.files);
    }

    Collection<File> getFolders() {
        return Util.freeze(this.folders);
    }

    Collection<Fileset> getFilesets() {
        return Util.freeze(this.filesets);
    }

    Collection<ArtifactContainer> getContainers() {
        if (this.filesets.isEmpty()) {
            return Util.freeze(this.fileAndFolderContainers);
        }
        ArrayList<ArtifactContainer> result = new ArrayList<ArtifactContainer>(this.fileAndFolderContainers);
        for (Fileset fset : this.filesets) {
            for (File f : fset.getFileset()) {
                this.addContainerFromFile(f, result);
            }
        }
        return Util.freeze(result);
    }

    Dictionary<String, Object> getProperties() {
        return Util.copy(this.libraryProps);
    }

    boolean isCancelled() {
        return this.cancelled;
    }

    String getLibraryId() {
        return this.libraryId;
    }
}

