/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.xml.interceptor;

import java.util.ResourceBundle;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.xml.XMLFault;
import org.apache.cxf.common.i18n.BundleUtils;
import org.apache.cxf.helpers.NSStack;
import org.apache.cxf.interceptor.AbstractOutDatabindingInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.staxutils.StaxUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XMLFaultOutInterceptor
extends AbstractOutDatabindingInterceptor {
    private static final ResourceBundle BUNDLE = BundleUtils.getBundle(XMLFaultOutInterceptor.class);

    public XMLFaultOutInterceptor() {
        super("marshal");
    }

    public XMLFaultOutInterceptor(String phase) {
        super(phase);
    }

    public void handleMessage(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
        Fault f = (Fault)message.getContent(Exception.class);
        message.put((Object)Message.RESPONSE_CODE, (Object)f.getStatusCode());
        NSStack nsStack = new NSStack();
        nsStack.push();
        XMLStreamWriter writer = (XMLStreamWriter)message.getContent(XMLStreamWriter.class);
        XMLFault xmlFault = XMLFault.createFault(f);
        try {
            nsStack.add("http://cxf.apache.org/bindings/xformat");
            String prefix = nsStack.getPrefix("http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"XMLFault", (String)"http://cxf.apache.org/bindings/xformat");
            StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"faultstring", (String)"http://cxf.apache.org/bindings/xformat");
            Throwable t = xmlFault.getCause();
            writer.writeCharacters(t == null ? xmlFault.getMessage() : t.toString());
            writer.writeEndElement();
            if (xmlFault.getDetail() != null) {
                Element detail = xmlFault.getDetail();
                StaxUtils.writeStartElement((XMLStreamWriter)writer, (String)prefix, (String)"detail", (String)"http://cxf.apache.org/bindings/xformat");
                for (Node node = detail.getFirstChild(); node != null; node = node.getNextSibling()) {
                    StaxUtils.writeNode((Node)node, (XMLStreamWriter)writer, (boolean)false);
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (XMLStreamException xe) {
            throw new Fault(new org.apache.cxf.common.i18n.Message("XML_WRITE_EXC", BUNDLE, new Object[0]), (Throwable)xe);
        }
    }

    public void handleFault(Message message) throws Fault {
        if (this.mustPropogateException(message)) {
            throw (Fault)message.getContent(Exception.class);
        }
    }

    protected boolean mustPropogateException(Message m) {
        return Boolean.TRUE.equals(m.getExchange().get((Object)Message.PROPOGATE_EXCEPTION));
    }
}

