/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.trm.topology;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.sib.trm.topology.Cellule;
import com.ibm.ws.sib.trm.topology.InvalidBytesException;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.nio.charset.StandardCharsets;

public final class LinkCellule
extends Cellule {
    private static final String className = LinkCellule.class.getName();
    private static final TraceComponent tc = SibTr.register(LinkCellule.class, (String)"SIBTrm", (String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS((String)"com.ibm.ws.sib.trm.CWSITMessages");
    private static final String DELIM = ":";
    private final String subnet1;
    private final String subnet2;
    private int hashcode;

    public LinkCellule(String subnet1, String subnet2) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkCellule", (Object)new Object[]{subnet1, subnet2});
        }
        if (subnet1 == null) {
            throw new NullPointerException(nls.getFormattedMessage("NULL_USED_TO_CREATE_CWSIT0012", new Object[]{"String (subnet1)", "LinkCellule"}, null));
        }
        if (subnet2 == null) {
            throw new NullPointerException(nls.getFormattedMessage("NULL_USED_TO_CREATE_CWSIT0012", new Object[]{"String (subnet2)", "LinkCellule"}, null));
        }
        this.subnet1 = subnet1;
        this.subnet2 = subnet2;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkCellule", (Object)this);
        }
    }

    public LinkCellule(byte[] b) throws InvalidBytesException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"LinkCellule", (Object)new Object[]{b});
        }
        if (b[0] == 1) {
            String cellule = new String(b, 1, b.length - 1, StandardCharsets.UTF_8);
            int os = cellule.indexOf(DELIM);
            if (os > 0) {
                this.subnet1 = cellule.substring(0, os);
                this.subnet2 = cellule.substring(os + 1);
            } else if (os == 0) {
                this.subnet1 = "";
                this.subnet2 = cellule.substring(os + 1);
            } else {
                this.subnet1 = cellule;
                this.subnet2 = "";
            }
        } else {
            throw new InvalidBytesException(nls.getFormattedMessage("INVALID_BYTE_VALUE_CWSIT0053", new Object[]{(byte)1, b[0]}, null));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"LinkCellule", (Object)this);
        }
    }

    @Override
    public byte[] getBytes() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getBytes");
        }
        byte[] b = this.string().getBytes(StandardCharsets.UTF_8);
        byte[] c = new byte[b.length + 1];
        c[0] = 1;
        for (int i = 0; i < b.length; ++i) {
            c[i + 1] = b[i];
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getBytes", (Object)c);
        }
        return c;
    }

    public String getSubnet1() {
        return this.subnet1;
    }

    public String getSubnet2() {
        return this.subnet2;
    }

    private String string() {
        return this.subnet1 + DELIM + this.subnet2;
    }

    @Override
    public boolean equals(Object o) {
        boolean rc = false;
        if (o instanceof LinkCellule) {
            LinkCellule l = (LinkCellule)o;
            rc = this.subnet1.equals(l.subnet1) && this.subnet2.equals(l.subnet2);
        }
        return rc;
    }

    @Override
    public int hashCode() {
        if (this.hashcode == 0) {
            this.hashcode = this.string().hashCode();
        }
        return this.hashcode;
    }

    @Override
    public String toString() {
        return "[" + this.string() + "]";
    }
}

