/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.install.internal.asset;

import com.ibm.ws.install.InstallException;
import com.ibm.ws.install.internal.InstallLogUtils;
import com.ibm.ws.install.internal.InstallUtils;
import com.ibm.ws.install.internal.asset.InstallAsset;
import com.ibm.ws.install.internal.asset.ServerAsset;
import com.ibm.ws.install.internal.asset.ServerPackageAsset;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;

public class ServerPackageZipAsset
extends InstallAsset
implements ServerPackageAsset {
    public static final String ZIP_EXT = ".zip";
    public static final String PAX_EXT = ".pax";
    private final Collection<ServerAsset> servers = new HashSet<ServerAsset>();
    private final Collection<String> requiredFeatures = new HashSet<String>();
    private final ZipFile zip;

    public ServerPackageZipAsset(File assetFile, boolean temporary) throws InstallException {
        super(assetFile, temporary);
        try {
            this.zip = new ZipFile(assetFile);
        }
        catch (ZipException ze) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsoluteFile()), ze, 25);
        }
        catch (IOException ioe) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsoluteFile()), ioe, 25);
        }
        this.processServers();
    }

    @Override
    public boolean isServerPackage() {
        return true;
    }

    public static boolean validType(String filename) {
        return filename != null && (filename.toLowerCase().endsWith(ZIP_EXT) || filename.toLowerCase().endsWith(PAX_EXT));
    }

    @Override
    public Collection<ServerAsset> getServers() {
        return Collections.unmodifiableCollection(this.servers);
    }

    @Override
    public Collection<String> getRequiredFeatures() {
        return Collections.unmodifiableCollection(this.requiredFeatures);
    }

    @Override
    public Enumeration<? extends ZipEntry> getPackageEntries() {
        return this.zip.entries();
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        return this.zip.getInputStream(entry);
    }

    @Override
    public void delete() {
        InstallUtils.close(this.zip);
        super.delete();
    }

    private void processServers() throws InstallException {
        Enumeration<? extends ZipEntry> zipEntries = this.zip.entries();
        while (zipEntries.hasMoreElements()) {
            ZipEntry nextEntry = zipEntries.nextElement();
            String entryName = nextEntry.getName().toLowerCase();
            if (nextEntry.isDirectory()) {
                if (!entryName.startsWith("wlp/bin/")) continue;
                throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_SERVER_PACKAGE_CONTAINS_RUNTIME", this.getAsset().getAbsolutePath()));
            }
            if (!entryName.contains("/servers/") || !entryName.endsWith("/server.xml")) continue;
            String[] dirs = nextEntry.getName().split("/");
            String serverName = dirs[dirs.length - 2];
            File serverDir = new File(InstallUtils.getServersDir(), serverName);
            File serverXML = new File(serverDir, "server.xml");
            this.servers.add(new ServerAsset(serverName, serverXML));
        }
        if (this.servers.isEmpty()) {
            throw new InstallException(InstallLogUtils.Messages.INSTALL_KERNEL_MESSAGES.getLogMessage("ERROR_INVALID_SERVER_PACKAGE", this.getAsset().getAbsolutePath()));
        }
    }
}

