/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.netty.internal.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.netty.channel.Channel;
import io.netty.channel.group.ChannelGroup;
import io.openliberty.netty.internal.impl.NettyFrameworkImpl;
import java.util.Set;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettyQuiesceListener {
    private static final TraceComponent tc = Tr.register(NettyQuiesceListener.class, (String)"Netty", (String)"io.openliberty.netty.internal.impl.resources.NettyFrameworkMessages");
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> quiesceFinishTask;
    private ScheduledFuture<?> quiesceVerifierTask;
    private long quiesceTimeout = 0L;
    private Runnable quiesceTask = null;
    private NettyFrameworkImpl bundle;
    static final long serialVersionUID = 4398790980305600125L;

    public NettyQuiesceListener(NettyFrameworkImpl nettyBundle, ScheduledExecutorService scheduler, long timeout) {
        this.bundle = nettyBundle;
        this.scheduler = scheduler;
        this.quiesceTimeout = timeout > 0L ? timeout : 0L;
    }

    public ScheduledFuture<?> startTasks() {
        this.quiesceFinishTask = this.scheduler.schedule(() -> {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("The quiesceFinishTask has started for " + this.bundle + ". Quiesce task will be scheduled to run for: " + this.bundle), (Object[])new Object[0]);
            }
            if (this.quiesceTask != null) {
                this.scheduler.schedule(this.quiesceTask, 0L, TimeUnit.MILLISECONDS);
            }
            if (!this.quiesceVerifierTask.isDone()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"The quiesceVerifierTask was found not to be done. Cancelling it...", (Object[])new Object[0]);
                }
                this.quiesceVerifierTask.cancel(true);
            }
        }, this.quiesceTimeout, TimeUnit.MILLISECONDS);
        this.quiesceVerifierTask = this.scheduler.scheduleAtFixedRate(() -> {
            Set<Channel> activeChannels;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The quiesceVerifierTask has started,  checking endpoints...", (Object[])new Object[0]);
            }
            if ((activeChannels = this.bundle.getActiveChannels()).isEmpty()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("No active connections have been found. Scheduling quiesce task and cancelling quiesce verifiers for: " + this.bundle), (Object[])new Object[0]);
                }
                if (this.quiesceTask != null) {
                    this.scheduler.schedule(this.quiesceTask, 0L, TimeUnit.MILLISECONDS);
                }
                if (!this.quiesceFinishTask.isDone()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The quiesceFinishTask was found not to be done. Cancelling it...", (Object[])new Object[0]);
                    }
                    this.quiesceFinishTask.cancel(true);
                }
                if (!this.quiesceVerifierTask.isDone()) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The quiesceVerifierTask was found not to be done. Cancelling it...", (Object[])new Object[0]);
                    }
                    this.quiesceVerifierTask.cancel(true);
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Remaining endpoints still running. Verifying which can be closed...", (Object[])new Object[0]);
                }
                for (Channel endpoint : activeChannels) {
                    ChannelGroup group = this.bundle.getActiveChannelsMap().get(endpoint);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Found group " + group + " for endpoint " + endpoint), (Object[])new Object[0]);
                    }
                    if (group == null || !group.isEmpty()) continue;
                    this.bundle.stop(endpoint);
                }
            }
        }, 1000L, 1000L, TimeUnit.MILLISECONDS);
        return this.quiesceFinishTask;
    }

    public void setQuiesceTask(Runnable task) {
        this.quiesceTask = task;
    }

    public void cancelTasks() {
        if (this.quiesceFinishTask != null) {
            this.quiesceFinishTask.cancel(true);
        }
        if (this.quiesceVerifierTask != null) {
            this.quiesceVerifierTask.cancel(true);
        }
    }
}

