/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ejs.container;

import com.ibm.ejs.container.BindingData;
import com.ibm.ejs.container.ContainerProperties;
import com.ibm.ejs.container.HomeRecord;
import com.ibm.websphere.csi.J2EEName;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ejbcontainer.util.AmbiguousEJBRefReferenceFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.naming.NameAlreadyBoundException;
import javax.naming.Reference;

public class BindingsHelper {
    private static final TraceComponent tc = Tr.register(BindingsHelper.class, (String)"EJBContainer", (String)"com.ibm.ejs.container.container");
    static final HashMap<String, BindingData> cvAllRemoteBindings = new HashMap();
    static final HashMap<String, BindingData> cvAllLocalBindings = new HashMap();
    public final List<String> ivEJBLocalBindings = new ArrayList<String>();
    public final List<String> ivLocalColonBindings = new ArrayList<String>();
    public final List<String> ivRemoteBindings = new ArrayList<String>();
    private final HomeRecord ivHomeRecord;
    private final HashMap<String, BindingData> ivServerContextBindingMap;
    private final HashMap<String, String> ivEjbContextBindingMap;
    private final HashSet<String> ivEjbContextShortDefaultJndiNames;
    private final HashMap<String, Reference> ivEjbContextAmbiguousMap;
    private final String ivContextPrefix;
    private String ivDefaultJNDIPrefix = null;

    private BindingsHelper(HomeRecord homeRecord, HashMap<String, BindingData> serverContextBindingMap, String contextPrefix) {
        this.ivHomeRecord = homeRecord;
        this.ivServerContextBindingMap = serverContextBindingMap;
        this.ivEjbContextBindingMap = new HashMap();
        this.ivEjbContextShortDefaultJndiNames = new HashSet();
        this.ivEjbContextAmbiguousMap = new HashMap();
        this.ivContextPrefix = contextPrefix;
    }

    public void addBinding(String interfaceName, String specificBindingName) throws NameAlreadyBoundException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addBinding: " + interfaceName + ", " + specificBindingName), (Object[])new Object[0]);
        }
        this.addToServerContextBindingMap(interfaceName, specificBindingName);
        this.ivEjbContextBindingMap.put(interfaceName, specificBindingName);
    }

    public String getBinding(String interfaceName) {
        return this.ivEjbContextBindingMap.get(interfaceName);
    }

    public Collection<String> getBindings() {
        return this.ivEjbContextBindingMap.values();
    }

    public void removeEjbBindings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeEjbBindings called", (Object[])new Object[0]);
        }
        for (String bindingName : this.ivEjbContextBindingMap.values()) {
            this.removeFromServerContextBindingMap(bindingName, true);
        }
        this.ivEjbContextBindingMap.clear();
    }

    public boolean hasShortDefaultBinding(String interfaceName) {
        return this.ivEjbContextShortDefaultJndiNames.contains(interfaceName);
    }

    public boolean isUniqueShortDefaultBinding(String interfaceName) {
        BindingData bdata = this.ivServerContextBindingMap.get(interfaceName);
        return bdata != null && bdata.ivExplicitBean == null && bdata.ivImplicitBeans != null && bdata.ivImplicitBeans.size() == 1;
    }

    public Collection<String> getShortDefaultBindings() {
        return this.ivEjbContextShortDefaultJndiNames;
    }

    public void removeShortDefaultBindings() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeShortDefaultBindings called", (Object[])new Object[0]);
        }
        for (String bindingName : this.ivEjbContextShortDefaultJndiNames) {
            this.removeFromServerContextBindingMap(bindingName, false);
        }
        this.ivEjbContextShortDefaultJndiNames.clear();
    }

    public HashMap<String, Reference> getAmbiguousReferenceMap() {
        return this.ivEjbContextAmbiguousMap;
    }

    public ArrayList<String> generateBindings(String interfaceName, String specificBindingName, boolean generateDisambiguatedSimpleBindingNames) throws NameAlreadyBoundException {
        ArrayList<String> jndiNamesToBind;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("generateBindings: " + interfaceName + ", " + specificBindingName + ", " + generateDisambiguatedSimpleBindingNames), (Object[])new Object[0]);
        }
        if (specificBindingName == null) {
            String simpleBindingName = this.ivHomeRecord.getBeanMetaData().simpleJndiBindingName;
            if (simpleBindingName == null) {
                jndiNamesToBind = this.generateDefaultEjbBindings(interfaceName);
            } else {
                if (generateDisambiguatedSimpleBindingNames) {
                    Reference ambiguousRef = this.ivEjbContextAmbiguousMap.get(simpleBindingName);
                    if (ambiguousRef == null) {
                        this.addAmbiguousSimpleBindingName(simpleBindingName);
                        this.addToServerContextBindingMap(interfaceName, simpleBindingName);
                        this.ivEjbContextBindingMap.put("#" + interfaceName, simpleBindingName);
                    }
                    StringBuilder sb = new StringBuilder(simpleBindingName);
                    sb.append("#").append(interfaceName);
                    simpleBindingName = sb.toString();
                }
                jndiNamesToBind = new ArrayList(1);
                jndiNamesToBind.add(simpleBindingName);
                this.addToServerContextBindingMap(interfaceName, simpleBindingName);
                this.ivEjbContextBindingMap.put(interfaceName, simpleBindingName);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("using simple binding : " + simpleBindingName), (Object[])new Object[0]);
                }
            }
        } else {
            jndiNamesToBind = new ArrayList<String>(1);
            jndiNamesToBind.add(specificBindingName);
            this.addToServerContextBindingMap(interfaceName, specificBindingName);
            this.ivEjbContextBindingMap.put(interfaceName, specificBindingName);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("using specific bindings : " + specificBindingName), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)("generateBindings: " + jndiNamesToBind));
        }
        return jndiNamesToBind;
    }

    private ArrayList<String> generateDefaultEjbBindings(String interfaceName) throws NameAlreadyBoundException {
        ArrayList<String> defaultJNDINames = new ArrayList<String>(2);
        StringBuilder sb = new StringBuilder(256);
        if (this.ivDefaultJNDIPrefix == null) {
            if (this.ivContextPrefix != null) {
                sb.append(this.ivContextPrefix);
            }
            if (this.ivHomeRecord.bmd.ivComponent_Id != null) {
                sb.append(this.ivHomeRecord.bmd.ivComponent_Id).append("#");
            } else {
                sb.append(this.ivHomeRecord.j2eeName.getApplication()).append("/");
                sb.append(this.ivHomeRecord.j2eeName.getModule()).append("/");
                sb.append(this.ivHomeRecord.j2eeName.getComponent()).append("#");
            }
            this.ivDefaultJNDIPrefix = sb.toString();
        } else {
            sb.append(this.ivDefaultJNDIPrefix);
        }
        sb.append(interfaceName);
        String longBindingName = sb.toString();
        defaultJNDINames.add(longBindingName);
        this.addToServerContextBindingMap(interfaceName, longBindingName);
        this.ivEjbContextBindingMap.put(interfaceName, longBindingName);
        if (this.ivHomeRecord.shortDefaultBindingsEnabled()) {
            BindingData bdata = this.ivServerContextBindingMap.get(interfaceName);
            this.addToServerContextBindingMap(interfaceName);
            this.ivEjbContextShortDefaultJndiNames.add(interfaceName);
            if (bdata == null) {
                defaultJNDINames.add(interfaceName);
            } else if (bdata.ivExplicitBean == null) {
                this.addAmbiguousShortDefaultBindingName(interfaceName);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("generateDefaultEjbBindings: " + interfaceName + " short-form default overridden : " + bdata.ivExplicitBean), (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("generateDefaultEjbBindings: " + defaultJNDINames), (Object[])new Object[0]);
        }
        return defaultJNDINames;
    }

    private void addAmbiguousSimpleBindingName(String simpleBindingName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding AmbiguousEJBReference for simple-binding-name '" + simpleBindingName + "', for EJB " + this.ivHomeRecord.getJ2EEName()), (Object[])new Object[0]);
        }
        Reference ambiguousReference = AmbiguousEJBRefReferenceFactory.createAmbiguousReference(simpleBindingName, this.ivHomeRecord.getJ2EEName());
        this.ivEjbContextAmbiguousMap.put(simpleBindingName, ambiguousReference);
    }

    private void addAmbiguousShortDefaultBindingName(String shortBindingName) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("adding AmbiguousEJBReference for short default binding name '" + shortBindingName + "', for EJB " + this.ivHomeRecord.getJ2EEName()), (Object[])new Object[0]);
        }
        ArrayList<J2EEName> beans = null;
        BindingData bdata = this.ivServerContextBindingMap.get(shortBindingName);
        if (bdata != null) {
            beans = bdata.ivImplicitBeans;
        }
        Reference ambiguousReference = AmbiguousEJBRefReferenceFactory.createAmbiguousReference(shortBindingName, beans);
        this.ivEjbContextAmbiguousMap.put(shortBindingName, ambiguousReference);
    }

    private void addToServerContextBindingMap(String interfaceName, String bindingName) throws NameAlreadyBoundException {
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addToServerContextBindingMap : " + interfaceName + ", binding : " + bindingName), (Object[])new Object[0]);
        }
        if ((bdata = this.ivServerContextBindingMap.get(bindingName)) == null) {
            bdata = new BindingData();
            this.ivServerContextBindingMap.put(bindingName, bdata);
        }
        if (bdata.ivExplicitBean == null) {
            bdata.ivExplicitBean = this.ivHomeRecord.j2eeName;
            bdata.ivExplicitInterface = interfaceName;
            if (bdata.ivImplicitBeans != null && bdata.ivImplicitBeans.size() > 1) {
                this.ivEjbContextAmbiguousMap.remove(interfaceName);
            }
        } else {
            J2EEName j2eeName = this.ivHomeRecord.j2eeName;
            if (bdata.ivExplicitBean.equals(j2eeName)) {
                Tr.error((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_FOR_SAME_EJB_CNTR0173E", (Object[])new Object[]{interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), bindingName, bdata.ivExplicitInterface});
                String message = "The " + interfaceName + " interface of the " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application cannot be bound to the " + bindingName + " name location. The " + bdata.ivExplicitInterface + " interface of the same bean has already been bound to the " + bindingName + " name location.";
                throw new NameAlreadyBoundException(message);
            }
            Tr.error((TraceComponent)tc, (String)"NAME_ALREADY_BOUND_FOR_EJB_CNTR0172E", (Object[])new Object[]{interfaceName, j2eeName.getComponent(), j2eeName.getModule(), j2eeName.getApplication(), bindingName, bdata.ivExplicitInterface, bdata.ivExplicitBean.getComponent(), bdata.ivExplicitBean.getModule(), bdata.ivExplicitBean.getApplication()});
            String message = "The " + interfaceName + " interface of the " + j2eeName.getComponent() + " bean in the " + j2eeName.getModule() + " module of the " + j2eeName.getApplication() + " application cannot be bound to the " + bindingName + " name location. The " + bdata.ivExplicitInterface + " interface of the " + bdata.ivExplicitBean.getComponent() + " bean in the " + bdata.ivExplicitBean.getModule() + " module of the " + bdata.ivExplicitBean.getApplication() + " application has already been bound to the " + bindingName + " name location.";
            throw new NameAlreadyBoundException(message);
        }
    }

    private void addToServerContextBindingMap(String interfaceName) {
        ArrayList<J2EEName> beans;
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("addToServerContextBindingMap : " + interfaceName + " (implicit)"), (Object[])new Object[0]);
        }
        if ((bdata = this.ivServerContextBindingMap.get(interfaceName)) == null) {
            bdata = new BindingData();
            this.ivServerContextBindingMap.put(interfaceName, bdata);
        }
        if ((beans = bdata.ivImplicitBeans) != null) {
            beans.add(this.ivHomeRecord.j2eeName);
        } else {
            beans = new ArrayList(1);
            beans.add(this.ivHomeRecord.j2eeName);
            bdata.ivImplicitBeans = beans;
        }
    }

    private void removeFromServerContextBindingMap(String bindingName, boolean explicit) {
        BindingData bdata;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("removeFromServerContextBindingMap : " + bindingName + ", explicit : " + explicit), (Object[])new Object[0]);
        }
        if ((bdata = this.ivServerContextBindingMap.get(bindingName)) != null) {
            if (explicit) {
                if (this.ivHomeRecord.j2eeName.equals(bdata.ivExplicitBean)) {
                    bdata.ivExplicitBean = null;
                    bdata.ivExplicitInterface = null;
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("removeFromServerContextBindingMap : ERROR : explicit binding for different bean : " + bdata.ivExplicitBean), (Object[])new Object[0]);
                }
            } else if (bdata.ivImplicitBeans != null) {
                bdata.ivImplicitBeans.remove(this.ivHomeRecord.j2eeName);
                if (bdata.ivImplicitBeans.size() == 0) {
                    bdata.ivImplicitBeans = null;
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"removeFromServerContextBindingMap : ERROR : no implicit binding", (Object[])new Object[0]);
            }
            if (bdata.ivExplicitBean == null && bdata.ivImplicitBeans == null) {
                this.ivServerContextBindingMap.remove(bindingName);
            }
        } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"removeFromServerContextBindingMap : ERROR : no binding data", (Object[])new Object[0]);
        }
    }

    public static Boolean shortDefaultBindingsEnabled(String appName) {
        if (ContainerProperties.DisableShortDefaultBindings != null) {
            if (ContainerProperties.DisableShortDefaultBindings.size() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Short form default binding disabled for application : " + appName), (Object[])new Object[0]);
                }
                return Boolean.FALSE;
            }
            for (String disabledApp : ContainerProperties.DisableShortDefaultBindings) {
                if (!appName.equalsIgnoreCase(disabledApp)) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Short form default binding explicity disabled for application : " + appName), (Object[])new Object[0]);
                }
                return Boolean.FALSE;
            }
        }
        return Boolean.TRUE;
    }

    public static BindingsHelper getLocalHelper(HomeRecord homeRecord) {
        if (homeRecord.ivLocalBindingsHelper == null) {
            homeRecord.ivLocalBindingsHelper = new BindingsHelper(homeRecord, cvAllLocalBindings, null);
        }
        return homeRecord.ivLocalBindingsHelper;
    }

    public static BindingsHelper getRemoteHelper(HomeRecord homeRecord) {
        if (homeRecord.ivRemoteBindingsHelper == null) {
            homeRecord.ivRemoteBindingsHelper = new BindingsHelper(homeRecord, cvAllRemoteBindings, "ejb/");
        }
        return homeRecord.ivRemoteBindingsHelper;
    }
}

