/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.netty.inbound;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class NettySSLConnectionContext
implements SSLConnectionContext {
    protected static final TraceComponent tc = Tr.register(NettySSLConnectionContext.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    private final Channel channel;
    private final boolean isOutbound;
    private String alpnProtocol;
    static final long serialVersionUID = -2492003996503801115L;

    public NettySSLConnectionContext(Channel channel, boolean isOutbound) {
        this.channel = channel;
        this.isOutbound = isOutbound;
    }

    private SslHandler getSslHandler() {
        return (SslHandler)this.channel.pipeline().get(SslHandler.class);
    }

    public String[] getEnabledCipherSuites() {
        return this.getSslHandler().engine().getEnabledCipherSuites();
    }

    public String[] getEnabledProtocols() {
        return this.getSslHandler().engine().getEnabledProtocols();
    }

    public void setEnabledProtocols(String[] protocols) {
        this.getSslHandler().engine().setEnabledProtocols(protocols);
    }

    public boolean getEnableSessionCreation() {
        return this.getSslHandler().engine().getEnableSessionCreation();
    }

    public boolean getNeedClientAuth() {
        return this.getSslHandler().engine().getNeedClientAuth();
    }

    public SSLSession getSession() {
        return this.getSslHandler().engine().getSession();
    }

    public boolean getUseClientMode() {
        return this.getSslHandler().engine().getUseClientMode();
    }

    public boolean getWantClientAuth() {
        return this.getSslHandler().engine().getWantClientAuth();
    }

    public void setEnabledCipherSuites(String[] suites) throws SSLException {
        if (!this.isOutbound) {
            throw new SSLException("Error, established setting cannot be modified.");
        }
        this.getSslHandler().engine().setEnabledCipherSuites(suites);
    }

    public void setEnableSessionCreation(boolean flag) throws SSLException {
        if (!this.isOutbound) {
            throw new SSLException("error, established setting cannot be modified.");
        }
        this.getSslHandler().engine().setEnableSessionCreation(flag);
    }

    public void setNeedClientAuth(boolean need) throws SSLException {
        if (!this.isOutbound) {
            throw new SSLException("Error, established setting cannot be modified.");
        }
        this.getSslHandler().engine().setNeedClientAuth(need);
    }

    public void setWantClientAuth(boolean want) throws SSLException {
        if (!this.isOutbound) {
            throw new SSLException("Error, established setting cannot be modificed.");
        }
        this.getSslHandler().engine().setWantClientAuth(want);
    }

    public void setUseClientMode(boolean mode) throws SSLException {
        if (!this.isOutbound) {
            throw new SSLException("Error, established setting cannot be modified.");
        }
        this.getSslHandler().engine().setUseClientMode(mode);
    }

    /*
     * WARNING - void declaration
     */
    public void renegotiate() {
        block2: {
            try {
                this.getSslHandler().engine().beginHandshake();
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.http.netty.inbound.NettySSLConnectionContext", (String)"141", (Object)this, (Object[])new Object[0]);
                FFDCFilter.processException((Throwable)e, (String)(this.getClass().getName() + ".renegotiate"), (String)"1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                Tr.debug((TraceComponent)tc, (String)("Error while attempting handshake renegotiation; " + e), (Object[])new Object[0]);
            }
        }
    }

    public String getAlpnProtocol() {
        return this.alpnProtocol;
    }

    public void setAlpnProtocol(String protocol) {
        this.alpnProtocol = protocol;
    }
}

