/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jsp.runtime;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.jsp.runtime.TagArray;
import com.ibm.ws.jsp.taglib.annotation.AnnotationHandler;
import jakarta.servlet.ServletContextEvent;
import jakarta.servlet.ServletContextListener;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
public class ContextListener
implements ServletContextListener {
    private static Logger logger = Logger.getLogger("com.ibm.ws.jsp");
    private boolean isUseThreadTagPool;
    private static final String CLASS_NAME = "com.ibm.ws.jsp.runtime.ContextListener";
    static final long serialVersionUID = -8516086234515443613L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public ContextListener() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "<init>", new Object[0]);
        }
        this.isUseThreadTagPool = false;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void setIsUseThreadTagPool(boolean b) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "setIsUseThreadTagPool", new Object[]{b});
        }
        this.isUseThreadTagPool = b;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "setIsUseThreadTagPool");
        }
    }

    @ManualTrace
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void contextDestroyed(ServletContextEvent event) {
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "contextDestroyed", "event = [" + event + "] for context: [" + event.getServletContext().getServletContextName() + "]");
        }
        if (this.isUseThreadTagPool) {
            Map webAppPoolMap = (Map)event.getServletContext().getAttribute("com.ibm.ws.jsp.tagpoolmap");
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "webAppPoolMap = [" + webAppPoolMap + "]");
            }
            if (webAppPoolMap != null) {
                for (Integer threadId : webAppPoolMap.keySet()) {
                    Map m = (Map)webAppPoolMap.get(threadId);
                    if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "threadId = [" + threadId + "]");
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "map from webAppPoolMap = [" + m + "]");
                    }
                    if (m == null) continue;
                    for (String tagKey : m.keySet()) {
                        TagArray tagArray = (TagArray)m.get(tagKey);
                        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                            logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "tagKey = [" + tagKey + "]");
                            logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "tagArray = [" + tagArray + "]");
                        }
                        if (tagArray == null) continue;
                        tagArray.releaseTags();
                        tagArray = null;
                        if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                        logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "released tags and set tagArray to null");
                    }
                    m.clear();
                    m = null;
                    if (!TraceComponent.isAnyTracingEnabled() || !logger.isLoggable(Level.FINER)) continue;
                    logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "cleared map and set map to null");
                }
                webAppPoolMap.clear();
                webAppPoolMap = null;
                event.getServletContext().removeAttribute("com.ibm.ws.jsp.tagpoolmap");
                if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                    logger.logp(Level.FINER, CLASS_NAME, "contextDestroyed", "cleared webAppPoolMap, set webAppPoolMap to null and removed attribute from servletcontext [com.ibm.ws.jsp.tagpoolmap]");
                }
            }
        }
        AnnotationHandler annotationHandlerRemoved = AnnotationHandler.removeAnnotationHandler(event.getServletContext());
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
            if (annotationHandlerRemoved != null) {
                logger.exiting(CLASS_NAME, "contextDestroyed", "cleared Annotation for Servlet Context.");
            } else {
                logger.exiting(CLASS_NAME, "contextDestroyed", "no Annotation for Servlet Context found.");
            }
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void contextInitialized(ServletContextEvent event) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering(CLASS_NAME, "contextInitialized", new Object[]{event});
        }
        if (this.isUseThreadTagPool) {
            event.getServletContext().setAttribute("com.ibm.ws.jsp.tagpoolmap", new HashMap());
            if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINER)) {
                logger.logp(Level.FINER, CLASS_NAME, "contextInitialized", "set attribute on servletcontext = [com.ibm.ws.jsp.tagpoolmap]  for context: [" + event.getServletContext().getServletContextName() + "]");
            }
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting(CLASS_NAME, "contextInitialized");
        }
    }
}

