/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.jbatch.container.ws;

import com.ibm.jbatch.container.jsl.ModelResolverFactory;
import com.ibm.jbatch.container.modelresolver.PropertyResolver;
import com.ibm.jbatch.container.modelresolver.PropertyResolverFactory;
import com.ibm.jbatch.container.persistence.jpa.JobInstanceEntity;
import com.ibm.jbatch.container.services.IPersistenceManagerService;
import com.ibm.jbatch.container.servicesmanager.ServicesManagerStaticAnchor;
import com.ibm.jbatch.container.ws.InstanceState;
import com.ibm.jbatch.container.ws.WSJobInstance;
import com.ibm.jbatch.container.ws.WSPartitionStepThreadExecution;
import com.ibm.jbatch.container.ws.WSStepThreadExecutionAggregate;
import com.ibm.jbatch.container.ws.impl.StringUtils;
import com.ibm.jbatch.jsl.model.JSLJob;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.List;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.batch.operations.JobExecutionAlreadyCompleteException;
import javax.batch.operations.JobExecutionNotMostRecentException;
import javax.batch.operations.JobRestartException;
import javax.batch.runtime.BatchStatus;
import javax.xml.transform.stream.StreamSource;

@TraceObjectField(fieldName="logger", fieldDesc="Ljava/util/logging/Logger;")
@InjectedFFDC
public class BatchStatusValidator {
    private static final BatchStatus[] RESTARTABLE_EXECUTION_STATES = new BatchStatus[]{BatchStatus.FAILED, BatchStatus.STOPPED, BatchStatus.STARTING};
    private static final InstanceState[] RESTARTABLE_INSTANCE_STATES = new InstanceState[]{InstanceState.FAILED, InstanceState.STOPPED};
    private static final BatchStatus[] RESTARTABLE_STEP_STATES = new BatchStatus[]{BatchStatus.FAILED, BatchStatus.STOPPED, BatchStatus.COMPLETED};
    private static final Logger logger = Logger.getLogger(BatchStatusValidator.class.getName());
    static final long serialVersionUID = 398399229542851465L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public BatchStatusValidator() {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.BatchStatusValidator", "<init>", new Object[0]);
        }
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.BatchStatusValidator", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void validateStatusAtInstanceRestart(long jobInstanceId, Properties restartJobParameters) throws JobRestartException, JobExecutionAlreadyCompleteException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.BatchStatusValidator", "validateStatusAtInstanceRestart", new Object[]{jobInstanceId, restartJobParameters});
        }
        IPersistenceManagerService iPers = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        JobInstanceEntity jobInstance = iPers.getJobInstance(jobInstanceId);
        Helper helper = new Helper(jobInstance, restartJobParameters);
        if (!StringUtils.isEmpty(jobInstance.getJobXml())) {
            helper.validateRestartableFalseJobsDoNotRestart();
        }
        helper.validateJobInstanceFailedOrStopped();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.BatchStatusValidator", "validateStatusAtInstanceRestart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void validateStatusAtExecutionRestart(long previousExecutionId, Properties restartJobParameters) throws JobRestartException, JobExecutionNotMostRecentException, JobExecutionAlreadyCompleteException {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.BatchStatusValidator", "validateStatusAtExecutionRestart", new Object[]{previousExecutionId, restartJobParameters});
        }
        Helper helper = new Helper(previousExecutionId, restartJobParameters);
        helper.validateRestartableFalseJobsDoNotRestart();
        helper.validateJobExecutionIsMostRecent();
        helper.validateJobNotCompleteOrAbandonded();
        helper.validateJobInstanceFailedOrStopped();
        helper.validateJobExecutionFailedOrStoppedOrStarting();
        helper.validateStepsAndPartitionsInNonFinalStates();
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.exiting("com.ibm.jbatch.container.ws.BatchStatusValidator", "validateStatusAtExecutionRestart");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static boolean isJobExecutionMostRecent(long previousExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.BatchStatusValidator", "isJobExecutionMostRecent", new Object[]{previousExecutionId});
        }
        boolean bl = BatchStatusValidator.isJobExecutionMostRecentImpl(previousExecutionId);
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.ws.BatchStatusValidator", "isJobExecutionMostRecent", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isJobExecutionMostRecentImpl(long previousExecutionId) {
        if (logger != null && logger.isLoggable(Level.FINER)) {
            logger.entering("com.ibm.jbatch.container.ws.BatchStatusValidator", "isJobExecutionMostRecentImpl", new Object[]{previousExecutionId});
        }
        boolean retMe = true;
        IPersistenceManagerService iPers = ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        JobInstanceEntity jobInstance = iPers.getJobInstanceFromExecutionId(previousExecutionId);
        long mostRecentExecutionId = iPers.getJobExecutionIdMostRecent(jobInstance.getInstanceId());
        if (mostRecentExecutionId != previousExecutionId) {
            retMe = false;
        }
        boolean bl = retMe;
        if (logger != null && logger.isLoggable(Level.FINER)) {
            bl = bl;
            logger.exiting("com.ibm.jbatch.container.ws.BatchStatusValidator", "isJobExecutionMostRecentImpl", bl);
        }
        return bl;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class Helper {
        private final WSJobInstance jobInstance;
        private long previousExecutionId;
        private final Properties restartJobParameters;
        static final long serialVersionUID = -3793103509923858028L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private Helper(long previousExecutionId, Properties restartJobParameters) {
            this.jobInstance = this.getPersistenceManagerService().getJobInstanceFromExecutionId(previousExecutionId);
            this.previousExecutionId = previousExecutionId;
            this.restartJobParameters = restartJobParameters;
        }

        private Helper(WSJobInstance jobInstance, Properties restartJobParameters) {
            this.jobInstance = jobInstance;
            this.restartJobParameters = restartJobParameters;
        }

        private IPersistenceManagerService getPersistenceManagerService() {
            return ServicesManagerStaticAnchor.getServicesManager().getPersistenceManagerService();
        }

        private void validateRestartableFalseJobsDoNotRestart() throws JobRestartException {
            if (!StringUtils.isEmpty(this.jobInstance.getJobXml())) {
                JSLJob jobModel = ModelResolverFactory.createJobResolver().resolveModel(new StreamSource(new StringReader(this.jobInstance.getJobXml())));
                PropertyResolver<JSLJob> propResolver = PropertyResolverFactory.createJSLJobPropertyResolver(false);
                propResolver.substituteProperties(jobModel, this.restartJobParameters);
                if (jobModel.getRestartable() != null && jobModel.getRestartable().equalsIgnoreCase("false")) {
                    throw new JobRestartException("Job Restartable attribute is false, Job cannot be restarted.");
                }
            }
        }

        private void validateJobExecutionIsMostRecent() throws JobExecutionNotMostRecentException {
            long mostRecentExecutionId = this.getPersistenceManagerService().getJobExecutionIdMostRecent(this.jobInstance.getInstanceId());
            if (mostRecentExecutionId != this.previousExecutionId) {
                String message = "ExecutionId: " + this.previousExecutionId + " is not the most recent execution.";
                throw new JobExecutionNotMostRecentException(message);
            }
        }

        private void validateJobNotCompleteOrAbandonded() throws JobRestartException, JobExecutionAlreadyCompleteException {
            BatchStatus instanceBatchStatus = this.jobInstance.getBatchStatus();
            BatchStatus executionStatus = this.getPersistenceManagerService().getJobExecution(this.previousExecutionId).getBatchStatus();
            if (instanceBatchStatus == null) {
                String msg = "On restart, we didn't find an earlier instance batch status.";
                logger.fine(msg);
                throw new IllegalStateException(msg);
            }
            if (instanceBatchStatus.equals((Object)BatchStatus.COMPLETED) || executionStatus.equals((Object)BatchStatus.COMPLETED)) {
                String msg = "Job already completed.  (Instance, most recent execution) = (" + this.jobInstance.getInstanceId() + "," + this.previousExecutionId + "), instanceStatus = " + instanceBatchStatus + ", executionStatus = " + executionStatus;
                logger.fine(msg);
                throw new JobExecutionAlreadyCompleteException(msg);
            }
            if (instanceBatchStatus.equals((Object)BatchStatus.ABANDONED) || executionStatus.equals((Object)BatchStatus.ABANDONED)) {
                String msg = "Job previously abandoned.  (Instance, most recent execution) = (" + this.jobInstance.getInstanceId() + "," + this.previousExecutionId + "), instanceStatus = " + instanceBatchStatus + ", executionStatus = " + executionStatus;
                logger.fine(msg);
                throw new JobRestartException(msg);
            }
        }

        private void validateJobExecutionFailedOrStoppedOrStarting() throws JobRestartException {
            BatchStatus executionStatus = this.getPersistenceManagerService().getJobExecution(this.previousExecutionId).getBatchStatus();
            if (!this.checkIfStatusMatchesFromList(executionStatus, RESTARTABLE_EXECUTION_STATES)) {
                String msg = "The job instance " + this.jobInstance.getInstanceId() + " cannot be restarted because the most recent execution is still in a non-final state.";
                logger.fine(msg);
                throw new JobRestartException(msg);
            }
        }

        private void validateJobInstanceFailedOrStopped() throws JobRestartException {
            InstanceState instanceState = this.jobInstance.getInstanceState();
            if (!this.checkIfStateMatchesFromList(instanceState, RESTARTABLE_INSTANCE_STATES)) {
                String msg = "The job instance " + this.jobInstance.getInstanceId() + " cannot be restarted because it is still in a non-final state.";
                logger.fine(msg);
                throw new JobRestartException(msg);
            }
        }

        private void validateStepsAndPartitionsInNonFinalStates() throws JobRestartException {
            List<WSStepThreadExecutionAggregate> stepExecutionAggregates = this.getPersistenceManagerService().getStepExecutionAggregatesFromJobExecutionId(this.previousExecutionId);
            for (WSStepThreadExecutionAggregate stepExecutionAggregate : stepExecutionAggregates) {
                if (!this.checkIfStatusMatchesFromList(stepExecutionAggregate.getTopLevelStepExecution().getBatchStatus(), RESTARTABLE_STEP_STATES)) {
                    String msg = "The job instance " + this.jobInstance.getInstanceId() + " cannot be restarted because step " + stepExecutionAggregate.getTopLevelStepExecution().getStepName() + " is still in a non-final state.";
                    logger.fine(msg);
                    throw new JobRestartException(msg);
                }
                for (WSPartitionStepThreadExecution partitionExec : stepExecutionAggregate.getPartitionLevelStepExecutions()) {
                    if (this.checkIfStatusMatchesFromList(partitionExec.getBatchStatus(), RESTARTABLE_STEP_STATES)) continue;
                    String msg = "The job instance " + this.jobInstance.getInstanceId() + " cannot be restarted because step " + partitionExec.getStepName() + " partition " + partitionExec.getPartitionNumber() + " is still in a non-final state.";
                    logger.fine(msg);
                    throw new JobRestartException(msg);
                }
            }
        }

        private String getFormattedMessage(String msgKey, Object[] fillIns, String defaultMsg) {
            ResourceBundle resourceBundle = ResourceBundle.getBundle("com.ibm.jbatch.container.internal.resources.JBatchMessages");
            if (resourceBundle == null) {
                return defaultMsg;
            }
            String msg = resourceBundle.getString(msgKey);
            return msg != null ? MessageFormat.format(msg, fillIns) : defaultMsg;
        }

        private boolean checkIfStatusMatchesFromList(BatchStatus status, BatchStatus[] listAcceptable) {
            for (BatchStatus batchStatusFromList : listAcceptable) {
                if (!status.equals((Object)batchStatusFromList)) continue;
                return true;
            }
            return false;
        }

        private boolean checkIfStateMatchesFromList(InstanceState state, InstanceState[] listAcceptable) {
            for (InstanceState batchStateFromList : listAcceptable) {
                if (!state.equals((Object)batchStateFromList)) continue;
                return true;
            }
            return false;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.jbatch.container.ws.BatchStatusValidator$Helper", Helper.class, (String)"wsbatch", null);
        }
    }
}

