/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.WasHttpSessionObserver;
import com.ibm.ws.session.http.AbstractHttpSession;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.wsspi.session.IProtocolAdapter;
import com.ibm.wsspi.session.ISession;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.logging.Level;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionActivationListener;
import javax.servlet.http.HttpSessionBindingEvent;
import javax.servlet.http.HttpSessionBindingListener;
import javax.servlet.http.HttpSessionEvent;

public class WasHttpAppSessionGlobalObserver
extends WasHttpSessionObserver {
    private static final String methodClassName = "WasHttpAppSessionObserver";

    public WasHttpAppSessionGlobalObserver(ArrayList listeners, IProtocolAdapter adapter) {
        super(listeners, adapter);
    }

    public WasHttpAppSessionGlobalObserver(ArrayList listeners, ArrayList idListeners, IProtocolAdapter adapter) {
        super(listeners, idListeners, adapter);
    }

    @Override
    public void sessionDestroyed(ISession session) {
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, methodNames[0], "sessionid=" + session.getId());
        }
        ArrayList attributes = session.getListenerAttributeNames();
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodNames[0], "attributes.size()=:" + attributes.size());
        }
        if (this._sessionListeners.size() > 0 || attributes.size() > 0) {
            AbstractHttpSession httpsession = (AbstractHttpSession)this._adapter.adapt(session);
            HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
            Object listener = null;
            if (attributes.size() != 0) {
                Object value = null;
                String name = null;
                for (int i = 0; i < attributes.size(); ++i) {
                    name = (String)attributes.get(i);
                    value = session.getAttribute(name);
                    if (null == value) continue;
                    HttpSessionBindingListener bindingListener = (HttpSessionBindingListener)value;
                    HttpSessionBindingEvent bindingEvent = new HttpSessionBindingEvent((HttpSession)httpsession, name);
                    bindingListener.valueUnbound(bindingEvent);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, methodNames[0]);
        }
    }

    @Override
    public void sessionDidActivate(ISession session) {
        AbstractHttpSession httpsession = (AbstractHttpSession)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        Enumeration<String> enum1 = session.getAttributeNames();
        while (enum1.hasMoreElements()) {
            String attrName = enum1.nextElement();
            Object attr = session.getAttribute(attrName);
            if (!(attr instanceof HttpSessionActivationListener)) continue;
            ((HttpSessionActivationListener)attr).sessionDidActivate(event);
        }
    }

    @Override
    public void sessionWillPassivate(ISession session) {
        AbstractHttpSession httpsession = (AbstractHttpSession)this._adapter.adapt(session);
        HttpSessionEvent event = new HttpSessionEvent((HttpSession)httpsession);
        Enumeration<String> enum1 = session.getAttributeNames();
        while (enum1.hasMoreElements()) {
            String attrName = enum1.nextElement();
            Object attr = session.getAttribute(attrName);
            if (!(attr instanceof HttpSessionActivationListener)) continue;
            ((HttpSessionActivationListener)attr).sessionWillPassivate(event);
        }
    }
}

