/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import jakarta.annotation.Priority;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;

@Priority(value=4000)
public class RelocateConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 3476637906383945843L;
    private final Function<String, String> mapping;

    public RelocateConfigSourceInterceptor(Function<String, String> mapping) {
        this.mapping = mapping != null ? mapping : Function.identity();
    }

    public RelocateConfigSourceInterceptor(Map<String, String> mappings) {
        this((Function<String, String> & Serializable)name -> mappings.getOrDefault(name, (String)name));
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        String map = this.mapping.apply(name);
        ConfigValue configValue = context.proceed(map);
        if (configValue == null && !name.equals(map)) {
            configValue = context.proceed(name);
        }
        return configValue;
    }

    @Override
    public Iterator<ConfigValue> iterateValues(ConfigSourceInterceptorContext context) {
        HashSet<ConfigValue> values = new HashSet<ConfigValue>();
        Iterator<ConfigValue> valuesIterator = context.iterateValues();
        while (valuesIterator.hasNext()) {
            ConfigValue value = valuesIterator.next();
            values.add(value);
            String mappedName = this.mapping.apply(value.getName());
            if (mappedName == null) continue;
            values.add(ConfigValue.builder().withName(mappedName).withValue(value.getValue()).withRawValue(value.getRawValue()).withConfigSourceName(value.getConfigSourceName()).withConfigSourceOrdinal(value.getConfigSourceOrdinal()).withLineNumber(value.getLineNumber()).build());
        }
        return values.iterator();
    }
}

