/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.crypto;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.Key;
import java.security.interfaces.ECKey;
import java.security.interfaces.ECPrivateKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.ECParameterSpec;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class KeyAlgorithmChecker {
    private static final TraceComponent tc = Tr.register(KeyAlgorithmChecker.class, null, null);
    private static final Pattern HSA_PATTERN = Pattern.compile("HS[0-9]{3,}");
    private static final Pattern RSA_PATTERN = Pattern.compile("RS[0-9]{3,}");
    private static final Pattern ESA_PATTERN = Pattern.compile("ES[0-9]{3,}");
    private static final Pattern ALG_PATTERN = Pattern.compile("[RHEP]S([0-9]{3,})", 2);
    public static int UNKNOWN_HASH_SIZE = 0;
    static final long serialVersionUID = -1185560328885431269L;

    private KeyAlgorithmChecker() {
    }

    public static boolean isHSAlgorithm(String alg) {
        if (alg == null) {
            return false;
        }
        Matcher m = HSA_PATTERN.matcher(alg);
        return m.matches();
    }

    public static boolean isPublicKeyValidType(Key key, String supportedSigAlg) {
        if (key == null || supportedSigAlg == null) {
            return true;
        }
        if (KeyAlgorithmChecker.isRSAlgorithm(supportedSigAlg)) {
            return KeyAlgorithmChecker.isValidRSAPublicKey(key);
        }
        if (KeyAlgorithmChecker.isESAlgorithm(supportedSigAlg)) {
            return KeyAlgorithmChecker.isValidECPublicKey(supportedSigAlg, key);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Did not find matching algorithm support for [" + supportedSigAlg + "]"), (Object[])new Object[0]);
        }
        return false;
    }

    public static boolean isRSAlgorithm(String alg) {
        if (alg == null) {
            return false;
        }
        Matcher m = RSA_PATTERN.matcher(alg);
        return m.matches();
    }

    public static boolean isValidRSAPublicKey(Key key) {
        String keyAlgorithm = key.getAlgorithm();
        return keyAlgorithm.equals("RSA") && key instanceof RSAPublicKey;
    }

    public static boolean isESAlgorithm(String alg) {
        if (alg == null) {
            return false;
        }
        Matcher m = ESA_PATTERN.matcher(alg);
        return m.matches();
    }

    public static boolean isValidECPublicKey(String supportedSigAlg, Key key) {
        if (!"EC".equals(key.getAlgorithm()) || !(key instanceof ECPublicKey)) {
            return false;
        }
        return KeyAlgorithmChecker.isValidECKeyParameters(supportedSigAlg, (ECPublicKey)key);
    }

    static boolean isValidECKeyParameters(String supportedSigAlg, ECKey key) {
        ECParameterSpec params = key.getParams();
        int fieldSize = params.getCurve().getField().getFieldSize();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Comparing supported algorithm [" + supportedSigAlg + "] against key field size [" + fieldSize + "]"), (Object[])new Object[0]);
        }
        int supportedAlgKeySize = KeyAlgorithmChecker.getHashSizeFromAlgorithm(supportedSigAlg);
        if (fieldSize == 521) {
            return supportedAlgKeySize == 512;
        }
        return supportedAlgKeySize == fieldSize;
    }

    @FFDCIgnore(value={Exception.class})
    public static int getHashSizeFromAlgorithm(String algorithm) {
        int hashSize = UNKNOWN_HASH_SIZE;
        Matcher algMatcher = ALG_PATTERN.matcher(algorithm);
        if (!algMatcher.matches()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Algorithm [" + algorithm + "] did not match expected regex " + ALG_PATTERN.toString()), (Object[])new Object[0]);
            }
            return hashSize;
        }
        String hashSizeString = algMatcher.group(1);
        try {
            hashSize = Integer.parseInt(hashSizeString);
        }
        catch (Exception e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception parsing hash size string [" + hashSizeString + "]: " + e), (Object[])new Object[0]);
            }
            return hashSize;
        }
        return hashSize;
    }

    public static boolean isPrivateKeyValidType(Key key, String supportedSigAlg) {
        if (key == null || supportedSigAlg == null) {
            return true;
        }
        if (KeyAlgorithmChecker.isRSAlgorithm(supportedSigAlg)) {
            return KeyAlgorithmChecker.isValidRSAPrivateKey(key);
        }
        if (KeyAlgorithmChecker.isESAlgorithm(supportedSigAlg)) {
            return KeyAlgorithmChecker.isValidECPrivateKey(supportedSigAlg, key);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Did not find matching algorithm support for [" + supportedSigAlg + "]"), (Object[])new Object[0]);
        }
        return false;
    }

    public static boolean isValidRSAPrivateKey(Key key) {
        String keyAlgorithm = key.getAlgorithm();
        return keyAlgorithm.equals("RSA") && key instanceof RSAPrivateKey;
    }

    public static boolean isValidECPrivateKey(String supportedSigAlg, Key key) {
        if (!"EC".equals(key.getAlgorithm()) || !(key instanceof ECPrivateKey)) {
            return false;
        }
        return KeyAlgorithmChecker.isValidECKeyParameters(supportedSigAlg, (ECPrivateKey)key);
    }
}

