/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.websphere.servlet.response;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.servlet.response.DateHeaderField;
import com.ibm.websphere.servlet.response.HeaderField;
import com.ibm.websphere.servlet.response.HeaderFieldNames;
import com.ibm.websphere.servlet.response.IntHeaderField;
import com.ibm.websphere.servlet.response.NilHeaderField;
import com.ibm.websphere.servlet.response.StringHeaderField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.Enumeration;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
class StoredHeader
implements Serializable {
    private static final long serialVersionUID = 3905521588232138806L;
    private HeaderField _field = NilHeaderField.instance();
    private int _size;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public Enumeration getHeaderNames() {
        return new HeaderFieldNames(this._field);
    }

    public String getHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getStringValue();
        }
        return null;
    }

    public int getIntHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getIntValue();
        }
        return -1;
    }

    public long getDateHeader(String name) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            return f.getDateValue();
        }
        return -1L;
    }

    public boolean containsHeader(String name) {
        return this.getHeaderField(name) != null;
    }

    public synchronized void setHeader(String name, String value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setStringValue(value);
        } else {
            this._field = new StringHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public synchronized void setIntHeader(String name, int value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setIntValue(value);
        } else {
            this._field = new IntHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public synchronized void setDateHeader(String name, long value) {
        HeaderField f = this.getHeaderField(name);
        if (f != null) {
            f.setDateValue(value);
        } else {
            this._field = new DateHeaderField(name, value, this._field);
            ++this._size;
        }
    }

    public int getSize() {
        return this._size;
    }

    public void transferHeader(HttpServletResponse resp) {
        this._field.transferHeader(resp);
    }

    private HeaderField getHeaderField(String name) {
        String lName = name.toLowerCase();
        HeaderField f = this._field;
        while (!f.isNil()) {
            if (f.getName().toLowerCase().equals(lName)) {
                return f;
            }
            if (f.hasMoreFields()) {
                f = f.getNextField();
                continue;
            }
            return null;
        }
        return null;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.websphere.servlet.response.StoredHeader", StoredHeader.class, null, null);
    }
}

