/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.api.models.media;

import io.smallrye.openapi.api.models.ExtensibleImpl;
import io.smallrye.openapi.api.models.ExternalDocumentationImpl;
import io.smallrye.openapi.api.models.ModelImpl;
import io.smallrye.openapi.api.models.media.XMLImpl;
import io.smallrye.openapi.api.util.MergeUtil;
import io.smallrye.openapi.runtime.util.ModelUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.eclipse.microprofile.openapi.models.ExternalDocumentation;
import org.eclipse.microprofile.openapi.models.media.Discriminator;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.media.XML;

public class SchemaImpl
extends ExtensibleImpl<Schema>
implements Schema,
ModelImpl {
    private String ref;
    private String format;
    private final String name;
    private String title;
    private String description;
    private Object defaultValue;
    private BigDecimal multipleOf;
    private BigDecimal maximum;
    private Boolean exclusiveMaximum;
    private BigDecimal minimum;
    private Boolean exclusiveMinimum;
    private Integer maxLength;
    private Integer minLength;
    private String pattern;
    private Integer maxItems;
    private Integer minItems;
    private Boolean uniqueItems;
    private Integer maxProperties;
    private Integer minProperties;
    private List<String> required;
    private List<Object> enumeration;
    private Schema.SchemaType type;
    private Schema items;
    private List<Schema> allOf;
    private Map<String, Schema> properties;
    private Schema additionalPropertiesSchema;
    private Boolean additionalPropertiesBoolean;
    private Boolean readOnly;
    private XML xml;
    private ExternalDocumentation externalDocs;
    private Object example;
    private List<Schema> oneOf;
    private List<Schema> anyOf;
    private Schema not;
    private Discriminator discriminator;
    private Boolean nullable;
    private Boolean writeOnly;
    private Boolean deprecated;
    private int modCount;
    private List<Schema> typeObservers;

    public static boolean isNamed(Schema schema) {
        return schema instanceof SchemaImpl && ((SchemaImpl)schema).name != null;
    }

    public static int getModCount(Schema schema) {
        return schema instanceof SchemaImpl ? ((SchemaImpl)schema).modCount : -1;
    }

    public static void addTypeObserver(Schema observable, Schema observer) {
        if (observable instanceof SchemaImpl) {
            SchemaImpl obs = (SchemaImpl)observable;
            obs.typeObservers = ModelUtil.add(observer, obs.typeObservers, ArrayList::new);
        }
        observer.setType(observable.getType());
    }

    public static SchemaImpl copyOf(Schema other) {
        SchemaImpl clone = (SchemaImpl)MergeUtil.mergeObjects(new SchemaImpl(), other);
        clone.required = SchemaImpl.copy(clone.required, () -> new ArrayList<String>(clone.required));
        clone.enumeration = SchemaImpl.copy(clone.enumeration, () -> new ArrayList<Object>(clone.enumeration));
        clone.items = SchemaImpl.copy(clone.items, () -> SchemaImpl.copyOf(clone.items));
        clone.allOf = SchemaImpl.copy(clone.allOf, () -> clone.allOf.stream().map(SchemaImpl::copyOf).collect(Collectors.toList()));
        clone.properties = SchemaImpl.copy(clone.properties, () -> clone.properties.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> SchemaImpl.copyOf((Schema)e.getValue()), (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new)));
        clone.additionalPropertiesSchema = SchemaImpl.copy(clone.additionalPropertiesSchema, () -> SchemaImpl.copyOf(clone.additionalPropertiesSchema));
        clone.xml = SchemaImpl.copy(clone.xml, () -> MergeUtil.mergeObjects(new XMLImpl(), clone.xml));
        clone.externalDocs = SchemaImpl.copy(clone.externalDocs, () -> MergeUtil.mergeObjects(new ExternalDocumentationImpl(), clone.externalDocs));
        clone.oneOf = SchemaImpl.copy(clone.oneOf, () -> clone.oneOf.stream().map(SchemaImpl::copyOf).collect(Collectors.toList()));
        clone.anyOf = SchemaImpl.copy(clone.anyOf, () -> clone.anyOf.stream().map(SchemaImpl::copyOf).collect(Collectors.toList()));
        clone.not = SchemaImpl.copy(clone.not, () -> SchemaImpl.copyOf(clone.not));
        return clone;
    }

    private static <T> T copy(T property, Supplier<T> copySupplier) {
        if (property != null) {
            return copySupplier.get();
        }
        return null;
    }

    public SchemaImpl(String name) {
        this.name = name;
    }

    public SchemaImpl() {
        this(null);
    }

    public String getName() {
        return this.name;
    }

    private void incrementModCount() {
        ++this.modCount;
    }

    public String getRef() {
        return this.ref;
    }

    public void setRef(String ref) {
        if (ref != null && !ref.contains("/")) {
            ref = "#/components/schemas/" + ref;
        }
        this.incrementModCount();
        this.ref = ref;
    }

    public Discriminator getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(Discriminator discriminator) {
        this.incrementModCount();
        this.discriminator = discriminator;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.incrementModCount();
        this.title = title;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object defaultValue) {
        this.incrementModCount();
        this.defaultValue = defaultValue;
    }

    public List<Object> getEnumeration() {
        return ModelUtil.unmodifiableList(this.enumeration);
    }

    public void setEnumeration(List<Object> enumeration) {
        this.incrementModCount();
        this.enumeration = ModelUtil.replace(enumeration, ArrayList::new);
    }

    public Schema addEnumeration(Object enumeration) {
        this.incrementModCount();
        this.enumeration = ModelUtil.add(enumeration, this.enumeration, ArrayList::new);
        return this;
    }

    public void removeEnumeration(Object enumeration) {
        this.incrementModCount();
        ModelUtil.remove(this.enumeration, enumeration);
    }

    public BigDecimal getMultipleOf() {
        return this.multipleOf;
    }

    public void setMultipleOf(BigDecimal multipleOf) {
        this.incrementModCount();
        this.multipleOf = multipleOf;
    }

    public BigDecimal getMaximum() {
        return this.maximum;
    }

    public void setMaximum(BigDecimal maximum) {
        this.incrementModCount();
        this.maximum = maximum;
    }

    public Boolean getExclusiveMaximum() {
        return this.exclusiveMaximum;
    }

    public void setExclusiveMaximum(Boolean exclusiveMaximum) {
        this.incrementModCount();
        this.exclusiveMaximum = exclusiveMaximum;
    }

    public BigDecimal getMinimum() {
        return this.minimum;
    }

    public void setMinimum(BigDecimal minimum) {
        this.incrementModCount();
        this.minimum = minimum;
    }

    public Boolean getExclusiveMinimum() {
        return this.exclusiveMinimum;
    }

    public void setExclusiveMinimum(Boolean exclusiveMinimum) {
        this.incrementModCount();
        this.exclusiveMinimum = exclusiveMinimum;
    }

    public Integer getMaxLength() {
        return this.maxLength;
    }

    public void setMaxLength(Integer maxLength) {
        this.incrementModCount();
        this.maxLength = maxLength;
    }

    public Integer getMinLength() {
        return this.minLength;
    }

    public void setMinLength(Integer minLength) {
        this.incrementModCount();
        this.minLength = minLength;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.incrementModCount();
        this.pattern = pattern;
    }

    public Integer getMaxItems() {
        return this.maxItems;
    }

    public void setMaxItems(Integer maxItems) {
        this.incrementModCount();
        this.maxItems = maxItems;
    }

    public Integer getMinItems() {
        return this.minItems;
    }

    public void setMinItems(Integer minItems) {
        this.incrementModCount();
        this.minItems = minItems;
    }

    public Boolean getUniqueItems() {
        return this.uniqueItems;
    }

    public void setUniqueItems(Boolean uniqueItems) {
        this.incrementModCount();
        this.uniqueItems = uniqueItems;
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        this.incrementModCount();
        this.maxProperties = maxProperties;
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public void setMinProperties(Integer minProperties) {
        this.incrementModCount();
        this.minProperties = minProperties;
    }

    public List<String> getRequired() {
        return ModelUtil.unmodifiableList(this.required);
    }

    public void setRequired(List<String> required) {
        this.incrementModCount();
        this.required = ModelUtil.replace(required, ArrayList::new);
    }

    public Schema addRequired(String required) {
        this.incrementModCount();
        this.required = ModelUtil.add(required, this.required, ArrayList::new);
        return this;
    }

    public void removeRequired(String required) {
        this.incrementModCount();
        ModelUtil.remove(this.required, required);
    }

    public Schema.SchemaType getType() {
        return this.type;
    }

    public void setType(Schema.SchemaType type) {
        this.incrementModCount();
        this.type = type;
        if (this.typeObservers != null) {
            this.typeObservers.forEach(o -> o.setType(type));
        }
    }

    public Schema getNot() {
        return this.not;
    }

    public void setNot(Schema not) {
        this.incrementModCount();
        this.not = not;
    }

    public Map<String, Schema> getProperties() {
        return ModelUtil.unmodifiableMap(this.properties);
    }

    public void setProperties(Map<String, Schema> properties) {
        this.incrementModCount();
        this.properties = ModelUtil.replace(properties, LinkedHashMap::new);
    }

    public Schema addProperty(String key, Schema propertySchema) {
        this.incrementModCount();
        this.properties = ModelUtil.add(key, propertySchema, this.properties, LinkedHashMap::new);
        return this;
    }

    public void removeProperty(String key) {
        this.incrementModCount();
        ModelUtil.remove(this.properties, key);
    }

    public Schema getAdditionalPropertiesSchema() {
        return this.additionalPropertiesSchema;
    }

    public Boolean getAdditionalPropertiesBoolean() {
        return this.additionalPropertiesBoolean;
    }

    public void setAdditionalPropertiesSchema(Schema additionalProperties) {
        this.incrementModCount();
        this.additionalPropertiesBoolean = null;
        this.additionalPropertiesSchema = additionalProperties;
    }

    public void setAdditionalPropertiesBoolean(Boolean additionalProperties) {
        this.incrementModCount();
        this.additionalPropertiesSchema = null;
        this.additionalPropertiesBoolean = additionalProperties;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.incrementModCount();
        this.description = description;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.incrementModCount();
        this.format = format;
    }

    public Boolean getNullable() {
        return this.nullable;
    }

    public void setNullable(Boolean nullable) {
        this.incrementModCount();
        this.nullable = nullable;
    }

    public Boolean getReadOnly() {
        return this.readOnly;
    }

    public void setReadOnly(Boolean readOnly) {
        this.incrementModCount();
        this.readOnly = readOnly;
    }

    public Boolean getWriteOnly() {
        return this.writeOnly;
    }

    public void setWriteOnly(Boolean writeOnly) {
        this.incrementModCount();
        this.writeOnly = writeOnly;
    }

    public Object getExample() {
        return this.example;
    }

    public void setExample(Object example) {
        this.incrementModCount();
        this.example = example;
    }

    public ExternalDocumentation getExternalDocs() {
        return this.externalDocs;
    }

    public void setExternalDocs(ExternalDocumentation externalDocs) {
        this.incrementModCount();
        this.externalDocs = externalDocs;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.incrementModCount();
        this.deprecated = deprecated;
    }

    public XML getXml() {
        return this.xml;
    }

    public void setXml(XML xml) {
        this.incrementModCount();
        this.xml = xml;
    }

    public Schema getItems() {
        return this.items;
    }

    public void setItems(Schema items) {
        this.incrementModCount();
        this.items = items;
    }

    public List<Schema> getAllOf() {
        return ModelUtil.unmodifiableList(this.allOf);
    }

    public void setAllOf(List<Schema> allOf) {
        this.incrementModCount();
        this.allOf = ModelUtil.replace(allOf, ArrayList::new);
    }

    public Schema addAllOf(Schema allOf) {
        this.incrementModCount();
        this.allOf = ModelUtil.add(allOf, this.allOf, ArrayList::new);
        return this;
    }

    public void removeAllOf(Schema allOf) {
        this.incrementModCount();
        ModelUtil.remove(this.allOf, allOf);
    }

    public List<Schema> getAnyOf() {
        return ModelUtil.unmodifiableList(this.anyOf);
    }

    public void setAnyOf(List<Schema> anyOf) {
        this.incrementModCount();
        this.anyOf = ModelUtil.replace(anyOf, ArrayList::new);
    }

    public Schema addAnyOf(Schema anyOf) {
        this.incrementModCount();
        this.anyOf = ModelUtil.add(anyOf, this.anyOf, ArrayList::new);
        return this;
    }

    public void removeAnyOf(Schema anyOf) {
        this.incrementModCount();
        ModelUtil.remove(this.anyOf, anyOf);
    }

    public List<Schema> getOneOf() {
        return ModelUtil.unmodifiableList(this.oneOf);
    }

    public void setOneOf(List<Schema> oneOf) {
        this.incrementModCount();
        this.oneOf = ModelUtil.replace(oneOf, ArrayList::new);
    }

    public Schema addOneOf(Schema oneOf) {
        this.incrementModCount();
        this.oneOf = ModelUtil.add(oneOf, this.oneOf, ArrayList::new);
        return this;
    }

    public void removeOneOf(Schema oneOf) {
        this.incrementModCount();
        ModelUtil.remove(this.oneOf, oneOf);
    }
}

