/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.config.sources;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.config.sources.StaticConfigSource;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.config.internal.common.InternalConfigSource;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SystemConfigSource
extends InternalConfigSource
implements StaticConfigSource {
    private static final TraceComponent tc = Tr.register(SystemConfigSource.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
    private final String name = Tr.formatMessage((TraceComponent)tc, (String)"system.properties.config.source", (Object[])new Object[0]);
    static final long serialVersionUID = -1727221492594519811L;

    @Trivial
    public SystemConfigSource() {
    }

    @Trivial
    public String getName() {
        return this.name;
    }

    @Trivial
    protected int getDefaultOrdinal() {
        return 400;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        Properties sysProps = SystemConfigSource.getSystemProperties();
        Set<String> keys = sysProps.stringPropertyNames();
        for (String key : keys) {
            String value;
            if (key == null || (value = sysProps.getProperty(key)) == null) continue;
            props.put(key, value);
        }
        return props;
    }

    @Trivial
    private static Properties getSystemProperties() {
        Properties prop = AccessController.doPrivileged(new PrivilegedAction<Properties>(){
            static final long serialVersionUID = 2019268619265958168L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            @Override
            @Trivial
            public Properties run() {
                return System.getProperties();
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.config.sources.SystemConfigSource$1", 1.class, (String)"APPCONFIG", (String)"com.ibm.ws.microprofile.config.resources.Config");
            }
        });
        return prop;
    }
}

