/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.collector;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.collector.EventsBuffer;
import com.ibm.ws.collector.Target;
import com.ibm.ws.collector.internal.Task;
import com.ibm.ws.collector.internal.TaskConfig;
import com.ibm.ws.collector.internal.TaskImpl;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.logging.collector.Formatter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.collector.manager.BufferManager;
import com.ibm.wsspi.collector.manager.CollectorManager;
import com.ibm.wsspi.collector.manager.Handler;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import org.osgi.framework.ServiceReference;
import org.osgi.service.component.ComponentContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public abstract class Collector
implements Handler,
Formatter {
    private static final TraceComponent tc = Tr.register(Collector.class, (String)"Collector", (String)"com.ibm.ws.collector.internal.resources.LoggingMessages");
    private volatile EventsBuffer eventsBuffer;
    private final int maxSize = 10000;
    private final long period = 5000L;
    private volatile CollectorManager collectorMgr;
    private final ConcurrentHashMap<String, Task> taskMap = new ConcurrentHashMap();
    private final CountDownLatch latch = new CountDownLatch(1);
    protected static final String SOURCE_LIST_KEY = "source";
    private static final String TAG_LIST_KEY = "tag";
    private static final String MAX_FIELD_KEY = "maxFieldLength";
    private static final String MAX_EVENTS_KEY = "maxEvents";
    protected static final String EXECUTOR_SERVICE = "executorService";
    protected final AtomicServiceReference<ExecutorService> executorServiceRef = new AtomicServiceReference("executorService");
    static final long serialVersionUID = -3771588919499030609L;

    protected abstract void setExecutorService(ServiceReference<ExecutorService> var1);

    protected abstract void unsetExecutorService(ServiceReference<ExecutorService> var1);

    protected void activate(ComponentContext cc, Map<String, Object> configuration) {
        this.executorServiceRef.activate(cc);
        try {
            this.configure(configuration);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.collector.Collector", (String)"83", (Object)this, (Object[])new Object[]{cc, configuration});
        }
        Target target = this.getTarget();
        this.eventsBuffer = new EventsBuffer(target, 10000L, 5000L);
        this.eventsBuffer.start();
    }

    protected void deactivate(ComponentContext cc, int reason) {
        this.eventsBuffer.stop();
        this.collectorMgr = null;
        this.executorServiceRef.deactivate(cc);
    }

    protected void modified(Map<String, Object> configuration) {
        if (this.collectorMgr == null) {
            try {
                this.latch.await();
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.collector.Collector", (String)"106", (Object)this, (Object[])new Object[]{configuration});
                Thread.currentThread().interrupt();
                return;
            }
        }
        try {
            ArrayList oldSources = new ArrayList(this.taskMap.keySet());
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("listOfOldSources " + oldSources), (Object[])new Object[0]);
            }
            ArrayList<TaskConfig> configList = new ArrayList<TaskConfig>();
            configList.addAll(this.parseConfig(configuration));
            ArrayList<String> newSources = new ArrayList<String>();
            for (TaskConfig taskConfig : configList) {
                newSources.add(taskConfig.sourceId());
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("listOfNewSources " + newSources), (Object[])new Object[0]);
            }
            ArrayList<String> sourcesToUnsubscribe = new ArrayList<String>(oldSources);
            sourcesToUnsubscribe.removeAll(newSources);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("listOfSourcesToUnsubscribe " + sourcesToUnsubscribe), (Object[])new Object[0]);
            }
            ArrayList sourcesToSubscribe = new ArrayList(newSources);
            sourcesToSubscribe.removeAll(oldSources);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("listOfSourcesToSubscribe " + sourcesToSubscribe), (Object[])new Object[0]);
            }
            this.collectorMgr.unsubscribe((Handler)this, sourcesToUnsubscribe);
            this.deconfigure(sourcesToUnsubscribe);
            this.configure(configuration);
            this.collectorMgr.subscribe((Handler)this, sourcesToSubscribe);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.Collector", (String)"155", (Object)this, (Object[])new Object[]{configuration});
        }
    }

    private void deconfigure(List<String> sourcesToUnsubscribe) {
        for (String sourceName : sourcesToUnsubscribe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Task deConfig " + this), (Object[])new Object[]{sourceName});
            }
            this.taskMap.get(sourceName).setHandlerName(null);
            this.taskMap.remove(sourceName);
        }
    }

    private void configure(Map<String, Object> configuration) throws IOException {
        ArrayList<TaskConfig> configList = new ArrayList<TaskConfig>();
        configList.addAll(this.parseConfig(configuration));
        for (TaskConfig taskConfig : configList) {
            TaskImpl task;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Task config " + this), (Object[])new Object[]{taskConfig});
            }
            if (!taskConfig.getEnabled() || (task = new TaskImpl()) == null) continue;
            if (!this.taskMap.containsKey(taskConfig.sourceId())) {
                task.setHandlerName(this.getHandlerName());
                task.setConfig(taskConfig);
                this.taskMap.putIfAbsent(taskConfig.sourceId(), task);
                continue;
            }
            this.taskMap.get(taskConfig.sourceId()).setConfig(taskConfig);
        }
    }

    private List<TaskConfig> parseConfig(Map<String, Object> config) {
        String[] sourceList;
        ArrayList<TaskConfig> result = new ArrayList<TaskConfig>();
        String[] tagList = null;
        if (config.containsKey(TAG_LIST_KEY)) {
            tagList = (String[])config.get(TAG_LIST_KEY);
            ArrayList<String> validList = new ArrayList<String>();
            ArrayList<String> invalidList = new ArrayList<String>();
            Collector.validateTags(tagList, validList, invalidList);
            if (invalidList.size() > 0) {
                Tr.warning((TraceComponent)tc, (String)"TAGS_FILTERING_WARNING", (Object[])new Object[]{Arrays.toString(invalidList.toArray(new String[invalidList.size()]))});
            }
            tagList = validList.toArray(new String[validList.size()]);
        }
        int maxFieldLength = config.get(MAX_FIELD_KEY) != null ? (Integer)config.get(MAX_FIELD_KEY) : 2048;
        int maxEvents = 0;
        if (config.containsKey(MAX_EVENTS_KEY)) {
            try {
                maxEvents = Integer.parseInt(config.get(MAX_EVENTS_KEY).toString());
                if (maxEvents < 0) {
                    maxEvents = 0;
                }
            }
            catch (Exception exception) {
                FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.Collector", (String)"249", (Object)this, (Object[])new Object[]{config});
                Tr.warning((TraceComponent)tc, (String)"MAXEVENTS_OUTOFRANGE_WARNING", (Object[])new Object[]{config.get(MAX_EVENTS_KEY)});
                maxEvents = 0;
            }
        }
        if (config.containsKey(SOURCE_LIST_KEY) && (sourceList = (String[])config.get(SOURCE_LIST_KEY)) != null) {
            for (String source : sourceList) {
                if (this.getSourceName(source.trim()).isEmpty()) continue;
                TaskConfig.Builder builder = this.getSourceName(source.trim()).equals("audit") ? new TaskConfig.Builder(this.getSourceName(source.trim()), "server") : new TaskConfig.Builder(this.getSourceName(source.trim()), "memory");
                builder.enabled(true);
                builder.tags(tagList);
                builder.maxEvents(maxEvents);
                builder.maxFieldLength(maxFieldLength);
                result.add(builder.build());
            }
        }
        return result;
    }

    private static void validateTags(String[] tagList, ArrayList<String> validList, ArrayList<String> invalidList) {
        for (String tag : tagList) {
            if ((tag = tag.trim()).contains("\\") || tag.contains(" ") || tag.contains("\n") || tag.contains("-") || tag.equals("")) {
                invalidList.add(tag);
                continue;
            }
            validList.add(tag);
        }
    }

    protected String getSourceName(String source) {
        if (source.equals("garbageCollection")) {
            return "com.ibm.ws.health.center.source.gcsource";
        }
        if (source.equals("message")) {
            return "com.ibm.ws.logging.source.message";
        }
        if (source.equals("ffdc")) {
            return "com.ibm.ws.logging.ffdc.source.ffdcsource";
        }
        if (source.equals("trace")) {
            return "com.ibm.ws.logging.source.trace";
        }
        if (source.equalsIgnoreCase("accessLog")) {
            return "com.ibm.ws.http.logging.source.accesslog";
        }
        if (source.equalsIgnoreCase("audit")) {
            return "audit";
        }
        return "";
    }

    public void init(CollectorManager collectorManager) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Subscribing to sources " + this), (Object[])new Object[]{this.taskMap.keySet()});
        }
        try {
            this.collectorMgr = collectorManager;
            this.collectorMgr.subscribe((Handler)this, new ArrayList(this.taskMap.keySet()));
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.collector.Collector", (String)"328", (Object)this, (Object[])new Object[]{collectorManager});
        }
        finally {
            this.latch.countDown();
        }
    }

    public void setBufferManager(String sourceId, BufferManager bufferMgr) {
        Task task;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Setting buffer manager " + this), (Object[])new Object[]{sourceId, bufferMgr});
        }
        if ((task = this.taskMap.get(sourceId)) != null) {
            task.setBufferMgr(bufferMgr);
            task.setExecutorService((ExecutorService)this.executorServiceRef.getService());
            task.setEventsBuffer(this.eventsBuffer);
            task.setFormatter(this);
            task.start();
        }
    }

    public void unsetBufferManager(String sourceId, BufferManager bufferMgr) {
        Task task;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Un-setting buffer manager " + this), (Object[])new Object[]{sourceId, bufferMgr});
        }
        if ((task = this.taskMap.get(sourceId)) != null) {
            task.stop();
        }
    }

    public abstract Target getTarget();

    protected void stopAllTasks() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Stopping all configured tasks...", (Object[])new Object[0]);
        }
        for (Task t : this.taskMap.values()) {
            t.stop();
        }
    }
}

