/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxws.interceptors;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import jakarta.xml.ws.Holder;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxws.interceptors.WrapperClassOutInterceptor;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageContentsList;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public class HolderOutInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Logger LOG = LogUtils.getL7dLogger(HolderOutInterceptor.class);
    static final long serialVersionUID = -3282866571700238448L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public HolderOutInterceptor() {
        super("pre-logical");
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxws.interceptors.HolderOutInterceptor", "<init>", new Object[0]);
        }
        this.addBefore(WrapperClassOutInterceptor.class.getName());
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderOutInterceptor", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void handleMessage(@Sensitive Message message) throws Fault {
        OperationInfo op;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            Object[] objectArray = new Object[1];
            objectArray[0] = "<sensitive org.apache.cxf.message.Message>";
            LOG.entering("org.apache.cxf.jaxws.interceptors.HolderOutInterceptor", "handleMessage", objectArray);
        }
        boolean isFinestEnabled = LOG.isLoggable(Level.FINEST);
        boolean isFineEnabled = LOG.isLoggable(Level.FINE);
        MessageContentsList outObjects = MessageContentsList.getContentsList((Message)message);
        Exchange exchange = message.getExchange();
        OperationInfo operationInfo = op = exchange.getBindingOperationInfo() == null ? null : exchange.getBindingOperationInfo().getOperationInfo();
        if (isFineEnabled) {
            LOG.fine("op: " + op);
            if (null != op) {
                LOG.fine("op.hasOutput(): " + op.hasOutput());
                if (op.hasOutput()) {
                    LOG.fine("op.getOutput().size(): " + op.getOutput().size());
                }
            }
        }
        if (op == null || !op.hasOutput() || op.getOutput().size() == 0) {
            if (isFineEnabled) {
                LOG.fine("OperationInfo is null or empty. Returning.");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderOutInterceptor", "handleMessage");
            }
            return;
        }
        if (!this.isRequestor(message)) {
            List parts = op.getOutput().getMessageParts();
            MessageContentsList inObjects = MessageContentsList.getContentsList((Message)exchange.getInMessage());
            if (inObjects != null) {
                if (inObjects != outObjects) {
                    for (int x = 0; x < inObjects.size(); ++x) {
                        Object o = inObjects.get(x);
                        if (!(o instanceof Holder)) continue;
                        outObjects.set(x + 1, o);
                    }
                    if (isFinestEnabled) {
                        LOG.finest("Output MessageContentsList(outObjects) transferred from inbound MessageContentsList(inObjects): " + outObjects.toArray());
                    }
                } else {
                    LOG.severe("CANNOT_SET_HOLDER_OBJECTS");
                    throw new Fault(new org.apache.cxf.common.i18n.Message("CANNOT_SET_HOLDER_OBJECTS", LOG, new Object[0]));
                }
            }
            for (MessagePartInfo part : parts) {
                if (part.getIndex() <= 0 || part.getTypeClass() == null) continue;
                Holder holder = (Holder)outObjects.get(part);
                outObjects.put(part, holder.value);
                if (!isFinestEnabled) continue;
                LOG.finest("Holder object value located in MessagePartInfo is stripped and put back in MessagePartInfo:" + holder.value);
            }
        } else {
            ArrayList holders = new ArrayList(outObjects);
            for (int x = 0; x < outObjects.size(); ++x) {
                Object o = outObjects.get(x);
                if (o instanceof Holder) {
                    outObjects.set(x, ((Holder)o).value);
                    if (!isFinestEnabled) continue;
                    LOG.finest("The object in message contents list is wrapped in a holder:" + outObjects.get(x));
                    continue;
                }
                holders.set(x, null);
                if (!isFinestEnabled) continue;
                LOG.finest("A null value is set to holders list at the MessageContentsList index:" + holders.get(x));
            }
            message.put((Object)"client.holders", holders);
            if (isFinestEnabled) {
                LOG.finest("holders list is put in message with 'client.holders' key :" + holders);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxws.interceptors.HolderOutInterceptor", "handleMessage");
        }
    }
}

