/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.processor.runtime.impl;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.processor.exceptions.SIMPException;
import com.ibm.ws.sib.processor.impl.interfaces.HealthStateListener;
import com.ibm.ws.sib.processor.runtime.HealthState;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;

public class HealthStateTree
implements HealthStateListener {
    private HashMap<Integer, HealthState> states;
    private int state;
    private Integer reason = null;
    private boolean isLeaf;
    private HealthStateTree parent;
    private String[] inserts;
    private static final TraceComponent tc = SibTr.register(HealthStateTree.class, (String)"SIBProcessor", (String)"com.ibm.ws.sib.processor.CWSIPMessages");

    public HealthStateTree() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"HealthStateTree");
        }
        this.state = 2;
        this.reason = HealthStateListener.OK_STATE;
        this.isLeaf = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"HealthStateTree", (Object)this);
        }
    }

    private HealthStateTree(Integer reason, int state, HealthStateTree parent, String[] inserts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"HealthStateTree", (Object)new Object[]{reason, state, parent, Arrays.toString(inserts)});
        }
        this.state = state;
        this.reason = reason;
        this.isLeaf = true;
        this.parent = parent;
        this.inserts = inserts;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"HealthStateTree", (Object)this);
        }
    }

    public synchronized int getState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getState");
        }
        int worstState = this.getWorstState().state;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getState", (Object)worstState);
        }
        return worstState;
    }

    private HealthStateTree getWorstState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getWorstState");
        }
        HealthStateTree currentState = null;
        currentState = this.parent != null ? this.parent.getParentState() : new HealthStateTree();
        if (this.states != null) {
            Iterator<HealthState> it = this.states.values().iterator();
            while (it.hasNext()) {
                currentState = ((HealthStateTree)it.next()).getChildState(currentState);
            }
        } else if (currentState.compareTo(this) > 0) {
            currentState = this;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getWorstState", (Object)currentState);
        }
        return currentState;
    }

    private synchronized HealthStateTree getParentState() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getParentState");
        }
        HealthStateTree currentState = null;
        currentState = this.parent != null ? this.parent.getParentState() : new HealthStateTree();
        if (this.states != null) {
            for (HealthStateTree healthStateTree : this.states.values()) {
                if (!healthStateTree.isLeaf()) continue;
                currentState = healthStateTree.getChildState(currentState);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getParentState", (Object)currentState);
        }
        return currentState;
    }

    private synchronized HealthStateTree getChildState(HealthStateTree currentState) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getChildState", (Object)currentState);
        }
        if (this.states != null) {
            Iterator<HealthState> it = this.states.values().iterator();
            while (it.hasNext()) {
                currentState = ((HealthStateTree)it.next()).getChildState(currentState);
            }
        } else if (this.state != 2 && currentState.compareTo(this) > 0) {
            currentState = this;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getChildState", (Object)currentState);
        }
        return currentState;
    }

    public synchronized String getHealthReason(Locale l) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"getHealthReason", (Object)l);
        }
        HealthStateTree worstStateObj = this.getWorstState();
        int worstState = worstStateObj.state;
        Integer worstReason = worstStateObj.reason;
        Object[] inserts = worstStateObj.inserts;
        String nlsMessage = TraceNLS.getFormattedMessage((String)"com.ibm.ws.sib.processor.CWSIPMessages", (String)("HEALTHSTATE_STATUS_CWSIP09" + worstState + worstReason), (Locale)l, (Object[])inserts, (String)("HEALTHSTATE_STATUS_CWSIP09" + worstState + worstReason));
        if (nlsMessage.equals("HEALTHSTATE_STATUS_CWSIP09" + worstState + worstReason)) {
            SIMPException e = new SIMPException("Invalid health state " + worstState + ", " + worstReason);
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.processor.runtime.HealthStateTree.getHealthReason", (String)"1:232:1.11", (Object)this);
            SibTr.exception((TraceComponent)tc, (Exception)((Object)e));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"getHealthReason", (Object)nlsMessage);
        }
        return nlsMessage;
    }

    @Override
    public void updateHealth(Integer key, int state) {
        this.updateHealth(key, state, null);
    }

    @Override
    public synchronized void updateHealth(Integer key, int state, String[] inserts) {
        HealthStateTree updatingState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateHealth", (Object)new Object[]{key, state, Arrays.toString(inserts)});
        }
        if (this.states == null) {
            this.states = new HashMap();
        }
        if ((updatingState = (HealthStateTree)this.states.get(key)) != null) {
            if (updatingState.isLeaf()) {
                if (state == 2) {
                    this.states.remove(key);
                } else {
                    updatingState.updateLeafHealth(key, state, inserts);
                }
            } else {
                updatingState.updateHealth(key, state, inserts);
            }
        } else if (state != 2) {
            this.states.put(key, new HealthStateTree(key, state, this, inserts));
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"updateHealth", (Object)this);
        }
    }

    private boolean isLeaf() {
        return this.isLeaf;
    }

    private synchronized void updateLeafHealth(Integer key, int state, String[] inserts) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"updateLeafHealth", (Object)new Object[]{key, state, Arrays.toString(inserts)});
            SibTr.exit((TraceComponent)tc, (String)"updateLeafHealth");
        }
        this.state = state;
        this.reason = key;
        this.inserts = inserts;
    }

    public synchronized void addHealthStateNode(HealthState state) {
        HealthStateTree updatingState;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"addHealthStateNode", (Object)state);
        }
        if (this.states == null) {
            this.states = new HashMap();
        }
        if ((updatingState = (HealthStateTree)this.states.get(state.hashCode())) == null) {
            ((HealthStateTree)state).setParent(this);
            this.states.put(state.hashCode(), state);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"addHealthStateNode");
        }
    }

    @Override
    public synchronized void register(Integer key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"register", (Object)key);
        }
        if (this.states != null) {
            this.states.put(key, new HealthStateTree());
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"register");
        }
    }

    @Override
    public synchronized void deregister(Integer key) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"deregister", (Object)key);
        }
        if (this.states != null) {
            this.states.remove(key);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"deregister");
        }
    }

    public int compareTo(HealthState o) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"compareTo", (Object)new Object[]{this, o});
        }
        int equal = 0;
        equal = this.state > ((HealthStateTree)o).state ? 1 : (((HealthStateTree)o).state > this.state ? -1 : (this.reason.intValue() == ((HealthStateTree)o).reason.intValue() ? 0 : (HealthStateListener.orderedReasons[this.state][this.reason] > HealthStateListener.orderedReasons[this.state][((HealthStateTree)o).reason] ? -1 : 1)));
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"compareTo", (Object)equal);
        }
        return equal;
    }

    private void setParent(HealthStateTree state) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"setParent", (Object)state);
            SibTr.exit((TraceComponent)tc, (String)"setParent");
        }
        this.parent = state;
    }

    public String toString() {
        StringBuilder output = new StringBuilder("<HealthStateTree@" + Integer.toHexString(this.hashCode()));
        boolean closer = false;
        boolean impliedGreen = true;
        if (this.parent != null) {
            output.append(this.parent.parentToString());
            closer = true;
        }
        if (this.states != null) {
            Iterator<Integer> leaves = this.states.keySet().iterator();
            while (leaves.hasNext()) {
                impliedGreen = false;
                closer = true;
                Integer key = leaves.next();
                HealthStateTree s = (HealthStateTree)this.states.get(key);
                if (s.isLeaf()) {
                    output.append("\n<Leaf@" + Integer.toHexString(s.hashCode()) + " Leaf : ");
                    output.append(key);
                    output.append(" State : ");
                    output.append(this.stateToString(s.state));
                    output.append(" reason : ");
                    output.append(s.reason);
                    output.append(" inserts : ");
                    output.append(Arrays.toString(s.inserts) + ">");
                    continue;
                }
                output.append(s.childToString());
            }
        }
        if (this.isLeaf()) {
            impliedGreen = false;
            if (this.parent != null) {
                output.append("\n<NodeState");
            }
            output.append(" State : ");
            output.append(this.stateToString(this.state));
            output.append(", Reason : ");
            output.append(this.reason);
            output.append(" inserts : ");
            output.append(Arrays.toString(this.inserts) + ">");
            if (this.parent != null) {
                output.append(">");
            }
        }
        if (impliedGreen) {
            if (this.parent != null) {
                output.append("\n<NodeState");
            }
            output.append(" State: GREEN, Reason: OK");
            if (this.parent != null) {
                output.append(">");
            }
        }
        if (closer) {
            output.append("\n\\HealthStateTree>");
        } else {
            output.append(">");
        }
        return output.toString();
    }

    private String childToString() {
        StringBuilder output = new StringBuilder("\n<Child@" + Integer.toHexString(this.hashCode()));
        boolean impliedGreen = true;
        if (this.states != null) {
            for (Integer key : this.states.keySet()) {
                HealthStateTree s = (HealthStateTree)this.states.get(key);
                impliedGreen = false;
                if (s.isLeaf()) {
                    output.append("\n<Leaf@" + Integer.toHexString(s.hashCode()));
                    output.append(" State: ");
                    output.append(this.stateToString(s.state));
                    output.append(", Reason: ");
                    output.append(s.reason);
                    output.append(" inserts : ");
                    output.append(Arrays.toString(s.inserts) + ">");
                    continue;
                }
                output.append(s.childToString());
            }
        }
        if (impliedGreen) {
            output.append(" State: GREEN, Reason: OK>");
        } else {
            output.append("\n\\Child>");
        }
        return output.toString();
    }

    private String parentToString() {
        StringBuilder output = new StringBuilder("\n<Parent@" + Integer.toHexString(this.hashCode()));
        boolean closer = false;
        if (this.parent != null) {
            closer = true;
            output.append(this.parent.parentToString());
        }
        boolean impliedGreen = true;
        if (this.states != null) {
            for (Integer key : this.states.keySet()) {
                HealthStateTree s = (HealthStateTree)this.states.get(key);
                if (!s.isLeaf()) continue;
                closer = true;
                impliedGreen = false;
                output.append("\n<Leaf@" + Integer.toHexString(s.hashCode()));
                output.append(" State: ");
                output.append(this.stateToString(s.state));
                output.append(", Reason: ");
                output.append(s.reason);
                output.append(" inserts : ");
                output.append(Arrays.toString(s.inserts) + ">");
            }
        }
        if (impliedGreen) {
            if (this.parent != null) {
                output.append("\n<ParentState");
            }
            output.append(" State: GREEN, Reason: OK");
            if (this.parent != null) {
                output.append(">");
            }
        }
        if (closer) {
            output.append("\n\\Parent>");
        } else {
            output.append(">");
        }
        return output.toString();
    }

    String stateToString(int state) {
        if (state == 2) {
            return "GREEN";
        }
        if (state == 1) {
            return "AMBER";
        }
        return "RED";
    }
}

