/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi.internal.common;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.wab.configure.WABConfiguration;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Objects;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WABConfigManager {
    private static final TraceComponent tc = Tr.register(WABConfigManager.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    private static final WABConfiguration SERVICE_INSTANCE = new WABConfiguration(){
        static final long serialVersionUID = -794309036402913746L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi.internal.common.WABConfigManager$1", 1.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        }
    };
    private final BundleContext context;
    private final String contextName;
    private final String name;
    private String contextPath;
    private ServiceRegistration<WABConfiguration> wabConfigReg;
    private boolean closed;
    static final long serialVersionUID = -3885981135504732430L;

    public WABConfigManager(BundleContext context, String contextName, String name) {
        this.context = context;
        this.contextName = contextName;
        this.contextPath = null;
        this.name = name;
        this.closed = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPath(String path) {
        WABConfigManager wABConfigManager = this;
        synchronized (wABConfigManager) {
            if (this.closed) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle setPath called after close"), (Object[])new Object[0]);
                }
                return;
            }
            if (Objects.equals(path, this.contextPath)) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle path unchanged: " + path), (Object[])new Object[0]);
                }
                return;
            }
            if (path == null) {
                if (this.wabConfigReg != null) {
                    this.wabConfigReg.unregister();
                    this.wabConfigReg = null;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle unregistered"), (Object[])new Object[0]);
                    }
                }
            } else {
                Hashtable<String, String> props = new Hashtable<String, String>();
                ((Dictionary)props).put("contextName", this.contextName);
                ((Dictionary)props).put("contextPath", path);
                if (this.wabConfigReg == null) {
                    this.wabConfigReg = this.context.registerService(WABConfiguration.class, (Object)SERVICE_INSTANCE, props);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle registered, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
                    }
                } else {
                    this.wabConfigReg.setProperties(props);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                        Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle modified, WAB config=" + this.wabConfigReg + " using props=" + props), (Object[])new Object[0]);
                    }
                }
            }
            this.contextPath = path;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        WABConfigManager wABConfigManager = this;
        synchronized (wABConfigManager) {
            if (this.wabConfigReg == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle shutting down. Service already unregistered"), (Object[])new Object[0]);
                }
            } else {
                this.wabConfigReg.unregister();
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((Object)this, (TraceComponent)tc, (String)(this.name + " web app bundle shutting down. Service unregistered"), (Object[])new Object[0]);
                }
            }
            this.closed = true;
        }
    }
}

