/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.comms.server.clientsupport;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.comms.server.ConversationState;
import com.ibm.ws.sib.comms.server.ServerLinkLevelState;
import com.ibm.ws.sib.comms.server.clientsupport.ServerTransportReceiveListener;
import com.ibm.ws.sib.jfapchannel.AcceptListener;
import com.ibm.ws.sib.jfapchannel.ConnectionClosedListener;
import com.ibm.ws.sib.jfapchannel.ConnectionInterface;
import com.ibm.ws.sib.jfapchannel.Conversation;
import com.ibm.ws.sib.jfapchannel.ConversationReceiveListener;
import com.ibm.ws.sib.jfapchannel.ConversationUsageType;
import com.ibm.ws.sib.utils.ras.SibTr;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public class ServerTransportAcceptListener
implements AcceptListener,
ConnectionClosedListener {
    private static String CLASS_NAME = ServerTransportAcceptListener.class.getName();
    private static TraceComponent tc = SibTr.register(ServerTransportAcceptListener.class, (String)"SIBCommunications", (String)"com.ibm.ws.sib.comms.CWSICMessages");
    private static ServerTransportAcceptListener instance;
    private static ServerTransportReceiveListener serverTransportReceiveListener;
    private volatile HashMap activeConversations = new HashMap();

    public static ServerTransportAcceptListener getInstance() {
        return instance;
    }

    private ServerTransportAcceptListener() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"<init>");
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"<init>");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConversationReceiveListener acceptConnection(Conversation cfConversation) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((TraceComponent)tc, (String)"acceptConnection", (Object)cfConversation);
        }
        HashMap hashMap = this.activeConversations;
        synchronized (hashMap) {
            ConnectionInterface connectionReference = cfConversation.getConnectionReference();
            ArrayList<Conversation> list = (ArrayList<Conversation>)this.activeConversations.get(connectionReference);
            if (list == null) {
                list = new ArrayList<Conversation>();
                this.activeConversations.put(connectionReference, list);
            } else {
                int x;
                ArrayList<Conversation> removeList = new ArrayList<Conversation>();
                for (x = 0; x < list.size(); ++x) {
                    Conversation conv = (Conversation)list.get(x);
                    if (!conv.isClosed()) continue;
                    removeList.add(conv);
                }
                for (x = 0; x < removeList.size(); ++x) {
                    list.remove(removeList.get(x));
                }
            }
            list.add(cfConversation);
            if (cfConversation.getConnectionClosedListener(ConversationUsageType.JFAP) == null) {
                cfConversation.addConnectionClosedListener((ConnectionClosedListener)this, ConversationUsageType.JFAP);
            }
        }
        if (cfConversation.getAttachment() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Creating conversation state");
            }
            cfConversation.setAttachment((Object)new ConversationState());
        }
        if (cfConversation.getLinkLevelAttachment() == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                SibTr.debug((TraceComponent)tc, (String)"Creating link level state");
            }
            cfConversation.setLinkLevelAttachment((Object)new ServerLinkLevelState());
        }
        cfConversation.setConversationType(Conversation.CLIENT);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"acceptConnection", (Object)serverTransportReceiveListener);
        }
        return serverTransportReceiveListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConversation(Conversation conv) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeConversation", (Object)conv);
        }
        HashMap hashMap = this.activeConversations;
        synchronized (hashMap) {
            ConnectionInterface connectionReference = conv.getConnectionReference();
            ArrayList list = (ArrayList)this.activeConversations.get(connectionReference);
            if (list != null) {
                list.remove(conv);
                if (list.size() == 0) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((Object)this, (TraceComponent)tc, (String)"List is now empty, removing connection object");
                    }
                    this.activeConversations.remove(connectionReference);
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeConversation");
        }
    }

    public void connectionClosed(Object connectionReference) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"connectionClosed", (Object)connectionReference);
        }
        this.removeAllConversations(connectionReference);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"connectionClosed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getActiveConversations() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getActiveConversations");
        }
        ArrayList finalList = new ArrayList();
        HashMap hashMap = this.activeConversations;
        synchronized (hashMap) {
            Iterator i = this.activeConversations.values().iterator();
            while (i.hasNext()) {
                finalList.addAll((Collection)i.next());
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getActiveConversations", finalList);
        }
        return finalList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllConversations(Object connectionReference) {
        ArrayList list;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"removeAllConversations", (Object)connectionReference);
        }
        HashMap hashMap = this.activeConversations;
        synchronized (hashMap) {
            list = (ArrayList)this.activeConversations.remove(connectionReference);
        }
        if (list != null) {
            block10: {
                try {
                    for (int x = 0; x < list.size(); ++x) {
                        Conversation conv = (Conversation)list.get(x);
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((Object)this, (TraceComponent)tc, (String)"Found a Conversation in the table: ", (Object)conv);
                        }
                        serverTransportReceiveListener.cleanupConnection(conv);
                    }
                }
                catch (Throwable t) {
                    FFDCFilter.processException((Throwable)t, (String)(CLASS_NAME + ".removeAllConversations"), (String)"3-031-0001", (Object)this);
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block10;
                    SibTr.debug((Object)this, (TraceComponent)tc, (String)"Caught an exception cleaning up a connection", (Object)t);
                }
            }
            list.clear();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"removeAllConversations");
        }
    }

    static {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            SibTr.debug((TraceComponent)tc, (String)"Source info: @(#)SIB/ws/code/sib.comms.server.impl/src/com/ibm/ws/sib/comms/server/clientsupport/ServerTransportAcceptListener.java, SIB.comms, WASX.SIB, aa1225.01 1.25");
        }
        instance = new ServerTransportAcceptListener();
        serverTransportReceiveListener = ServerTransportReceiveListener.getInstance();
    }
}

