/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.grpc.internal.monitor;

import io.grpc.MethodDescriptor;

class GrpcMethod {
    private final String serviceName;
    private final String methodName;
    private final MethodDescriptor.MethodType type;

    static GrpcMethod of(MethodDescriptor<?, ?> method) {
        String serviceName = MethodDescriptor.extractFullServiceName((String)method.getFullMethodName());
        String methodName = method.getFullMethodName().substring(serviceName.length() + 1);
        return new GrpcMethod(serviceName, methodName, method.getType());
    }

    private GrpcMethod(String serviceName, String methodName, MethodDescriptor.MethodType type) {
        this.serviceName = serviceName;
        this.methodName = methodName;
        this.type = type;
    }

    String serviceName() {
        return this.serviceName;
    }

    String methodName() {
        return this.methodName;
    }

    String type() {
        return this.type.toString();
    }

    boolean serverSendsOneMessage() {
        return this.type.serverSendsOneMessage();
    }

    boolean clientSendsOneMessage() {
        return this.type.clientSendsOneMessage();
    }
}

