/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.context.cleared.internal;

import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDeserializationInfo;
import io.openliberty.microprofile.context.cleared.internal.MicroProfileClearedContextSnapshot;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.eclipse.microprofile.context.spi.ContextManagerProvider;
import org.eclipse.microprofile.context.spi.ThreadContextProvider;
import org.eclipse.microprofile.context.spi.ThreadContextSnapshot;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;

@Trivial
@Component(name="com.ibm.ws.concurrent.mp.cleared.context.provider", configurationPolicy=ConfigurationPolicy.IGNORE, property={"alwaysCaptureThreadContext:Boolean=true"})
public class MicroProfileClearedContextProvider
implements com.ibm.wsspi.threadcontext.ThreadContextProvider {
    private static final HashSet<String> DO_NOT_CLEAR = new HashSet<String>(Arrays.asList("Application", "CDI", "Classification", "EmptyHandleList", "Security", "SyncToOSThread", "Transaction"));
    @Reference
    private ContextManagerProvider cmProvider;

    public ThreadContext captureThreadContext(Map<String, String> execProps, Map<String, ?> threadContextConfig) {
        return this.createDefaultThreadContext(null);
    }

    public ThreadContext createDefaultThreadContext(Map<String, String> execProps) {
        ArrayList<ThreadContextSnapshot> contextSnapshots = new ArrayList<ThreadContextSnapshot>();
        Iterable providers = (Iterable)this.cmProvider.getContextManager();
        for (ThreadContextProvider provider : providers) {
            if (DO_NOT_CLEAR.contains(provider.getThreadContextType())) continue;
            contextSnapshots.add(provider.clearedContext(Collections.emptyMap()));
        }
        return new MicroProfileClearedContextSnapshot(contextSnapshots);
    }

    public ThreadContext deserializeThreadContext(ThreadContextDeserializationInfo info, byte[] bytes) throws ClassNotFoundException, IOException {
        return this.createDefaultThreadContext(null);
    }

    public List<com.ibm.wsspi.threadcontext.ThreadContextProvider> getPrerequisites() {
        return null;
    }
}

