/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto.ec;

import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import java.security.spec.ECParameterSpec;
import java.util.Objects;

public class EnhancedECParameterSpec
extends ECParameterSpec {
    private final ECParameterSpec original;

    public EnhancedECParameterSpec(@Nonnull ECParameterSpec spec) {
        super(spec.getCurve(), spec.getGenerator(), spec.getOrder(), spec.getCofactor());
        this.original = spec;
    }

    @Nonnull
    public ECParameterSpec getOriginal() {
        return this.original;
    }

    public int hashCode() {
        return Objects.hash(this.getCurve(), this.getGenerator(), this.getOrder(), this.getCofactor());
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof ECParameterSpec) {
            ECParameterSpec other = (ECParameterSpec)obj;
            return this.getCurve().getField().getFieldSize() == other.getCurve().getField().getFieldSize() && this.getCurve().equals(other.getCurve()) && this.getGenerator().equals(other.getGenerator()) && this.getOrder().equals(other.getOrder()) && this.getCofactor() == other.getCofactor();
        }
        return false;
    }
}

