/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.jfapchannel.impl;

import com.ibm.ws.sib.jfapchannel.impl.ExchangeReceiveListener;

public class ExchangeReceiveListenerPool {
    private final int size;
    private final ExchangeReceiveListener[] pool;
    private int entries = 0;

    public ExchangeReceiveListenerPool(int size) {
        this.size = size;
        this.pool = new ExchangeReceiveListener[size];
    }

    public synchronized ExchangeReceiveListener allocate(int expectedRequestNumber) {
        ExchangeReceiveListener result;
        if (this.entries == 0) {
            result = new ExchangeReceiveListener(this);
        } else {
            --this.entries;
            result = this.pool[this.entries];
            this.pool[this.entries] = null;
        }
        result.setExpectedRequestNumber(expectedRequestNumber);
        return result;
    }

    protected synchronized void release(ExchangeReceiveListener listener) {
        listener.reset();
        if (this.entries < this.size) {
            this.pool[this.entries] = listener;
            ++this.entries;
        }
    }
}

