/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.repository.transport.client;

import com.ibm.ws.repository.common.enums.ReadMode;
import com.ibm.ws.repository.transport.client.AbstractFileClient;
import com.ibm.ws.repository.transport.client.DirectoryUtils;
import com.ibm.ws.repository.transport.exceptions.BadVersionException;
import com.ibm.ws.repository.transport.exceptions.RequestFailureException;
import com.ibm.ws.repository.transport.model.Asset;
import com.ibm.ws.repository.transport.model.Attachment;
import com.ibm.ws.repository.transport.model.CopyUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.aries.util.manifest.ManifestProcessor;

public class DirectoryClient
extends AbstractFileClient {
    private final File _root;
    private final ReadMode _readMode;
    private List<Asset> _allAssetsCache;

    @Deprecated
    public DirectoryClient(File root) {
        this(root, ReadMode.DETECT_CHANGES);
    }

    public DirectoryClient(File root, ReadMode readMode) {
        this._root = root;
        this._readMode = readMode;
    }

    @Override
    public void checkRepositoryStatus() throws IOException {
        if (!this.exists(null)) {
            throw new FileNotFoundException("Could not find " + this._root);
        }
        if (!this.hasChildren(null)) {
            throw new IOException("The root (" + this._root + " is not a directory ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<Asset> getAllAssets() throws IOException {
        if (this._readMode == ReadMode.DETECT_CHANGES) {
            return super.getAllAssets();
        }
        if (this._allAssetsCache == null) {
            DirectoryClient directoryClient = this;
            synchronized (directoryClient) {
                if (this._allAssetsCache == null) {
                    this._allAssetsCache = super.getAllAssets();
                }
            }
        }
        return CopyUtils.copyCollection(this._allAssetsCache, Asset::new);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream getAttachment(Asset asset, Attachment attachment) throws IOException, BadVersionException, RequestFailureException {
        String attachmentId = attachment.get_id();
        if (attachmentId.contains("#")) {
            String assetId = asset.get_id();
            File zipFile = new File(this._root, assetId);
            ZipFile zip = DirectoryUtils.createZipFile(zipFile);
            FileInputStream fis = DirectoryUtils.createFileInputStream(zipFile);
            ZipInputStream zis = new ZipInputStream(fis);
            try {
                InputStream inputStream = this.getInputStreamToLicenseInsideZip(zis, assetId, attachmentId);
                return inputStream;
            }
            finally {
                zip.close();
            }
        }
        return DirectoryUtils.createFileInputStream(this.createFromRelative(attachmentId));
    }

    @Override
    protected boolean exists(String relative) {
        return DirectoryUtils.exists(this.createFromRelative(relative));
    }

    @Override
    protected boolean hasChildren(String relative) {
        return DirectoryUtils.isDirectory(this.createFromRelative(relative));
    }

    @Override
    protected long getSize(String relative) {
        return DirectoryUtils.length(this.createFromRelative(relative));
    }

    @Override
    protected Collection<String> getChildren(String relative) {
        String[] fullPath = DirectoryUtils.list(this.createFromRelative(relative));
        if (fullPath == null) {
            return Collections.emptyList();
        }
        if (relative.length() > 0) {
            for (int i = 0; i < fullPath.length; ++i) {
                fullPath[i] = relative + File.separator + fullPath[i];
            }
        }
        ArrayList<String> children = new ArrayList<String>();
        children.addAll(Arrays.asList(fullPath));
        for (String s : fullPath) {
            if (!this.hasChildren(s)) continue;
            children.addAll(this.getChildren(s));
        }
        return children;
    }

    protected File createFromRelative(String relative) {
        return relative == null ? this._root : new File(this._root, relative);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Asset readJson(String assetId) throws IOException, BadVersionException {
        try (FileInputStream fis = null;){
            Asset ass;
            fis = DirectoryUtils.createFileInputStream(this.createFromRelative(assetId + ".json"));
            Asset asset = ass = this.processJSON(fis);
            return asset;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Map<String, Long> getLicenses(String assetId) throws IOException {
        boolean isEsa = assetId.toLowerCase().endsWith(".esa");
        File zipFile = new File(this._root, assetId);
        ZipFile zip = DirectoryUtils.createZipFile(zipFile);
        HashMap<String, Long> licenses = new HashMap<String, Long>();
        String liLocation = this.getHeader(assetId, isEsa ? "IBM-License-Information" : "License-Information");
        String laLocation = this.getHeader(assetId, isEsa ? "IBM-License-Agreement" : "License-Agreement");
        if (liLocation != null || laLocation != null) {
            FileInputStream fis = null;
            ZipInputStream zis = null;
            try {
                fis = DirectoryUtils.createFileInputStream(zipFile);
                zis = new ZipInputStream(fis);
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    if (!ze.isDirectory() && (liLocation != null && ze.getName().startsWith(liLocation) || laLocation != null && ze.getName().startsWith(laLocation))) {
                        licenses.put(ze.getName().replace("/", File.separator), ze.getSize());
                    }
                    ze = zis.getNextEntry();
                }
            }
            finally {
                if (zis != null) {
                    zis.closeEntry();
                    zis.close();
                }
                if (zip != null) {
                    zip.close();
                }
                if (fis != null) {
                    fis.close();
                }
            }
        }
        return licenses;
    }

    @Override
    protected String getHeader(String assetId, String type) throws IOException {
        return this.getManifest(assetId).getMainAttributes().getValue(type);
    }

    protected Manifest getManifest(String assetId) throws IOException {
        boolean isEsa = assetId.toLowerCase().endsWith(".esa");
        if (isEsa) {
            return this.getSubsystemManifest(assetId);
        }
        return this.getJarManifest(assetId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getSubsystemManifest(String assetId) throws IOException {
        try (ZipFile zip = null;){
            Manifest manifest;
            zip = DirectoryUtils.createZipFile(new File(this._root, assetId));
            Enumeration<? extends ZipEntry> zipEntries = zip.entries();
            ZipEntry subsystemEntry = null;
            while (zipEntries.hasMoreElements()) {
                ZipEntry nextEntry = zipEntries.nextElement();
                if (!"OSGI-INF/SUBSYSTEM.MF".equalsIgnoreCase(nextEntry.getName())) continue;
                subsystemEntry = nextEntry;
                break;
            }
            if (subsystemEntry == null) {
                manifest = null;
                return manifest;
            }
            manifest = ManifestProcessor.parseManifest((InputStream)zip.getInputStream(subsystemEntry));
            return manifest;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Manifest getJarManifest(String assetId) throws IOException {
        File zipFile = new File(this._root, assetId);
        ZipFile zip = DirectoryUtils.createZipFile(zipFile);
        String mfName = "meta-inf/manifest.mf";
        Manifest manifest = new Manifest();
        FileInputStream fis = DirectoryUtils.createFileInputStream(zipFile);
        ZipInputStream zis = new ZipInputStream(fis);
        try {
            ZipEntry ze = zis.getNextEntry();
            while (ze != null) {
                String fileName;
                if (!ze.isDirectory() && (fileName = ze.getName()).equalsIgnoreCase(mfName)) {
                    InputStream is = zip.getInputStream(ze);
                    manifest.read(is);
                }
                ze = zis.getNextEntry();
            }
        }
        finally {
            zis.closeEntry();
            zis.close();
            zip.close();
        }
        return manifest;
    }
}

