/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.netty.upgrade;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.dispatcher.internal.HttpDispatcher;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.transport.access.TransportConnectionAccess;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.channel.CoalescingBufferQueue;
import io.netty.channel.VoidChannelPromise;
import io.netty.channel.socket.ChannelInputShutdownEvent;
import io.netty.channel.socket.ChannelInputShutdownReadComplete;
import io.netty.util.concurrent.ScheduledFuture;
import io.openliberty.netty.internal.impl.QuiesceState;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class NettyServletUpgradeHandler
extends ChannelDuplexHandler {
    private static final TraceComponent tc = Tr.register(NettyServletUpgradeHandler.class, null, null);
    private final CoalescingBufferQueue queue;
    private final Channel channel;
    private ChannelHandlerContext channelContext;
    private long totalBytesRead = 0L;
    private final ReentrantLock readLock = new ReentrantLock();
    private final Condition readCondition = this.readLock.newCondition();
    TCPReadCompletedCallback callback;
    private VirtualConnection vc;
    private TCPReadRequestContext readContext;
    private long minBytesToRead = 0L;
    private boolean isReadingAsync = false;
    private AtomicBoolean peerClosedConnection = new AtomicBoolean(false);
    private AtomicBoolean immediateTimeout = new AtomicBoolean(false);
    private AtomicInteger waitingThreads = new AtomicInteger(0);
    private final AtomicReference<ScheduledFuture<?>> currentTimeout = new AtomicReference();
    private final Runnable timerTask = () -> this.timeoutFired();
    static final long serialVersionUID = -6973176194445286630L;

    public NettyServletUpgradeHandler(Channel channel) {
        this.queue = new CoalescingBufferQueue(channel);
        this.channel = channel;
    }

    private void activateTimer(long timeout) {
        if (this.channel == null || timeout <= 0L) {
            return;
        }
        this.cancelTimer();
        ScheduledFuture future = this.channel.eventLoop().schedule(this.timerTask, timeout, TimeUnit.MILLISECONDS);
        this.currentTimeout.set(future);
    }

    private void timeoutFired() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Timeout hit for channel " + this.channel + " while reading async? " + this.isReadingAsync), (Object[])new Object[0]);
        }
        StringBuilder error = new StringBuilder();
        error.append("Socket operation timed out before it could be completed local=");
        error.append(this.readContext.getInterface().getLocalAddress().getHostName()).append("/");
        error.append(this.readContext.getInterface().getLocalAddress().getHostAddress()).append(":");
        error.append(this.readContext.getInterface().getLocalPort());
        error.append(" remote=");
        error.append(this.readContext.getInterface().getRemoteAddress().getHostName()).append("/");
        error.append(this.readContext.getInterface().getRemoteAddress().getHostAddress()).append(":");
        error.append(this.readContext.getInterface().getRemotePort());
        if (this.isReadingAsync) {
            this.isReadingAsync = false;
            HttpDispatcher.getExecutorService().execute(() -> {
                block2: {
                    try {
                        this.getReadListener().error(this.vc, this.readContext, (IOException)new SocketTimeoutException(error.toString()));
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler timeoutFired hit Exception on error callback: " + e), (Object[])new Object[0]);
                    }
                }
            });
        } else {
            this.channelContext.fireExceptionCaught((Throwable)new SocketTimeoutException(error.toString()));
        }
    }

    private void cancelTimer() {
        ScheduledFuture current = this.currentTimeout.getAndSet(null);
        if (current != null) {
            current.cancel(false);
        }
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.channelContext = ctx;
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
        if (!this.peerClosedConnection.get() && (evt instanceof ChannelInputShutdownEvent || evt instanceof ChannelInputShutdownReadComplete)) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler ChannelInputShutdownEvent kicked off for channel " + this.channel), (Object[])new Object[0]);
            }
            if (this.isReadingAsync) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler ChannelInputShutdownEvent reading async found!!", (Object[])new Object[0]);
                }
                this.isReadingAsync = false;
                this.peerClosedConnection.getAndSet(true);
                if (this.totalBytesRead < this.minBytesToRead) {
                    HttpDispatcher.getExecutorService().execute(() -> {
                        block2: {
                            try {
                                this.getReadListener().error(this.vc, this.readContext, (IOException)new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.channel.localAddress() + " remote=" + this.channel.remoteAddress()));
                            }
                            catch (Exception e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler userEventTriggered hit Exception on error callback: " + e), (Object[])new Object[0]);
                            }
                        }
                    });
                } else {
                    HttpDispatcher.getExecutorService().execute(() -> {
                        block2: {
                            try {
                                this.setToBuffer();
                                this.callback.complete(this.vc, this.readContext);
                            }
                            catch (Exception e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler userEventTriggered hit Exception on complete callback: " + e), (Object[])new Object[0]);
                            }
                        }
                    });
                }
                return;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler ChannelInputShutdownEvent NOT reading async!!", (Object[])new Object[0]);
            }
            this.peerClosedConnection.getAndSet(true);
            if (this.queuedDataSize() > 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler userEventTriggered found queued data, signaling read for channel " + this.channel), (Object[])new Object[0]);
                }
                this.signalReadReady();
            }
        }
        super.userEventTriggered(ctx, evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof ByteBuf) {
            ByteBuf buf = (ByteBuf)msg;
            try {
                buf.retain();
                this.queue.add(buf);
                long bytesRead = buf.readableBytes();
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler channelRead called for channel " + this.channel + " Adding bytes read: " + bytesRead), (Object[])new Object[0]);
                }
                this.totalBytesRead += bytesRead;
                if (this.isReadingAsync) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler channelRead found async!!", (Object[])new Object[0]);
                    }
                    if (this.totalBytesRead < this.minBytesToRead) {
                        return;
                    }
                    this.cancelTimer();
                    this.isReadingAsync = false;
                    HttpDispatcher.getExecutorService().execute(() -> {
                        block2: {
                            try {
                                this.setToBuffer();
                                this.callback.complete(this.vc, this.readContext);
                            }
                            catch (Exception e) {
                                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler channelRead hit Exception on complete callback: " + e), (Object[])new Object[0]);
                            }
                        }
                    });
                    return;
                }
                if (this.totalBytesRead < this.minBytesToRead) return;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler channelRead totalBytesRead greater than minimum bytes requested for channel " + this.channel), (Object[])new Object[0]);
                }
                this.signalReadReady();
                return;
            }
            catch (Exception bytesRead) {
                void e;
                FFDCFilter.processException((Throwable)bytesRead, (String)"com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler", (String)"233", (Object)((Object)this), (Object[])new Object[]{ctx, msg});
                ctx.fireExceptionCaught((Throwable)e);
                return;
            }
            finally {
                buf.release();
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cancelTimer();
        if (this.isReadingAsync) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler channelInactive reading async found!!", (Object[])new Object[0]);
            }
            this.isReadingAsync = false;
            this.peerClosedConnection.getAndSet(true);
            HttpDispatcher.getExecutorService().execute(() -> {
                block2: {
                    try {
                        this.getReadListener().error(this.vc, this.readContext, (IOException)new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.channel.localAddress() + " remote=" + this.channel.remoteAddress()));
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler userEventTriggered hit Exception on error callback: " + e), (Object[])new Object[0]);
                    }
                }
            });
        }
        super.channelInactive(ctx);
    }

    /*
     * WARNING - void declaration
     */
    public void immediateTimeout() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Inside immediate timeout! " + this.channel), (Object[])new Object[0]);
        }
        if (this.isReadingAsync) {
            this.cancelTimer();
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("Timeout hit for channel on async" + this.channel), (Object[])new Object[0]);
            }
            StringBuilder error = new StringBuilder();
            error.append("Socket operation timed out before it could be completed local=");
            error.append(this.readContext.getInterface().getLocalAddress().getHostName()).append("/");
            error.append(this.readContext.getInterface().getLocalAddress().getHostAddress()).append(":");
            error.append(this.readContext.getInterface().getLocalPort());
            error.append(" remote=");
            error.append(this.readContext.getInterface().getRemoteAddress().getHostName()).append("/");
            error.append(this.readContext.getInterface().getRemoteAddress().getHostAddress()).append(":");
            error.append(this.readContext.getInterface().getRemotePort());
            this.isReadingAsync = false;
            HttpDispatcher.getExecutorService().execute(() -> {
                block2: {
                    try {
                        this.getReadListener().error(this.vc, this.readContext, (IOException)new SocketTimeoutException(error.toString()));
                    }
                    catch (Exception e) {
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block2;
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler immediateTimeout hit Exception on error callback: " + e), (Object[])new Object[0]);
                    }
                }
            });
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler immediateTimeout NOT found async!!", (Object[])new Object[0]);
        }
        this.immediateTimeout.getAndSet(true);
        this.signalReadReady();
        while (this.waitingThreads.get() > 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler immediateTimeout waiting to finish immediate timeout on channel: " + this.channel), (Object[])new Object[0]);
            }
            try {
                Thread.sleep(500L);
            }
            catch (Exception error) {
                void e;
                FFDCFilter.processException((Throwable)error, (String)"com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler", (String)"312", (Object)((Object)this), (Object[])new Object[0]);
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler immediateTimeout hit Exception on thread sleep: " + e), (Object[])new Object[0]);
            }
        }
        this.immediateTimeout.getAndSet(false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("End immediate timeout! " + this.channel), (Object[])new Object[0]);
        }
    }

    private void signalReadReady() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler signalReadReady locking readLock for channel " + this.channel), (Object[])new Object[0]);
        }
        this.readLock.lock();
        try {
            this.readCondition.signalAll();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler signalReadReady unlocking readLock for channel " + this.channel), (Object[])new Object[0]);
            }
            this.readLock.unlock();
        }
    }

    public void waitForDataRead(long waitTime) throws InterruptedException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler waitForDataRead locking readLock for channel " + this.channel), (Object[])new Object[0]);
        }
        this.readLock.lock();
        try {
            while (!this.immediateTimeout.get() && !this.containsQueuedData() && this.channel.isActive() && this.readCondition.await(waitTime, TimeUnit.MILLISECONDS)) {
            }
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler waitForDataRead unlocking readLock for channel " + this.channel), (Object[])new Object[0]);
            }
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean awaitReadReady(long numBytes, int timeout, TimeUnit unit) throws EOFException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler awaitReadReady called for channel " + this.channel), (Object[])new Object[0]);
        }
        this.minBytesToRead = numBytes;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler awaitReadReady locking readLock for channel " + this.channel), (Object[])new Object[0]);
        }
        this.waitingThreads.incrementAndGet();
        this.readLock.lock();
        boolean dataReady = false;
        try {
            if ((long)this.queuedDataSize() >= numBytes) {
                dataReady = true;
            } else {
                long waitTime = timeout == -1 ? Long.MAX_VALUE : unit.toNanos(timeout);
                long endTime = System.nanoTime() + waitTime;
                while (!(this.peerClosedConnection.get() || this.immediateTimeout.get() || this.totalBytesRead >= this.minBytesToRead || !this.channel.isActive() || QuiesceState.isQuiesceInProgress() || timeout != -1 && (waitTime = endTime - System.nanoTime()) <= 0L)) {
                    if (timeout == -1) {
                        waitTime = TimeUnit.SECONDS.toNanos(1L);
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler awaitReadReady waiting " + waitTime + "ns for min bytes to read: " + this.minBytesToRead + " with total bytes read: " + this.totalBytesRead + " on channel: " + this.channel), (Object[])new Object[0]);
                            }
                            this.readCondition.awaitNanos(waitTime);
                        }
                        catch (InterruptedException interruptedException) {
                            FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler", (String)"392", (Object)((Object)this), (Object[])new Object[]{numBytes, timeout, unit});
                            Thread.currentThread().interrupt();
                        }
                        continue;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler awaitReadReady waiting " + waitTime + " for min bytes to read: " + this.minBytesToRead + " with total bytes read: " + this.totalBytesRead + " on channel: " + this.channel), (Object[])new Object[0]);
                    }
                    this.readCondition.awaitNanos(waitTime);
                }
                boolean bl = dataReady = this.totalBytesRead >= this.minBytesToRead;
                if (this.immediateTimeout.get()) {
                    throw new IllegalStateException("Read interrupted by immediate timeout");
                }
            }
        }
        catch (InterruptedException waitTime) {
            FFDCFilter.processException((Throwable)waitTime, (String)"com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler", (String)"409", (Object)((Object)this), (Object[])new Object[]{numBytes, timeout, unit});
            Thread.currentThread().interrupt();
        }
        finally {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler awaitReadReady unlocking readLock for channel: " + this.channel), (Object[])new Object[0]);
            }
            this.waitingThreads.decrementAndGet();
            this.readLock.unlock();
        }
        if (this.peerClosedConnection.get() && !dataReady) {
            throw new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.channel.localAddress() + " remote=" + this.channel.remoteAddress());
        }
        return dataReady;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FFDCIgnore(value={RuntimeException.class})
    public synchronized long setToBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler setToBuffer called for channel: " + this.channel), (Object[])new Object[0]);
        }
        if (!this.containsQueuedData()) {
            return 0L;
        }
        int currentQueuedDataSize = this.queuedDataSize();
        int remainingBufferSize = this.readContext.getBuffer().remaining();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler setToBuffer currentQueuedSize:" + currentQueuedDataSize + ", remainingBufferSize" + remainingBufferSize), (Object[])new Object[0]);
        }
        if ((long)currentQueuedDataSize >= this.minBytesToRead) {
            int readTotal = currentQueuedDataSize >= remainingBufferSize ? remainingBufferSize : currentQueuedDataSize;
            ByteBuf buffer = this.read(readTotal, null);
            try {
                byte[] bytes = ByteBufUtil.getBytes((ByteBuf)buffer);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)("NettyServletUpgradeHandler setToBuffer queue bigger than min bytes. Reading total of: " + readTotal), (Object[])new Object[0]);
                }
                this.readContext.getBuffer().put(bytes);
                this.totalBytesRead -= (long)bytes.length;
                long l = bytes.length;
                return l;
            }
            catch (RuntimeException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler setToBuffer hit RuntimeException when adding bytes. We assume the buffer was already released so stop thread run.", (Object[])new Object[0]);
                }
                Thread.currentThread().interrupt();
            }
            finally {
                buffer.release();
            }
        }
        return 0L;
    }

    /*
     * WARNING - void declaration
     */
    public void close(ChannelHandlerContext ctx, ChannelPromise promise) throws Exception {
        if (this.vc != null) {
            Object webConnectionObject;
            String upgraded;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler close verifying Virtual Connection maps.", (Object[])new Object[0]);
            }
            if ("true".equalsIgnoreCase(upgraded = (String)this.vc.getStateMap().get("UpgradedConnection")) && (webConnectionObject = this.vc.getStateMap().get("UpgradedWebConnectionObject")) != null) {
                if (webConnectionObject instanceof TransportConnectionAccess) {
                    TransportConnectionAccess tWebConn = (TransportConnectionAccess)webConnectionObject;
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((Object)((Object)this), (TraceComponent)tc, (String)"NettyServletUpgradeHandler close attempting to close TransportConnectionAccess.", (Object[])new Object[0]);
                        }
                        tWebConn.close();
                    }
                    catch (Exception exception) {
                        FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.netty.upgrade.NettyServletUpgradeHandler", (String)"485", (Object)((Object)this), (Object[])new Object[]{ctx, promise});
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            void webConnectionCloseException;
                            Tr.debug((TraceComponent)tc, (String)"Failed to close WebConnection {0}", (Object[])new Object[]{webConnectionCloseException});
                        }
                    }
                } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"call application destroy if not done yet", (Object[])new Object[0]);
                }
            }
        }
        this.peerClosedConnection.getAndSet(true);
        super.close(ctx, promise);
    }

    public void channelWritabilityChanged(ChannelHandlerContext ctx) throws Exception {
        super.channelWritabilityChanged(ctx);
    }

    public boolean containsQueuedData() {
        return !this.queue.isEmpty();
    }

    public int queuedDataSize() {
        return this.queue.readableBytes();
    }

    public boolean isImmediateTimeout() {
        return this.immediateTimeout.get();
    }

    public synchronized ByteBuf read(int size, ChannelPromise promise) {
        if (!this.containsQueuedData()) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (promise == null) {
            return this.queue.remove(size, (ChannelPromise)new VoidChannelPromise(this.channel, true));
        }
        return this.queue.remove(size, promise);
    }

    public void setReadListener(TCPReadCompletedCallback callback) {
        this.callback = callback;
    }

    public void queueAsyncRead(long timeout, long minBytesToRead) throws EOFException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("NettyServletUpgradeHandler called queueAsyncRead for channel: " + this.channel), (Object[])new Object[0]);
        }
        this.minBytesToRead = minBytesToRead;
        if (this.peerClosedConnection.get() && this.totalBytesRead < minBytesToRead) {
            throw new EOFException("Connection closed: Read failed.  Possible end of stream encountered. local=" + this.channel.localAddress() + " remote=" + this.channel.remoteAddress());
        }
        this.isReadingAsync = true;
        if (timeout > 0L) {
            this.activateTimer(timeout);
        }
    }

    public boolean peerClosedConnection() {
        return this.peerClosedConnection.get();
    }

    public TCPReadCompletedCallback getReadListener() {
        return this.callback;
    }

    public void setVC(VirtualConnection vc) {
        this.vc = vc;
    }

    public void setTCPReadContext(TCPReadRequestContext context) {
        this.readContext = context;
    }
}

