/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.clientcontainer.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.clientcontainer.internal.ClientModuleInjection;
import com.ibm.ws.clientcontainer.internal.ClientModuleRuntimeContainer;
import com.ibm.ws.clientcontainer.internal.LifecycleCallbackHelper;
import com.ibm.ws.clientcontainer.metadata.ClientModuleMetaData;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.client.ApplicationClient;
import com.ibm.ws.javaee.dd.common.LifecycleCallback;
import com.ibm.ws.kernel.launch.service.ClientRunner;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.runtime.metadata.ComponentMetaData;
import com.ibm.ws.threadContext.ComponentMetaDataAccessorImpl;
import com.ibm.wsspi.injectionengine.InjectionException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientRunnerImpl
implements ClientRunner {
    private static final TraceComponent tc = Tr.register(ClientRunnerImpl.class, (String)"clientContainer", (String)"com.ibm.ws.clientcontainer.resources.Messages");
    private static final int MAX_WAIT_TO_LAUNCH = Integer.getInteger("com.ibm.ws.clientcontainer.maxLaunchWaitTime", 30000);
    private boolean readyToRun;
    private boolean initFailed;
    private String[] args;
    private Class<?> mainClass;
    public Exception invokeException;
    private ComponentMetaData cmd;
    private ClassLoader classLoader;
    private ClientModuleInjection cmi;
    static final long serialVersionUID = -1539108055940073882L;

    ClientRunnerImpl() {
    }

    synchronized void readyToRun(ClientModuleInjection cmi, String[] args, ComponentMetaData cmd, ClassLoader classLoader) throws ClassNotFoundException {
        this.cmi = cmi;
        this.mainClass = cmi.getMainClass();
        this.args = (String[])args.clone();
        this.cmd = cmd;
        this.classLoader = classLoader;
        this.readyToRun = true;
        this.notify();
    }

    synchronized void setupFailure() {
        this.initFailed = true;
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    public synchronized void run() {
        if (this.initFailed) {
            throw new IllegalStateException("Client module main failed initialization");
        }
        if (!this.readyToRun) {
            try {
                this.wait(MAX_WAIT_TO_LAUNCH);
            }
            catch (InterruptedException interruptedException) {
                FFDCFilter.processException((Throwable)interruptedException, (String)"com.ibm.ws.clientcontainer.internal.ClientRunnerImpl", (String)"73", (Object)this, (Object[])new Object[0]);
                if (this.initFailed) {
                    throw new IllegalStateException("Client module main failed initialization");
                }
                if (!this.readyToRun) {
                    throw new IllegalStateException("Failed to initialize client prior to attempted invocation.");
                }
            }
            finally {
                if (this.initFailed) {
                    throw new IllegalStateException("Client module main failed initialization");
                }
                if (!this.readyToRun) {
                    throw new IllegalStateException("Failed to initialize client prior to attempted invocation.");
                }
            }
        }
        Method mainMethod = null;
        Object[] appParms = new Object[]{this.getUserAppArgs()};
        ClassLoader origLoader = AccessController.doPrivileged(new ClientModuleRuntimeContainer.GetTCCL());
        ClassLoader newLoader = AccessController.doPrivileged(new ClientModuleRuntimeContainer.SetTCCL(this.classLoader));
        try {
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().beginContext(this.cmd);
            Class<String[]> parms = String[].class;
            mainMethod = this.mainClass.getMethod("main", parms);
            this.processPostConstruct();
            mainMethod.invoke(null, appParms);
            this.processPreDestroy();
        }
        catch (Exception parms) {
            void e;
            FFDCFilter.processException((Throwable)parms, (String)"com.ibm.ws.clientcontainer.internal.ClientRunnerImpl", (String)"99", (Object)this, (Object[])new Object[0]);
            this.invokeException = e;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception occurred invoking main method", (Object[])new Object[]{e});
            }
        }
        finally {
            if (origLoader != newLoader) {
                AccessController.doPrivileged(new ClientModuleRuntimeContainer.SetTCCL(origLoader));
            }
            ComponentMetaDataAccessorImpl.getComponentMetaDataAccessor().endContext();
        }
    }

    private Object getUserAppArgs() {
        return this.args;
    }

    @FFDCIgnore(value={InjectionException.class})
    private void processPostConstruct() {
        ApplicationClient appClient = ((ClientModuleMetaData)this.cmd.getModuleMetaData()).getAppClient();
        boolean isMetadataComplete = appClient.isMetadataComplete();
        LifecycleCallbackHelper helper = new LifecycleCallbackHelper(isMetadataComplete);
        List postConstruct = appClient.getPostConstruct();
        CallbackHandler loginCallbackHandler = this.cmi.getCallbackHandler();
        try {
            if (loginCallbackHandler != null) {
                helper.doPostConstruct(loginCallbackHandler, (List<LifecycleCallback>)postConstruct);
            }
            helper.doPostConstruct(this.mainClass, (List<LifecycleCallback>)postConstruct);
        }
        catch (InjectionException e) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_POSTCONSTRUCT_CWWKC2452E", (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }

    @FFDCIgnore(value={InjectionException.class})
    private void processPreDestroy() {
        ApplicationClient appClient = ((ClientModuleMetaData)this.cmd.getModuleMetaData()).getAppClient();
        boolean isMetadataComplete = appClient.isMetadataComplete();
        LifecycleCallbackHelper helper = new LifecycleCallbackHelper(isMetadataComplete);
        List preDestroy = appClient.getPreDestroy();
        CallbackHandler loginCallbackHandler = this.cmi.getCallbackHandler();
        try {
            if (loginCallbackHandler != null) {
                helper.doPreDestroy(loginCallbackHandler, preDestroy);
            }
        }
        catch (InjectionException e) {
            Tr.error((TraceComponent)tc, (String)"INJECTION_PREDESTROY_CWWKC2453E", (Object[])new Object[]{e.getLocalizedMessage()});
        }
    }
}

