/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.reactive.messaging.kafka.adapter;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.security.AccessController;
import java.util.Map;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class BetaUtils {
    public static final String EARLY_ACCESS = "EARLY_ACCESS";
    public static final String USE_KAFKA_PRODUCER_RECORD_PROP = "use.kafka.producer.record";
    public static final boolean USE_KAFKA_PRODUCER_RECORD;
    static final long serialVersionUID = -1110757675519762866L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static boolean isBetaCodeEnabled(String customProperty) {
        boolean isBetaCodeEnabled = false;
        Boolean customPropertyOverride = null;
        if (customProperty != null) {
            customPropertyOverride = BetaUtils.getBooleanProperty(customProperty);
        }
        isBetaCodeEnabled = customPropertyOverride != null ? customPropertyOverride : BetaUtils.isEarlyAccess();
        return isBetaCodeEnabled;
    }

    public static boolean isEarlyAccess() {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = AccessController.doPrivileged(() -> BetaUtils.unPrivilegedIsEarlyAccess());
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static boolean unPrivilegedIsEarlyAccess() {
        boolean isEarlyAccess = false;
        try {
            Map productInfos = ProductInfo.getAllProductInfo();
            for (ProductInfo info : productInfos.values()) {
                if (!EARLY_ACCESS.equals(info.getEdition())) continue;
                isEarlyAccess = true;
            }
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.BetaUtils", (String)"85", null, (Object[])new Object[0]);
        }
        return isEarlyAccess;
    }

    @Trivial
    public static String getProperty(String propertyName) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            String string = AccessController.doPrivileged(() -> System.getProperty(propertyName));
            return string;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    public static Boolean getBooleanProperty(String propertyName) {
        String propertyText = BetaUtils.getProperty(propertyName);
        Boolean propertyValue = propertyText == null ? null : Boolean.valueOf(propertyText);
        return propertyValue;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.microprofile.reactive.messaging.kafka.adapter.BetaUtils", BetaUtils.class, (String)"REACTIVEMESSAGE", (String)"com.ibm.ws.microprofile.reactive.messaging.kafka.resources.ReactiveMessaging");
        USE_KAFKA_PRODUCER_RECORD = BetaUtils.isBetaCodeEnabled(USE_KAFKA_PRODUCER_RECORD_PROP);
    }
}

