/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.jpa.querydef;

import jakarta.persistence.criteria.Selection;
import java.lang.reflect.Constructor;
import org.eclipse.persistence.internal.jpa.querydef.CompoundSelectionImpl;
import org.eclipse.persistence.internal.jpa.querydef.SelectionImpl;
import org.eclipse.persistence.internal.queries.ReportItem;
import org.eclipse.persistence.queries.ConstructorReportItem;

public class ConstructorSelectionImpl<X>
extends CompoundSelectionImpl<X> {
    protected transient Constructor<? extends X> constructor;
    protected Class<?>[] constructorArgTypes;

    public ConstructorSelectionImpl(Class<? extends X> javaType, Selection<?>[] subSelections) {
        super(javaType, subSelections, true);
    }

    public ConstructorReportItem translate() {
        ConstructorReportItem item = new ConstructorReportItem(this.getAlias());
        item.setResultType(this.getJavaType());
        item.setConstructor(this.constructor);
        for (Selection<?> selection : this.getCompoundSelectionItems()) {
            if (selection.isCompoundSelection()) {
                item.addItem(((ConstructorSelectionImpl)selection).translate());
                continue;
            }
            ReportItem reportItem = new ReportItem(item.getName() + item.getReportItems().size(), ((SelectionImpl)selection).getCurrentNode());
            reportItem.setResultType(selection.getJavaType());
            item.addItem(reportItem);
        }
        return item;
    }

    @Override
    public boolean isConstructor() {
        return true;
    }

    public void setConstructor(Constructor<? extends X> constructor) {
        this.constructor = constructor;
    }

    public void setConstructorArgTypes(Class<?>[] constructorArgTypes) {
        this.constructorArgTypes = constructorArgTypes;
    }
}

