/*
 * Decompiled with CFR 0.152.
 */
package org.shredzone.acme4j.provider.pebble;

import jakarta.annotation.ParametersAreNonnullByDefault;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.shredzone.acme4j.connector.HttpConnector;
import org.shredzone.acme4j.provider.AbstractAcmeProvider;
import org.shredzone.acme4j.provider.pebble.PebbleHttpConnector;

@ParametersAreNonnullByDefault
public class PebbleAcmeProvider
extends AbstractAcmeProvider {
    private static final Pattern HOST_PATTERN = Pattern.compile("^/([^:/]+)(?:\\:(\\d+))?/?$");

    @Override
    public boolean accepts(URI serverUri) {
        return "acme".equals(serverUri.getScheme()) && "pebble".equals(serverUri.getHost());
    }

    @Override
    public URL resolve(URI serverUri) {
        try {
            String path = serverUri.getPath();
            URL baseUrl = new URL("https://localhost:14000/dir");
            if (path != null && !path.isEmpty() && !"/".equals(path)) {
                baseUrl = this.parsePath(path);
            }
            return baseUrl;
        }
        catch (MalformedURLException ex) {
            throw new IllegalArgumentException("Bad server URI " + serverUri, ex);
        }
    }

    private URL parsePath(String path) throws MalformedURLException {
        Matcher m = HOST_PATTERN.matcher(path);
        if (m.matches()) {
            String host = m.group(1);
            int port = 14000;
            if (m.group(2) != null) {
                port = Integer.parseInt(m.group(2));
            }
            return new URL("https", host, port, "/dir");
        }
        throw new IllegalArgumentException("Invalid Pebble host/port: " + path);
    }

    @Override
    protected HttpConnector createHttpConnector() {
        return new PebbleHttpConnector();
    }
}

