/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal.schemas;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.ToolMetadata;
import io.openliberty.mcp.internal.schemas.SchemaAnnotation;
import io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintGenerator;
import io.openliberty.mcp.internal.schemas.SchemaCreationBlueprintRegistry;
import io.openliberty.mcp.internal.schemas.SchemaDirection;
import io.openliberty.mcp.internal.schemas.blueprints.ClassSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.ListSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.MapSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.OptionalSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.SchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.TypeVariableSchemaCreationBlueprint;
import io.openliberty.mcp.internal.schemas.blueprints.WildcardSchemaCreationBlueprint;
import jakarta.enterprise.inject.spi.AnnotatedMethod;
import jakarta.json.Json;
import jakarta.json.JsonArrayBuilder;
import jakarta.json.JsonObject;
import jakarta.json.JsonObjectBuilder;
import jakarta.json.JsonValue;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class SchemaGenerator {
    private static final JsonObject GENERATION_IN_PROGRESS;
    static final long serialVersionUID = 4225902980439961192L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static JsonObject generateSchema(Class<?> cls, SchemaDirection direction, SchemaCreationBlueprintRegistry blueprintRegistry) {
        SchemaAnnotation annotationInfo = SchemaAnnotation.read(cls);
        Optional<JsonObjectBuilder> annotationSchema = annotationInfo.asJsonSchema();
        if (annotationSchema.isPresent()) {
            return annotationSchema.get().build();
        }
        SchemaGenerationContext ctx = new SchemaGenerationContext(blueprintRegistry, direction);
        SchemaGenerator.calculateClassFrequency(cls, direction, ctx);
        JsonObjectBuilder result = SchemaGenerator.generateSubSchema(cls, ctx, annotationInfo);
        SchemaGenerator.addDefs(result, ctx);
        return result.build();
    }

    public static JsonObject generateToolInputSchema(AnnotatedMethod<?> toolMethod, SchemaCreationBlueprintRegistry blueprintRegistry) {
        JsonObjectBuilder properties = Json.createObjectBuilder();
        JsonArrayBuilder required = Json.createArrayBuilder();
        Parameter[] parameters = toolMethod.getJavaMember().getParameters();
        SchemaGenerationContext ctx = new SchemaGenerationContext(blueprintRegistry, SchemaDirection.INPUT);
        Map<String, ToolMetadata.ArgumentMetadata> arguments = ToolMetadata.getArgumentMap(toolMethod);
        for (ToolMetadata.ArgumentMetadata argumentMetadata : arguments.values()) {
            Parameter parameter = parameters[argumentMetadata.index()];
            SchemaGenerator.calculateClassFrequency(parameter.getParameterizedType(), SchemaDirection.INPUT, ctx);
        }
        for (Map.Entry entry : arguments.entrySet()) {
            String argumentName = (String)entry.getKey();
            ToolMetadata.ArgumentMetadata argument = (ToolMetadata.ArgumentMetadata)entry.getValue();
            Parameter parameter = parameters[argument.index()];
            SchemaAnnotation annotation = SchemaAnnotation.read(parameter);
            JsonObjectBuilder parameterSchemaBuilder = SchemaGenerator.generateSubSchema(parameter.getParameterizedType(), ctx, annotation);
            if (argument.description() != null && !argument.description().equals("")) {
                parameterSchemaBuilder.add("description", argument.description());
            }
            properties.add(argumentName, (JsonValue)parameterSchemaBuilder.build());
            if (!argument.required()) continue;
            required.add(argumentName);
        }
        JsonObjectBuilder schemaBuilder = Json.createObjectBuilder().add("type", "object").add("properties", (JsonValue)properties.build()).add("required", (JsonValue)required.build());
        SchemaGenerator.addDefs(schemaBuilder, ctx);
        return schemaBuilder.build();
    }

    public static JsonObject generateToolOutputSchema(AnnotatedMethod<?> toolMethod, SchemaCreationBlueprintRegistry blueprintRegistry) {
        Type returnType = toolMethod.getJavaMember().getGenericReturnType();
        Method method = toolMethod.getJavaMember();
        SchemaAnnotation schemaAnnotation = SchemaAnnotation.read(method);
        SchemaGenerationContext ctx = new SchemaGenerationContext(blueprintRegistry, SchemaDirection.OUTPUT);
        SchemaGenerator.calculateClassFrequency(returnType, SchemaDirection.OUTPUT, ctx);
        JsonObjectBuilder outputSchema = SchemaGenerator.generateSubSchema(returnType, ctx, schemaAnnotation);
        SchemaGenerator.addDefs(outputSchema, ctx);
        return outputSchema.build();
    }

    public static void calculateClassFrequency(Type type, SchemaDirection direction, SchemaGenerationContext ctx) {
        block5: {
            SchemaCreationBlueprint scc;
            block10: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                scc = ctx.getBlueprintRegistry().getSchemaCreationBlueprint(type);
                                boolean previouslySeen = false;
                                if (scc.getDefsName().isPresent() && (previouslySeen = ctx.registerSeen(type))) {
                                    ctx.reserveName(type, scc.getDefsName().get());
                                }
                                if (previouslySeen) break block5;
                                if (!(scc instanceof ListSchemaCreationBlueprint)) break block6;
                                ListSchemaCreationBlueprint listScb = (ListSchemaCreationBlueprint)scc;
                                SchemaGenerator.calculateClassFrequency(listScb.itemType(), direction, ctx);
                                break block5;
                            }
                            if (!(scc instanceof ClassSchemaCreationBlueprint)) break block7;
                            ClassSchemaCreationBlueprint classScb = (ClassSchemaCreationBlueprint)scc;
                            List<SchemaCreationBlueprintGenerator.FieldInfo> fields = direction == SchemaDirection.INPUT ? classScb.inputFields() : classScb.outputFields();
                            for (SchemaCreationBlueprintGenerator.FieldInfo fi : fields) {
                                SchemaGenerator.calculateClassFrequency(fi.type(), direction, ctx);
                            }
                            break block5;
                        }
                        if (!(scc instanceof MapSchemaCreationBlueprint)) break block8;
                        MapSchemaCreationBlueprint mapScb = (MapSchemaCreationBlueprint)scc;
                        SchemaGenerator.calculateClassFrequency(mapScb.valueType(), direction, ctx);
                        SchemaGenerator.calculateClassFrequency(mapScb.keyType(), direction, ctx);
                        break block5;
                    }
                    if (!(scc instanceof OptionalSchemaCreationBlueprint)) break block9;
                    OptionalSchemaCreationBlueprint optionalScb = (OptionalSchemaCreationBlueprint)scc;
                    SchemaGenerator.calculateClassFrequency(optionalScb.optionalType(), direction, ctx);
                    break block5;
                }
                if (!(scc instanceof TypeVariableSchemaCreationBlueprint)) break block10;
                TypeVariableSchemaCreationBlueprint tvScb = (TypeVariableSchemaCreationBlueprint)scc;
                for (Type bound : tvScb.tv().getBounds()) {
                    SchemaGenerator.calculateClassFrequency(bound, direction, ctx);
                }
                break block5;
            }
            if (!(scc instanceof WildcardSchemaCreationBlueprint)) break block5;
            WildcardSchemaCreationBlueprint wtScb = (WildcardSchemaCreationBlueprint)scc;
            for (Type bound : wtScb.upperBounds()) {
                SchemaGenerator.calculateClassFrequency(bound, direction, ctx);
            }
            for (Type bound : wtScb.lowerBounds()) {
                SchemaGenerator.calculateClassFrequency(bound, direction, ctx);
            }
        }
    }

    public static JsonObjectBuilder generateSubSchema(Type type, SchemaGenerationContext ctx, SchemaAnnotation annotation) {
        Optional<JsonObjectBuilder> schemaFromAnnotation = annotation.asJsonSchema();
        if (schemaFromAnnotation.isPresent()) {
            return schemaFromAnnotation.get();
        }
        SchemaCreationBlueprint blueprint = ctx.getBlueprintRegistry().getSchemaCreationBlueprint(type);
        String description = annotation.description().orElse(null);
        JsonObject defsSchema = ctx.getDefsBuilder().get(type);
        if (defsSchema != null) {
            return SchemaGenerator.createReference(ctx.getName(type), description, defsSchema);
        }
        if (blueprint.getDefsName().isPresent() && ctx.isMultiUse(type)) {
            ctx.getDefsBuilder().put(type, GENERATION_IN_PROGRESS);
            JsonObject result = blueprint.toJsonSchemaObject(ctx, null).build();
            ctx.getDefsBuilder().put(type, result);
            return SchemaGenerator.createReference(ctx.getName(type), description, result);
        }
        return blueprint.toJsonSchemaObject(ctx, description);
    }

    private static JsonObjectBuilder createReference(String name, String referenceDescription, JsonObject referencedSchema) {
        String schemaDescription = referencedSchema.getString("description", null);
        JsonObjectBuilder ref = Json.createObjectBuilder().add("$ref", "#/$defs/" + name);
        if (referenceDescription != null && !referenceDescription.equals(schemaDescription)) {
            ref.add("description", referenceDescription);
        }
        return ref;
    }

    private static void addDefs(JsonObjectBuilder result, SchemaGenerationContext ctx) {
        if (ctx.getDefsBuilder().isEmpty()) {
            return;
        }
        JsonObjectBuilder defs = Json.createObjectBuilder();
        ctx.getDefsBuilder().forEach((type, schema) -> defs.add(ctx.getName((Type)type), (JsonValue)schema));
        result.add("$defs", defs);
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaGenerator", SchemaGenerator.class, (String)"MCP", null);
        GENERATION_IN_PROGRESS = Json.createObjectBuilder().build();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class SchemaGenerationContext {
        private HashMap<Type, Boolean> typeMultiUse = new HashMap();
        private HashMap<Type, String> nameMap = new HashMap();
        private Set<String> namesInUse = new HashSet<String>();
        private HashMap<Type, JsonObject> defsBuilder = new HashMap();
        private SchemaCreationBlueprintRegistry blueprintRegistry;
        private SchemaDirection direction;
        static final long serialVersionUID = -2115543114169403295L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public SchemaGenerationContext(SchemaCreationBlueprintRegistry blueprintRegistry, SchemaDirection direction) {
            Objects.requireNonNull(blueprintRegistry, "blueprintRegistry");
            Objects.requireNonNull(direction, "direction");
            this.blueprintRegistry = blueprintRegistry;
            this.direction = direction;
        }

        public boolean registerSeen(Type type) {
            return this.typeMultiUse.compute(type, (k, v) -> v != null);
        }

        public boolean isMultiUse(Type type) {
            return this.typeMultiUse.getOrDefault(type, false);
        }

        public void reserveName(Type type, String baseName) {
            Object name = this.nameMap.get(type);
            if (name == null) {
                int suffix = 1;
                name = baseName;
                while (this.namesInUse.contains(name)) {
                    name = baseName + ++suffix;
                }
                this.nameMap.put(type, (String)name);
                this.namesInUse.add((String)name);
            }
        }

        public String getName(Type type) {
            return this.nameMap.get(type);
        }

        public SchemaDirection getDirection() {
            return this.direction;
        }

        public HashMap<Type, JsonObject> getDefsBuilder() {
            return this.defsBuilder;
        }

        public SchemaCreationBlueprintRegistry getBlueprintRegistry() {
            return this.blueprintRegistry;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.schemas.SchemaGenerator$SchemaGenerationContext", SchemaGenerationContext.class, (String)"MCP", null);
        }
    }
}

