/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.mcp.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.service.util.ServiceCaller;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.mcp.internal.McpConnectionTracker;
import io.openliberty.mcp.internal.McpSession;
import io.openliberty.mcp.internal.config.McpConfiguration;
import io.openliberty.mcp.internal.requests.ExecutionRequestId;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.inject.Inject;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

@ApplicationScoped
@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class McpSessionStore {
    private static final Duration SESSION_TIMEOUT;
    private final ConcurrentMap<String, McpSession> sessions = new ConcurrentHashMap<String, McpSession>();
    private static final ServiceCaller<McpConfiguration> mcpConfigService;
    @Inject
    McpConnectionTracker connectionTracker;
    static final long serialVersionUID = -1460646295405065443L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public boolean isStateless() {
        return mcpConfigService.run(McpConfiguration::isStateless).orElse(false);
    }

    public String createSession() {
        if (this.isStateless()) {
            return null;
        }
        String sessionId = UUID.randomUUID().toString();
        this.sessions.put(sessionId, new McpSession(sessionId));
        return sessionId;
    }

    public McpSession getSession(String sessionId) {
        McpSession session = (McpSession)this.sessions.get(sessionId);
        if (session != null) {
            session.touch();
            return session;
        }
        return null;
    }

    public boolean isValid(String sessionId) {
        this.cleanupOldSessions();
        return sessionId != null && this.sessions.containsKey(sessionId);
    }

    public void deleteSession(String sessionId) {
        McpSession session = (McpSession)this.sessions.remove(sessionId);
        if (session != null) {
            this.connectionTracker.cancelSessionRequests(session);
        }
    }

    public void cleanupOldSessions() {
        Instant now = Instant.now();
        this.sessions.entrySet().removeIf(entry -> Duration.between(((McpSession)entry.getValue()).getLastAccessed(), now).compareTo(SESSION_TIMEOUT) > 0);
    }

    public boolean cancelRequest(String sessionId, ExecutionRequestId requestId) {
        McpSession session = this.getSession(sessionId);
        if (session != null && session.isRequestActive(requestId)) {
            session.removeRequest(requestId);
            return true;
        }
        return false;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.mcp.internal.McpSessionStore", McpSessionStore.class, (String)"MCP", (String)"io.openliberty.mcp.internal.resources.CWMCM");
        SESSION_TIMEOUT = Duration.ofMinutes(10L);
        mcpConfigService = new ServiceCaller(McpSessionStore.class, McpConfiguration.class);
    }
}

