/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class JSONUtil {
    private static final TraceComponent tc = Tr.register(JSONUtil.class);

    public static StringBuilder getJSON(Object obj) {
        StringBuilder sb = new StringBuilder();
        if (obj == null) {
            sb.append("null");
        } else if (obj instanceof String || obj instanceof StringBuilder || obj instanceof StringBuffer) {
            String str = obj.toString();
            sb.append("\"").append((CharSequence)JSONUtil.formatString(str)).append("\"");
        } else {
            sb.append(obj);
        }
        return sb;
    }

    public static StringBuilder getJSON(Object[] array) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (Object str : array) {
            if (str instanceof Map) {
                Map map = (Map)str;
                sb.append((CharSequence)JSONUtil.getJSON(map)).append(",");
                continue;
            }
            sb.append((CharSequence)JSONUtil.getJSON(str)).append(",");
        }
        if (array.length > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb;
    }

    public static StringBuilder getJSON(Map<String, Object> map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            sb.append((CharSequence)JSONUtil.getJSON(entry.getKey())).append(":");
            Object value = entry.getValue();
            Object[] array = null;
            if (value instanceof Map) {
                Map m = (Map)value;
                sb.append((CharSequence)JSONUtil.getJSON(m));
            } else if (value instanceof Object[]) {
                array = (Object[])value;
                sb.append((CharSequence)JSONUtil.getJSON(array));
            } else {
                sb.append((CharSequence)JSONUtil.getJSON(value));
            }
            sb.append(",");
        }
        if (map.keySet().size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        return sb;
    }

    private static StringBuilder formatString(String str) {
        StringBuilder sb = new StringBuilder();
        block10: for (int i = 0; i < str.length(); ++i) {
            char ch = str.charAt(i);
            switch (ch) {
                case '\"': {
                    sb.append("\\\"");
                    continue block10;
                }
                case '\\': {
                    sb.append("\\\\");
                    continue block10;
                }
                case '/': {
                    sb.append("\\/");
                    continue block10;
                }
                case '\b': {
                    sb.append("\\b");
                    continue block10;
                }
                case '\f': {
                    sb.append("\\f");
                    continue block10;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block10;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block10;
                }
                case '\t': {
                    sb.append("\\t");
                    continue block10;
                }
                default: {
                    if ((ch & 0xFF00) == 0) {
                        sb.append(ch);
                        continue block10;
                    }
                    sb.append("\\u");
                    String hex = Integer.toHexString(Character.codePointAt(str, i));
                    int zerosNeeded = 4 - hex.length();
                    for (int j = 0; j < zerosNeeded; ++j) {
                        sb.append('0');
                    }
                    sb.append(hex);
                }
            }
        }
        return sb;
    }

    public static StringBuilder getJSONStrings(Map<String, String[]> map) {
        if (map == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        for (Map.Entry<String, String[]> entry : map.entrySet()) {
            sb.append((CharSequence)JSONUtil.getJSON(entry.getKey())).append(":");
            String[] values = entry.getValue();
            sb.append("[");
            for (String value : values) {
                sb.append((CharSequence)JSONUtil.getJSON(value)).append(",");
            }
            if (values.length > 0) {
                sb.deleteCharAt(sb.length() - 1);
            }
            sb.append("]");
            sb.append(",");
        }
        if (map.keySet().size() > 0) {
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("}");
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JsonString:" + sb), (Object[])new Object[0]);
        }
        return sb;
    }

    public static Map<String, String[]> parseJSONToMap(String jsonString) throws JsonSyntaxException {
        if (jsonString == null || jsonString.length() == 0) {
            return new HashMap<String, String[]>();
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(jsonString).getAsJsonObject();
        return JSONUtil.jsonObjectToStringsMap(jsonObject);
    }

    public static Map<String, String[]> jsonObjectToStringsMap(JsonObject jsonObject) {
        if (jsonObject == null || jsonObject.isJsonNull()) {
            return null;
        }
        HashMap<String, String[]> mapJson = new HashMap<String, String[]>();
        Set entries = jsonObject.entrySet();
        for (Map.Entry entry : entries) {
            String key = (String)entry.getKey();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("mapKey:" + key), (Object[])new Object[0]);
            }
            JsonArray jsonArray = ((JsonElement)entry.getValue()).getAsJsonArray();
            int iSize = jsonArray.size();
            String[] values = new String[iSize];
            for (int iI = 0; iI < iSize; ++iI) {
                values[iI] = jsonArray.get(iI).getAsString();
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("mapKey:" + key + " value(" + iI + "):" + values[iI]), (Object[])new Object[0]);
            }
            mapJson.put(key, values);
        }
        return mapJson;
    }

    public static JsonObject getJsonObject(Map<String, String[]> extensionProperties) {
        if (extensionProperties == null || extensionProperties.size() == 0) {
            return null;
        }
        StringBuilder jsonBuilder = JSONUtil.getJSONStrings(extensionProperties);
        if (jsonBuilder == null) {
            return null;
        }
        JsonParser parser = new JsonParser();
        JsonObject jsonObject = parser.parse(jsonBuilder.toString()).getAsJsonObject();
        return jsonObject;
    }
}

