/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.oauth.core.internal.oauth20.config;

import com.ibm.oauth.core.api.audit.OAuthAuditHandler;
import com.ibm.oauth.core.api.config.OAuthComponentConfiguration;
import com.ibm.oauth.core.api.error.OAuthConfigurationException;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.oauth20.mediator.OAuth20Mediator;
import com.ibm.oauth.core.api.oauth20.token.OAuth20TokenCache;
import com.ibm.oauth.core.internal.config.OAuthConfigurationImpl;
import com.ibm.oauth.core.internal.oauth20.OAuth20ComponentImpl;
import com.ibm.oauth.core.internal.oauth20.OAuth20Constants;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigProvider;
import com.ibm.oauth.core.internal.oauth20.config.OAuth20ConfigValidator;
import com.ibm.oauth.core.internal.oauth20.granttype.OAuth20GrantTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.mediator.OAuth20MediatorWrapper;
import com.ibm.oauth.core.internal.oauth20.mediator.impl.OAuth20MediatorDefaultImpl;
import com.ibm.oauth.core.internal.oauth20.mediator.impl.OAuthAuditHandlerMediator;
import com.ibm.oauth.core.internal.oauth20.responsetype.OAuth20ResponseTypeHandlerFactory;
import com.ibm.oauth.core.internal.oauth20.token.OAuth20TokenCacheWrapper;
import com.ibm.oauth.core.internal.oauth20.tokentype.OAuth20TokenTypeHandler;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.plugins.OidcOAuth20ClientProviderWrapper;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OAuth20ConfigurationImpl
extends OAuthConfigurationImpl
implements OAuth20ConfigValidator,
OAuth20ConfigProvider {
    static final String CLASS = OAuth20ConfigurationImpl.class.getName();
    static final Logger _log = Logger.getLogger(CLASS);
    public static final String OAUTH20_ID_TOKENTYPEHANDLER_CLASSNAME = "oauth20.id.tokentypehandler.classname";
    public static final String OAUTH20_GRANT_TYPE_HANDLER_FACTORY_CLASSNAME = "oauth20.grant.type.handler.factory.classname";
    public static final String OAUTH20_RESPONSE_TYPE_HANDLER_FACTORY_CLASSNAME = "oauth20.response.type.handler.factory.classname";
    protected OAuth20ComponentImpl _compimpl;
    protected boolean _validated;
    protected OidcOAuth20ClientProvider _clientProvider;
    protected OAuth20TokenCache _tokenCache;
    protected int _maxAuthGrantLifetimeSeconds;
    protected int _codeLifetimeSeconds;
    protected int _codeLength;
    protected int _tokenLifetimeSeconds;
    protected int _accessTokenLength;
    protected boolean _issueRefreshToken;
    protected int _refreshTokenLength;
    protected long _refreshedAccessTokenLimit = 100L;
    protected OAuth20TokenTypeHandler _tokenTypeHandler;
    protected OAuth20TokenTypeHandler _idTokenTypeHandler;
    protected OAuth20GrantTypeHandlerFactory _grantTypeHandlerFactory;
    protected OAuth20ResponseTypeHandlerFactory _responseTypeHandlerFactory;
    protected OAuth20Mediator _mediators;
    protected boolean _allowPublicClients;
    protected HashSet<String> _allowedGrantTypes;
    protected OAuthAuditHandler _auditHandler;

    public OAuth20ConfigurationImpl(OAuth20ComponentImpl compIn, OAuthComponentConfiguration configIn) {
        super(configIn);
        this._compimpl = compIn;
        this._validated = false;
    }

    @Override
    public OAuth20ConfigProvider getConfigProvider() throws OAuthException {
        if (!this._validated) {
            this.validate();
        }
        return this;
    }

    @Override
    public void validate() throws OAuthException {
        this.processClientProvider();
        this.processTokenCache();
        this.processTokenTypeHandler();
        this.processIDTokenTypeHandler();
        this.processGrantTypeHandlerFactory();
        this.processResponseTypeHandlerFactory();
        this.processAuditHandler();
        this.processMediators();
        this.processGrantTypes();
        this._maxAuthGrantLifetimeSeconds = this.validateNonNegativeInt("oauth20.max.authorization.grant.lifetime.seconds");
        this._codeLifetimeSeconds = this.validateNonNegativeInt("oauth20.code.lifetime.seconds");
        this._codeLength = this.validateNonNegativeInt("oauth20.code.length");
        this._tokenLifetimeSeconds = this.validateNonNegativeInt("oauth20.token.lifetime.seconds");
        this._accessTokenLength = this.validateNonNegativeInt("oauth20.access.token.length");
        this._refreshTokenLength = this.validateNonNegativeInt("oauth20.refresh.token.length");
        this._issueRefreshToken = this.validateBoolean("oauth20.issue.refresh.token");
        this._allowPublicClients = this.validateBoolean("oauth20.allow.public.clients");
        this._compimpl = null;
        this._oldconfig = null;
        this._validated = true;
    }

    protected void processClientProvider() throws OAuthException {
        String className = this._oldconfig.getConfigPropertyValue("oauth20.client.provider.classname");
        Object newClass = this.processClass(className, "oauth20.client.provider.classname", OidcOAuth20ClientProvider.class);
        OidcOAuth20ClientProvider realClientProvider = (OidcOAuth20ClientProvider)newClass;
        OidcOAuth20ClientProviderWrapper clientProviderWrapper = new OidcOAuth20ClientProviderWrapper(realClientProvider, this._compimpl.getOAuthStatisticsImpl());
        clientProviderWrapper.init(this._oldconfig);
        this._clientProvider = clientProviderWrapper;
    }

    protected void processTokenCache() throws OAuthException {
        String className = this._oldconfig.getConfigPropertyValue("oauth20.token.cache.classname");
        Object newClass = this.processClass(className, "oauth20.token.cache.classname", OAuth20TokenCache.class);
        OAuth20TokenCache realTokenCache = (OAuth20TokenCache)newClass;
        OAuth20TokenCacheWrapper tokenCacheWrapper = new OAuth20TokenCacheWrapper(realTokenCache, this._compimpl.getOAuthStatisticsImpl());
        tokenCacheWrapper.init(this._oldconfig);
        this._tokenCache = tokenCacheWrapper;
    }

    protected void processTokenTypeHandler() throws OAuthException {
        String className = this._oldconfig.getConfigPropertyValue("oauth20.access.tokentypehandler.classname");
        Object newClass = this.processClass(className, "oauth20.access.tokentypehandler.classname", OAuth20TokenTypeHandler.class);
        this._tokenTypeHandler = (OAuth20TokenTypeHandler)newClass;
        this._tokenTypeHandler.init(this._oldconfig);
    }

    protected void processIDTokenTypeHandler() throws OAuthException {
        block4: {
            String className = this._oldconfig.getConfigPropertyValue(OAUTH20_ID_TOKENTYPEHANDLER_CLASSNAME);
            if (_log.isLoggable(Level.FINEST)) {
                _log.logp(Level.FINEST, CLASS, "processIDTokenTypeHandler", className);
            }
            if (className != null) {
                try {
                    Object newClass = this.processClass(className, OAUTH20_ID_TOKENTYPEHANDLER_CLASSNAME, OAuth20TokenTypeHandler.class);
                    this._idTokenTypeHandler = (OAuth20TokenTypeHandler)newClass;
                    this._idTokenTypeHandler.init(this._oldconfig);
                }
                catch (OAuthException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) break block4;
                    throw e;
                }
            }
        }
    }

    protected void processGrantTypeHandlerFactory() throws OAuthException {
        block4: {
            String className = this._oldconfig.getConfigPropertyValue(OAUTH20_GRANT_TYPE_HANDLER_FACTORY_CLASSNAME);
            if (_log.isLoggable(Level.FINEST)) {
                _log.logp(Level.FINEST, CLASS, "processGrantTypeHandlerFactory", className);
            }
            if (className != null) {
                try {
                    Object newClass = this.processClass(className, OAUTH20_GRANT_TYPE_HANDLER_FACTORY_CLASSNAME, OAuth20GrantTypeHandlerFactory.class);
                    this._grantTypeHandlerFactory = (OAuth20GrantTypeHandlerFactory)newClass;
                }
                catch (OAuthException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) break block4;
                    throw e;
                }
            }
        }
    }

    protected void processResponseTypeHandlerFactory() throws OAuthException {
        block4: {
            String className = this._oldconfig.getConfigPropertyValue(OAUTH20_RESPONSE_TYPE_HANDLER_FACTORY_CLASSNAME);
            if (_log.isLoggable(Level.FINEST)) {
                _log.logp(Level.FINEST, CLASS, "processResponseTypeHandlerFactory", className);
            }
            if (className != null) {
                try {
                    Object newClass = this.processClass(className, OAUTH20_RESPONSE_TYPE_HANDLER_FACTORY_CLASSNAME, OAuth20ResponseTypeHandlerFactory.class);
                    this._responseTypeHandlerFactory = (OAuth20ResponseTypeHandlerFactory)newClass;
                    this._responseTypeHandlerFactory.init(this._oldconfig);
                }
                catch (OAuthException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof ClassNotFoundException) break block4;
                    throw e;
                }
            }
        }
    }

    protected void processMediators() throws OAuthException {
        ArrayList<OAuth20Mediator> mediatorList = new ArrayList<OAuth20Mediator>();
        String[] mediatorClassNames = this._oldconfig.getConfigPropertyValues("oauth20.mediator.classnames");
        if (mediatorClassNames == null || mediatorClassNames.length == 0) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.logp(Level.FINEST, CLASS, "processMediators", "No mediator in configuration - using default mediator");
            }
            mediatorClassNames = new String[]{OAuth20MediatorDefaultImpl.class.getName()};
        }
        for (String mediatorClassName : mediatorClassNames) {
            Object newClass = this.processClass(mediatorClassName, "oauth20.mediator.classnames", OAuth20Mediator.class);
            mediatorList.add((OAuth20Mediator)newClass);
        }
        if (this._auditHandler != null) {
            if (_log.isLoggable(Level.FINEST)) {
                _log.logp(Level.FINEST, CLASS, "processMediators", "Audit handler defined and instantiated, adding OAuthAuditHandlerMediator to mediator chain");
            }
            OAuthAuditHandlerMediator auditMediator = new OAuthAuditHandlerMediator(this._auditHandler);
            mediatorList.add(auditMediator);
        }
        this._mediators = new OAuth20MediatorWrapper(mediatorList, this._compimpl.getStatisticsImpl());
        this._mediators.init(this._oldconfig);
    }

    protected void processGrantTypes() throws OAuthException {
        String[] allowedGrantTypeNames = this._oldconfig.getConfigPropertyValues("oauth20.grant.types.allowed");
        if (allowedGrantTypeNames == null || allowedGrantTypeNames.length == 0) {
            throw new OAuthConfigurationException("security.oauth.error.config.notspecified.exception", "oauth20.grant.types.allowed", "", null);
        }
        this._allowedGrantTypes = new HashSet();
        for (String name : allowedGrantTypeNames) {
            if (!OAuth20Constants.ALL_GRANT_TYPES_SET.contains(name)) {
                throw new OAuthConfigurationException("security.oauth.error.invalidconfig.exception", "oauth20.grant.types.allowed", name, null);
            }
            this._allowedGrantTypes.add(name);
        }
    }

    protected void processAuditHandler() throws OAuthException {
        Object instance = null;
        String auditHandlerClassName = this._oldconfig.getConfigPropertyValue("oauth20.audithandler.classname");
        if (_log.isLoggable(Level.FINEST)) {
            _log.logp(Level.FINEST, CLASS, "processAuditHandler", "Audit handler class name: " + auditHandlerClassName);
        }
        instance = auditHandlerClassName == null ? null : this.processClass(auditHandlerClassName, "oauth20.audithandler.classname", OAuthAuditHandler.class);
        this._auditHandler = (OAuthAuditHandler)instance;
        if (_log.isLoggable(Level.FINEST)) {
            _log.logp(Level.FINEST, CLASS, "processAuditHandler", "Instantiated audit handler : " + this._auditHandler);
        }
    }

    @Override
    public int getAccessTokenLength() {
        return this._accessTokenLength;
    }

    @Override
    public OidcOAuth20ClientProvider getClientProvider() {
        return this._clientProvider;
    }

    @Override
    public int getCodeLength() {
        return this._codeLength;
    }

    @Override
    public int getCodeLifetimeSeconds() {
        return this._codeLifetimeSeconds;
    }

    @Override
    public int getMaxAuthGrantLifetimeSeconds() {
        return this._maxAuthGrantLifetimeSeconds;
    }

    @Override
    public OAuth20Mediator getMediators() {
        return this._mediators;
    }

    @Override
    public int getRefreshTokenLength() {
        return this._refreshTokenLength;
    }

    @Override
    public long getRefreshedAccessTokenLimit() {
        return this._refreshedAccessTokenLimit;
    }

    @Override
    public OAuth20TokenCache getTokenCache() {
        return this._tokenCache;
    }

    @Override
    public int getTokenLifetimeSeconds() {
        return this._tokenLifetimeSeconds;
    }

    @Override
    public OAuth20TokenTypeHandler getTokenTypeHandler() {
        return this._tokenTypeHandler;
    }

    @Override
    public OAuth20TokenTypeHandler getIDTokenTypeHandler() {
        return this._idTokenTypeHandler;
    }

    @Override
    public OAuth20GrantTypeHandlerFactory getGrantTypeHandlerFactory() {
        return this._grantTypeHandlerFactory;
    }

    @Override
    public OAuth20ResponseTypeHandlerFactory getResponseTypeHandlerFactory() {
        return this._responseTypeHandlerFactory;
    }

    @Override
    public boolean isAllowPublicClients() {
        return this._allowPublicClients;
    }

    @Override
    public boolean isIssueRefreshToken() {
        return this._issueRefreshToken;
    }

    @Override
    public boolean isGrantTypeAllowed(String grantType) {
        return this._allowedGrantTypes.contains(grantType);
    }

    @Override
    public OAuthAuditHandler getAuditHandler() {
        return this._auditHandler;
    }
}

