/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.MarshalException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.bind.UnmarshalException;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessOrder;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorOrder;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.HexBinaryAdapter;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.bind.attachment.AttachmentUnmarshaller;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.stream.util.StreamReaderDelegate;
import javax.xml.transform.stream.StreamResult;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.JAXBSchemaInitializer;
import org.apache.cxf.jaxb.MarshallerAwareXMLWriter;
import org.apache.cxf.jaxb.UnmarshallerAwareXMLReader;
import org.apache.cxf.jaxb.Utils;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.SchemaInfo;
import org.apache.cxf.staxutils.DepthXMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.staxutils.W3CNamespaceContext;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.w3c.dom.Attr;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
public final class JAXBEncoderDecoder {
    private static final Logger LOG = LogUtils.getLogger(JAXBEncoderDecoder.class);
    static final long serialVersionUID = 9018316340505274613L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private JAXBEncoderDecoder() {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "<init>", new Object[0]);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "<init>", this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void marshall(Marshaller marshaller, Object elValue, MessagePartInfo part, Object source) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshall", new Object[]{marshaller, elValue, part, source});
        }
        try {
            marshaller.setProperty("jaxb.fragment", (Object)true);
            marshaller.setProperty("jaxb.formatted.output", (Object)false);
        }
        catch (PropertyException propertyException) {
            // empty catch block
        }
        Class<?> cls = null;
        if (part != null) {
            cls = part.getTypeClass();
        }
        if (cls == null) {
            Class<?> clazz = cls = null != elValue ? elValue.getClass() : null;
        }
        if (cls != null && cls.isArray() && elValue instanceof Collection) {
            Collection col = (Collection)elValue;
            elValue = col.toArray((Object[])Array.newInstance(cls.getComponentType(), col.size()));
        }
        try {
            Object mObj = elValue;
            QName elName = null;
            if (part != null) {
                elName = part.getConcreteName();
            }
            if (null != elName) {
                if (part != null && part.getXmlSchema() instanceof XmlSchemaElement) {
                    XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
                    if (mObj.getClass().isArray() && el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                        mObj = Arrays.asList(mObj);
                        JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(elName, cls, mObj));
                    } else if (part.getMessageInfo().getOperation().isUnwrapped() && (mObj.getClass().isArray() || mObj instanceof List) && el.getMaxOccurs() != 1L) {
                        JAXBEncoderDecoder.writeArrayObject(marshaller, source, elName, mObj);
                    } else {
                        JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(elName, cls, mObj));
                    }
                } else if (byte[].class == cls && part.getTypeQName() != null && "hexBinary".equals(part.getTypeQName().getLocalPart())) {
                    mObj = new HexBinaryAdapter().marshal((byte[])mObj);
                    JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(elName, String.class, mObj));
                } else if (mObj instanceof JAXBElement) {
                    JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
                } else if (marshaller.getSchema() != null) {
                    JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(elName, Object.class, mObj));
                } else {
                    JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(elName, cls, mObj));
                }
            } else {
                JAXBEncoderDecoder.writeObject(marshaller, source, mObj);
            }
        }
        catch (Fault ex) {
            throw ex;
        }
        catch (MarshalException ex) {
            Message faultMessage = new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()});
            throw new Fault(faultMessage, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshall");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static JAXBElement<?> newJAXBElement(QName elName, Class<?> cls, Object mObj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "newJAXBElement", new Object[]{elName, cls, mObj});
        }
        if (mObj instanceof JAXBElement) {
            JAXBElement jAXBElement = (JAXBElement)mObj;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                jAXBElement = jAXBElement;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "newJAXBElement", jAXBElement);
            }
            return jAXBElement;
        }
        if (cls == null && mObj != null) {
            cls = mObj.getClass();
        }
        JAXBElement jAXBElement = new JAXBElement(elName, cls, mObj);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            jAXBElement = jAXBElement;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "newJAXBElement", jAXBElement);
        }
        return jAXBElement;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void marshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object elValue, Object source, AttachmentMarshaller am) {
        block8: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshalWithBridge", new Object[]{qname, cls, anns, ctxClasses, elValue, source, am});
            }
            try {
                JAXBUtils.BridgeWrapper bridge = JAXBUtils.createBridge(ctxClasses, (QName)qname, cls, (Annotation[])anns);
                if (source instanceof XMLStreamWriter) {
                    bridge.marshal(elValue, (XMLStreamWriter)source, am);
                    break block8;
                }
                if (source instanceof OutputStream) {
                    StringWriter sw = new StringWriter();
                    StreamResult s1 = new StreamResult(sw);
                    bridge.marshal(elValue, s1);
                    ((OutputStream)source).write(sw.toString().getBytes());
                    break block8;
                }
                if (source instanceof Node) {
                    bridge.marshal(elValue, (Node)source, am);
                    break block8;
                }
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
            }
            catch (MarshalException ex) {
                Message faultMessage = new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()});
                throw new Fault(faultMessage, (Throwable)ex);
            }
            catch (Exception ex) {
                throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshalWithBridge");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object unmarshalWithBridge(QName qname, Class<?> cls, Annotation[] anns, Set<Class<?>> ctxClasses, Object source, AttachmentUnmarshaller am) {
        block12: {
            Object object;
            block13: {
                JAXBUtils.BridgeWrapper bridge;
                block10: {
                    Object object2;
                    block11: {
                        block8: {
                            Object object3;
                            block9: {
                                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                                    LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshalWithBridge", new Object[]{qname, cls, anns, ctxClasses, source, am});
                                }
                                bridge = JAXBUtils.createBridge(ctxClasses, (QName)qname, cls, (Annotation[])anns);
                                if (LOG.isLoggable(Level.FINEST)) {
                                    LOG.finest("unmarshalWithBridge: bridge class: " + (bridge != null ? bridge.getClass().getCanonicalName() : "null"));
                                }
                                if (!(source instanceof XMLStreamReader)) break block8;
                                object3 = bridge.unmarshal((XMLStreamReader)source, am);
                                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                                object3 = object3;
                                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshalWithBridge", object3);
                            }
                            return object3;
                        }
                        if (!(source instanceof InputStream)) break block10;
                        object2 = bridge.unmarshal((InputStream)source);
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block11;
                        object2 = object2;
                        LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshalWithBridge", object2);
                    }
                    return object2;
                }
                if (!(source instanceof Node)) break block12;
                object = bridge.unmarshal((Node)source, am);
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block13;
                object = object;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshalWithBridge", object);
            }
            return object;
        }
        try {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
        }
        catch (MarshalException ex) {
            Message faultMessage = new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()});
            throw new Fault(faultMessage, (Throwable)ex);
        }
        catch (Exception ex) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void marshallException(Marshaller marshaller, Exception elValue, MessagePartInfo part, Object source) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshallException", new Object[]{marshaller, elValue, part, source});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        XMLStreamWriter writer = JAXBEncoderDecoder.getStreamWriter(source);
        QName qn = part.getElementQName();
        try {
            XmlType xmlType;
            Object o;
            String namespace;
            writer.writeStartElement("ns1", qn.getLocalPart(), qn.getNamespaceURI());
            Class cls = part.getTypeClass();
            XmlAccessType accessType = Utils.getXmlAccessType(cls);
            String attNs = namespace = part.getElementQName().getNamespaceURI();
            SchemaInfo sch = part.getMessageInfo().getOperation().getInterface().getService().getSchema(namespace);
            if (sch == null) {
                LOG.warning("Schema associated with " + namespace + " is null");
                namespace = null;
                attNs = null;
            } else {
                if (!sch.isElementFormQualified()) {
                    namespace = null;
                }
                if (!sch.isAttributeFormQualified()) {
                    attNs = null;
                }
            }
            ArrayList<AccessibleObject> combinedMembers = new ArrayList<AccessibleObject>();
            for (Field f : Utils.getFields(cls, accessType)) {
                XmlAttribute at = f.getAnnotation(XmlAttribute.class);
                if (at == null) {
                    combinedMembers.add(f);
                    continue;
                }
                QName fname = new QName(attNs, StringUtils.isEmpty((String)at.name()) ? f.getName() : at.name());
                ReflectionUtil.setAccessible((AccessibleObject)f);
                Object object = Utils.getFieldValue(f, elValue);
                DocumentFragment frag = DOMUtils.getEmptyDocument().createDocumentFragment();
                JAXBEncoderDecoder.writeObject(marshaller, frag, JAXBEncoderDecoder.newJAXBElement(fname, String.class, object));
                if (attNs != null) {
                    writer.writeAttribute(attNs, fname.getLocalPart(), DOMUtils.getAllContent((Node)frag));
                    continue;
                }
                writer.writeAttribute(fname.getLocalPart(), DOMUtils.getAllContent((Node)frag));
            }
            for (Method m : Utils.getGetters(cls, accessType)) {
                if (!m.isAnnotationPresent(XmlAttribute.class)) {
                    combinedMembers.add(m);
                    continue;
                }
                int idx = m.getName().startsWith("get") ? 3 : 2;
                String name = m.getName().substring(idx);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                XmlAttribute xmlAttribute = m.getAnnotation(XmlAttribute.class);
                QName mname = new QName(namespace, StringUtils.isEmpty((String)xmlAttribute.name()) ? name : xmlAttribute.name());
                DocumentFragment frag = DOMUtils.getEmptyDocument().createDocumentFragment();
                o = Utils.getMethodValue(m, elValue);
                JAXBEncoderDecoder.writeObject(marshaller, frag, JAXBEncoderDecoder.newJAXBElement(mname, String.class, o));
                if (attNs != null) {
                    writer.writeAttribute(attNs, mname.getLocalPart(), DOMUtils.getAllContent((Node)frag));
                    continue;
                }
                writer.writeAttribute(mname.getLocalPart(), DOMUtils.getAllContent((Node)frag));
            }
            XmlAccessorOrder xmlAccessorOrder = cls.getAnnotation(XmlAccessorOrder.class);
            if (xmlAccessorOrder != null && xmlAccessorOrder.value().equals((Object)XmlAccessOrder.ALPHABETICAL)) {
                Collections.sort(combinedMembers, new Comparator<Member>(){
                    static final long serialVersionUID = -1668378068551291546L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public int compare(Member m1, Member m2) {
                        return m1.getName().compareTo(m2.getName());
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBEncoderDecoder$1", 1.class, null, null);
                    }
                });
            }
            if ((xmlType = cls.getAnnotation(XmlType.class)) != null && xmlType.propOrder().length > 1 && !xmlType.propOrder()[0].isEmpty()) {
                final List<String> orderList = Arrays.asList(xmlType.propOrder());
                Collections.sort(combinedMembers, new Comparator<Member>(){
                    static final long serialVersionUID = -3991139418400418022L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public int compare(Member m1, Member m2) {
                        String m1Name = JAXBEncoderDecoder.getName(m1);
                        String m2Name = JAXBEncoderDecoder.getName(m2);
                        int m1Index = orderList.indexOf(m1Name);
                        int m2Index = orderList.indexOf(m2Name);
                        if (m1Index != -1 && m2Index != -1) {
                            return m1Index - m2Index;
                        }
                        if (m1Index == -1 && m2Index != -1) {
                            return 1;
                        }
                        if (m1Index != -1 && m2Index == -1) {
                            return -1;
                        }
                        return 0;
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBEncoderDecoder$2", 2.class, null, null);
                    }
                });
            }
            Object hasGetMessage = null;
            for (Member member : combinedMembers) {
                if (member instanceof Field) {
                    Field f = (Field)member;
                    QName fname = new QName(namespace, f.getName());
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    if (JAXBSchemaInitializer.isArray(f.getGenericType())) {
                        JAXBEncoderDecoder.writeArrayObject(marshaller, writer, fname, f.get(elValue));
                        continue;
                    }
                    o = Utils.getFieldValue(f, elValue);
                    JAXBEncoderDecoder.writeObject(marshaller, writer, JAXBEncoderDecoder.newJAXBElement(fname, String.class, o));
                    continue;
                }
                Method m = (Method)member;
                int idx = m.getName().startsWith("get") ? 3 : 2;
                String name = m.getName().substring(idx);
                name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
                QName mname = new QName(namespace, name);
                if (JAXBSchemaInitializer.isArray(m.getGenericReturnType())) {
                    JAXBEncoderDecoder.writeArrayObject(marshaller, writer, mname, m.invoke((Object)elValue, new Object[0]));
                    continue;
                }
                Object o3 = Utils.getMethodValue(m, elValue);
                if (m.getName().equals("getMessage") && o3 != null) {
                    if (isLoggableFinest) {
                        LOG.finest("method m: " + m + " is equal to getMessage and Object o is not null");
                    }
                    if (!o3.equals(hasGetMessage)) {
                        if (isLoggableFinest) {
                            LOG.finest("Object value wasn't equal to hasGetMessage, writing Object o: " + o3);
                        }
                        JAXBEncoderDecoder.writeObject(marshaller, writer, JAXBEncoderDecoder.newJAXBElement(mname, String.class, o3));
                    }
                    hasGetMessage = o3;
                    continue;
                }
                if (!m.getName().equals("getMessage")) {
                    if (isLoggableFinest) {
                        LOG.finest("method m: " + m + " is not equal to getMessage, writing Object o:" + o3);
                    }
                    JAXBEncoderDecoder.writeObject(marshaller, writer, JAXBEncoderDecoder.newJAXBElement(mname, String.class, o3));
                    continue;
                }
                if (o3 != null || m.getDeclaringClass().equals(Throwable.class)) continue;
                if (isLoggableFinest) {
                    LOG.finest("method m: " + m + " is not from Throwable.class. Writing Object o:" + o3);
                }
                JAXBEncoderDecoder.writeObject(marshaller, writer, JAXBEncoderDecoder.newJAXBElement(mname, String.class, o3));
            }
            writer.writeEndElement();
            writer.flush();
        }
        catch (Exception e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{e.getMessage()}), (Throwable)e);
        }
        finally {
            StaxUtils.close((XMLStreamWriter)writer);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshallException");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static String getName(Member m1) {
        String m1Name;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getName", new Object[]{m1});
        }
        if (m1 instanceof Field) {
            m1Name = ((Field)m1).getName();
        } else {
            int idx = m1.getName().startsWith("get") ? 3 : 2;
            String name = m1.getName().substring(idx);
            m1Name = Character.toLowerCase(name.charAt(0)) + name.substring(1);
        }
        String string = m1Name;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            string = string;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getName", string);
        }
        return string;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void writeArrayObject(Marshaller marshaller, Object source, QName mname, Object mObj) throws Fault, JAXBException {
        Class<?> cls;
        Object[] objArray;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "writeArrayObject", new Object[]{marshaller, source, mname, mObj});
        }
        if (mObj == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "writeArrayObject");
            }
            return;
        }
        if (mObj instanceof List) {
            List l = (List)mObj;
            objArray = l.toArray();
            cls = null;
        } else {
            objArray = mObj;
            cls = objArray.getClass().getComponentType();
        }
        int len = Array.getLength(objArray);
        for (int x = 0; x < len; ++x) {
            Object o = Array.get(objArray, x);
            JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(mname, cls == null ? o.getClass() : cls, o));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "writeArrayObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Exception unmarshallException(Unmarshaller u, Object source, MessagePartInfo part) {
        Exception exception;
        block34: {
            XMLStreamReader reader;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshallException", new Object[]{u, source, part});
            }
            if (source instanceof XMLStreamReader) {
                reader = (XMLStreamReader)source;
            } else if (source instanceof Element) {
                reader = StaxUtils.createXMLStreamReader((Element)((Element)source));
                try {
                    reader.nextTag();
                }
                catch (XMLStreamException e) {
                    if (LOG.isLoggable(Level.FINEST)) {
                        LOG.finest("unmarshallException: Ignoring exception: " + e);
                    }
                }
            } else {
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
            }
            try {
                Object obj;
                QName qn = part.getElementQName();
                if (!qn.equals(reader.getName())) {
                    throw new Fault(new Message("ELEMENT_NAME_MISMATCH", LOG, new Object[]{qn, reader.getName()}));
                }
                Class cls = part.getTypeClass();
                try {
                    Constructor cons = cls.getConstructor(new Class[0]);
                    obj = cons.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException nse) {
                    Constructor cons = cls.getConstructor(String.class);
                    obj = cons.newInstance(new Object[1]);
                }
                XmlAccessType accessType = Utils.getXmlAccessType(cls);
                reader.nextTag();
                while (reader.getEventType() == 1) {
                    Object o;
                    QName q = reader.getName();
                    String fieldName = q.getLocalPart();
                    Field f = Utils.getField(cls, accessType, fieldName);
                    if (f != null) {
                        Type type = f.getGenericType();
                        ReflectionUtil.setAccessible((AccessibleObject)f);
                        if (JAXBSchemaInitializer.isArray(type)) {
                            Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                            List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader, q, compType, JAXBEncoderDecoder.createList(type));
                            o = ret;
                            if (!JAXBEncoderDecoder.isList(type)) {
                                if (compType.isPrimitive()) {
                                    o = Array.newInstance(compType, ret.size());
                                    for (int x = 0; x < ret.size(); ++x) {
                                        Array.set(o, x, ret.get(x));
                                    }
                                } else {
                                    o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                                }
                            }
                            f.set(obj, o);
                        } else {
                            Object o2 = JAXBEncoderDecoder.getElementValue(u.unmarshal(reader, Utils.getFieldType(f)));
                            Utils.setFieldValue(f, obj, o2);
                        }
                    } else {
                        Type type;
                        String s = StringUtils.capitalize((String)q.getLocalPart());
                        Method m = Utils.getMethod(cls, accessType, "get" + s, new Class[0]);
                        if (m == null) {
                            m = Utils.getMethod(cls, accessType, "is" + s, new Class[0]);
                        }
                        if (JAXBSchemaInitializer.isArray(type = m.getGenericReturnType())) {
                            Class<?> compType = JAXBSchemaInitializer.getArrayComponentType(type);
                            List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, reader, q, compType, JAXBEncoderDecoder.createList(type));
                            o = ret;
                            if (!JAXBEncoderDecoder.isList(type)) {
                                if (compType.isPrimitive()) {
                                    o = Array.newInstance(compType, ret.size());
                                    for (int x = 0; x < ret.size(); ++x) {
                                        Array.set(o, x, ret.get(x));
                                    }
                                } else {
                                    o = ret.toArray((Object[])Array.newInstance(compType, ret.size()));
                                }
                            }
                        } else {
                            o = JAXBEncoderDecoder.getElementValue(u.unmarshal(reader, Utils.getMethodReturnType(m)));
                        }
                        Method m2 = Utils.getMethod(cls, accessType, "set" + s, m.getReturnType());
                        if (m2 != null) {
                            if (JAXBSchemaInitializer.isArray(type)) {
                                m2.invoke(obj, o);
                            } else {
                                Utils.setMethodValue(m, m2, obj, o);
                            }
                        } else {
                            Field fn = ReflectionUtil.getDeclaredField((Class)cls, (String)q.getLocalPart());
                            if (fn != null) {
                                ReflectionUtil.setAccessible((AccessibleObject)fn);
                                fn.set(obj, o);
                            }
                        }
                    }
                    if (reader.getEventType() != 2 || !q.equals(reader.getName())) continue;
                    reader.next();
                }
                exception = (Exception)obj;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block34;
            }
            catch (Exception e) {
                throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{e.getMessage()}), (Throwable)e);
            }
            exception = exception;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshallException", exception);
        }
        return exception;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static void writeObject(Marshaller u, Object source, Object mObj) throws Fault, JAXBException {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "writeObject", new Object[]{u, source, mObj});
        }
        if (source instanceof XMLStreamWriter) {
            if (source instanceof MarshallerAwareXMLWriter) {
                ((MarshallerAwareXMLWriter)source).setMarshaller(u);
            }
            u.marshal(mObj, (XMLStreamWriter)source);
        } else if (source instanceof OutputStream) {
            u.marshal(mObj, (OutputStream)source);
        } else if (source instanceof Node) {
            u.marshal(mObj, (Node)source);
        } else if (source instanceof XMLEventWriter) {
            if (source instanceof MarshallerAwareXMLWriter) {
                ((MarshallerAwareXMLWriter)source).setMarshaller(u);
            }
            u.marshal(mObj, (XMLEventWriter)source);
        } else {
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "writeObject");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static XMLStreamWriter getStreamWriter(Object source) throws Fault {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getStreamWriter", new Object[]{source});
        }
        if (source instanceof XMLStreamWriter) {
            XMLStreamWriter xMLStreamWriter = (XMLStreamWriter)source;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLStreamWriter = xMLStreamWriter;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getStreamWriter", xMLStreamWriter);
            }
            return xMLStreamWriter;
        }
        if (source instanceof OutputStream) {
            XMLStreamWriter xMLStreamWriter = StaxUtils.createXMLStreamWriter((OutputStream)((OutputStream)source));
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                xMLStreamWriter = xMLStreamWriter;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getStreamWriter", xMLStreamWriter);
            }
            return xMLStreamWriter;
        }
        if (source instanceof Node) {
            W3CDOMStreamWriter w3CDOMStreamWriter = new W3CDOMStreamWriter((Element)source);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                w3CDOMStreamWriter = w3CDOMStreamWriter;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getStreamWriter", w3CDOMStreamWriter);
            }
            return w3CDOMStreamWriter;
        }
        throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static void marshallNullElement(Marshaller marshaller, Object source, MessagePartInfo part) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshallNullElement", new Object[]{marshaller, source, part});
        }
        Class clazz = part != null ? part.getTypeClass() : null;
        try {
            JAXBEncoderDecoder.writeObject(marshaller, source, JAXBEncoderDecoder.newJAXBElement(part.getElementQName(), clazz, null));
        }
        catch (JAXBException e) {
            throw new Fault(new Message("MARSHAL_ERROR", LOG, new Object[]{e.getMessage()}), (Throwable)e);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "marshallNullElement");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object unmarshall(Unmarshaller u, Object source, MessagePartInfo part, boolean unwrap) {
        List<Object> o;
        QName elName;
        Class clazz;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", new Object[]{u, source, part, unwrap});
        }
        Class clazz2 = clazz = part != null ? part.getTypeClass() : null;
        if (clazz != null && Exception.class.isAssignableFrom(clazz) && Boolean.TRUE.equals(part.getProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION"))) {
            Exception exception = JAXBEncoderDecoder.unmarshallException(u, source, part);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                exception = exception;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", exception);
            }
            return exception;
        }
        QName qName = elName = part != null ? part.getConcreteName() : null;
        if (clazz != null && clazz.isArray() && part.getXmlSchema() instanceof XmlSchemaElement) {
            XmlSchemaElement el = (XmlSchemaElement)part.getXmlSchema();
            if (el.getSchemaType() instanceof XmlSchemaSimpleType && ((XmlSchemaSimpleType)el.getSchemaType()).getContent() instanceof XmlSchemaSimpleTypeList) {
                Object obj = JAXBEncoderDecoder.unmarshall(u, source, elName, null, unwrap);
                if (clazz.isArray() && obj instanceof List) {
                    Object[] objectArray = ((List)obj).toArray((Object[])Array.newInstance(clazz.getComponentType(), ((List)obj).size()));
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        objectArray = objectArray;
                        LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", objectArray);
                    }
                    return objectArray;
                }
                Object object = obj;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    object = object;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", object);
                }
                return object;
            }
            if (part.getMessageInfo().getOperation().isUnwrapped() && el.getMaxOccurs() != 1L) {
                List<Object> ret = JAXBEncoderDecoder.unmarshallArray(u, source, elName, clazz.getComponentType(), JAXBEncoderDecoder.createList(part));
                Object[] o2 = ret;
                if (!JAXBEncoderDecoder.isList(part)) {
                    if (JAXBEncoderDecoder.isSet(part)) {
                        o2 = JAXBEncoderDecoder.createSet(part, ret);
                    } else if (clazz.getComponentType().isPrimitive()) {
                        o2 = Array.newInstance(clazz.getComponentType(), ret.size());
                        for (int x = 0; x < ret.size(); ++x) {
                            Array.set(o2, x, ret.get(x));
                        }
                    } else {
                        o2 = ret.toArray((Object[])Array.newInstance(clazz.getComponentType(), ret.size()));
                    }
                }
                List<Object> list = o2;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    list = list;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", list);
                }
                return list;
            }
        } else {
            if (byte[].class == clazz && part.getTypeQName() != null && "hexBinary".equals(part.getTypeQName().getLocalPart())) {
                String obj = (String)JAXBEncoderDecoder.unmarshall(u, source, elName, String.class, unwrap);
                byte[] byArray = new HexBinaryAdapter().unmarshal(obj);
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    byArray = byArray;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", byArray);
                }
                return byArray;
            }
            if (part != null && u.getSchema() != null && !(part.getXmlSchema() instanceof XmlSchemaElement)) {
                source = JAXBEncoderDecoder.updateSourceWithXSIType(source, part.getTypeQName());
            }
        }
        if ((o = JAXBEncoderDecoder.unmarshall(u, source, elName, clazz, unwrap)) != null && o.getClass().isArray() && JAXBEncoderDecoder.isList(part)) {
            List<Object> ret = JAXBEncoderDecoder.createList(part);
            Collections.addAll(ret, (Object[])o);
            o = ret;
        }
        List<Object> list = o;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object updateSourceWithXSIType(Object source, QName typeQName) {
        XMLStreamReader reader;
        String type;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "updateSourceWithXSIType", new Object[]{source, typeQName});
        }
        if (source instanceof XMLStreamReader && typeQName != null && StringUtils.isEmpty((String)(type = (reader = (XMLStreamReader)source).getAttributeValue("http://www.w3.org/2001/XMLSchema-instance", "type")))) {
            source = new AddXSITypeStreamReader(reader, typeQName);
        }
        Object object = source;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "updateSourceWithXSIType", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object createSet(MessagePartInfo part, List<Object> ret) {
        HashSet<Object> c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createSet", new Object[]{part, ret});
        }
        Type genericType = (Type)part.getProperty("generic.type");
        Class tp2 = (Class)((ParameterizedType)genericType).getRawType();
        if (tp2.isInterface()) {
            HashSet<Object> hashSet = new HashSet<Object>(ret);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                hashSet = hashSet;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createSet", hashSet);
            }
            return hashSet;
        }
        try {
            c = CastUtils.cast((Collection)((Collection)tp2.newInstance()));
        }
        catch (Exception e) {
            c = new HashSet<Object>();
        }
        c.addAll(ret);
        HashSet<Object> hashSet = c;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            hashSet = hashSet;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createSet", hashSet);
        }
        return hashSet;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isSet(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isSet", new Object[]{part});
        }
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            boolean bl = Set.class.isAssignableFrom((Class)tp2);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isSet", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isSet", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Object> createList(MessagePartInfo part) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createList", new Object[]{part});
        }
        Type genericType = (Type)part.getProperty("generic.type");
        List<Object> list = JAXBEncoderDecoder.createList(genericType);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createList", list);
        }
        return list;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static List<Object> createList(Type genericType) {
        block6: {
            Class cls;
            Type tp2;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createList", new Object[]{genericType});
            }
            if (genericType instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class && !(cls = (Class)tp2).isInterface() && List.class.isAssignableFrom(cls)) {
                List list;
                block5: {
                    try {
                        list = CastUtils.cast((List)((List)cls.newInstance()));
                        if (LOG == null || !LOG.isLoggable(Level.FINER)) break block5;
                    }
                    catch (Exception e) {
                        if (!LOG.isLoggable(Level.FINEST)) break block6;
                        LOG.finest("createList: Ignoring exception: " + e);
                    }
                    list = list;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createList", list);
                }
                return list;
            }
        }
        ArrayList<Object> arrayList = new ArrayList<Object>();
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            arrayList = arrayList;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "createList", arrayList);
        }
        return arrayList;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isList(Type cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isList", new Object[]{cls});
        }
        boolean bl = cls instanceof ParameterizedType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isList", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static boolean isList(MessagePartInfo part) {
        Type tp2;
        Type genericType;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isList", new Object[]{part});
        }
        if (part.getTypeClass().isArray() && !part.getTypeClass().getComponentType().isPrimitive() && (genericType = (Type)part.getProperty("generic.type")) instanceof ParameterizedType && (tp2 = ((ParameterizedType)genericType).getRawType()) instanceof Class) {
            boolean bl = List.class.isAssignableFrom((Class)tp2);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isList", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "isList", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object doUnmarshal(Unmarshaller u, Object source, QName elName, Class<?> clazz, boolean unwrap) throws Exception {
        Object obj;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "doUnmarshal", new Object[]{u, source, elName, clazz, unwrap});
        }
        boolean unmarshalWithClass = true;
        if (clazz == null || !clazz.isPrimitive() && !clazz.isArray() && !clazz.isEnum() && !clazz.equals(Calendar.class) && (Modifier.isAbstract(clazz.getModifiers()) || Modifier.isInterface(clazz.getModifiers()))) {
            unmarshalWithClass = false;
        }
        if (clazz != null && ("javax.xml.datatype.XMLGregorianCalendar".equals(clazz.getName()) || "javax.xml.datatype.Duration".equals(clazz.getName()))) {
            unmarshalWithClass = true;
        }
        if (LOG.isLoggable(Level.FINEST)) {
            LOG.finest("doUnmarshal: unmarshalWithClass value: " + unmarshalWithClass);
        }
        if (source instanceof Node) {
            obj = unmarshalWithClass ? u.unmarshal((Node)source, clazz) : u.unmarshal((Node)source);
        } else if (source instanceof DepthXMLStreamReader) {
            DepthXMLStreamReader dr = (DepthXMLStreamReader)source;
            XMLStreamReader reader = dr.getReader();
            if (reader instanceof UnmarshallerAwareXMLReader) {
                ((UnmarshallerAwareXMLReader)((Object)reader)).setUnmarshaller(u);
            }
            if (u.getSchema() != null) {
                reader = JAXBEncoderDecoder.findExtraNamespaces(reader);
            }
            obj = unmarshalWithClass ? u.unmarshal(reader, clazz) : u.unmarshal(dr.getReader());
        } else if (source instanceof XMLStreamReader) {
            XMLStreamReader reader = (XMLStreamReader)source;
            if (reader instanceof UnmarshallerAwareXMLReader) {
                ((UnmarshallerAwareXMLReader)((Object)reader)).setUnmarshaller(u);
            }
            if (u.getSchema() != null) {
                reader = JAXBEncoderDecoder.findExtraNamespaces(reader);
            }
            obj = unmarshalWithClass ? u.unmarshal(reader, clazz) : u.unmarshal(reader);
        } else if (source instanceof XMLEventReader) {
            if (source instanceof UnmarshallerAwareXMLReader) {
                ((UnmarshallerAwareXMLReader)source).setUnmarshaller(u);
            }
            obj = unmarshalWithClass ? u.unmarshal((XMLEventReader)source, clazz) : u.unmarshal((XMLEventReader)source);
        } else {
            if (source == null) {
                throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{"null"}));
            }
            throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
        }
        Object object = unwrap ? JAXBEncoderDecoder.getElementValue(obj) : obj;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "doUnmarshal", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object unmarshall(final Unmarshaller u, final Object source, final QName elName, final Class<?> clazz, final boolean unwrap) {
        Object object;
        block6: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", new Object[]{u, source, elName, clazz, unwrap});
            }
            try {
                object = AccessController.doPrivileged(new PrivilegedExceptionAction<Object>(){
                    static final long serialVersionUID = 3696300893426311780L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    @Override
                    public Object run() throws Exception {
                        return JAXBEncoderDecoder.doUnmarshal(u, source, elName, clazz, unwrap);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBEncoderDecoder$3", 3.class, null, null);
                    }
                });
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block6;
            }
            catch (PrivilegedActionException e) {
                Exception ex = e.getException();
                if (ex instanceof Fault) {
                    throw (Fault)((Object)ex);
                }
                if (ex instanceof UnmarshalException) {
                    UnmarshalException unmarshalEx = (UnmarshalException)ex;
                    if (unmarshalEx.getLinkedException() != null) {
                        throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{unmarshalEx.getLinkedException().getMessage()}), (Throwable)ex);
                    }
                    throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{unmarshalEx.getMessage()}), (Throwable)ex);
                }
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshall", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static XMLStreamReader findExtraNamespaces(XMLStreamReader source) {
        TreeMap<String, String> nsMap;
        boolean isLoggableFinest;
        block20: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "findExtraNamespaces", new Object[]{source});
            }
            isLoggableFinest = LOG.isLoggable(Level.FINEST);
            NamespaceContext c = source.getNamespaceContext();
            nsMap = new TreeMap<String, String>();
            try {
                block21: {
                    if (c instanceof W3CNamespaceContext) {
                        for (Element element = ((W3CNamespaceContext)c).getElement(); element != null; element = (Element)element.getParentNode()) {
                            NamedNodeMap namedNodeMap = element.getAttributes();
                            for (int i = 0; i < namedNodeMap.getLength(); ++i) {
                                Attr attr = (Attr)namedNodeMap.item(i);
                                if (attr.getPrefix() == null || !"xmlns".equals(attr.getPrefix())) continue;
                                nsMap.put(attr.getLocalName(), attr.getValue());
                            }
                        }
                        break block20;
                    }
                    try {
                        c = (NamespaceContext)c.getClass().getMethod("createNonTransientNsContext", Location.class).invoke((Object)c, new Object[1]);
                    }
                    catch (Throwable t) {
                        if (!isLoggableFinest) break block21;
                        LOG.finest("findExtraNamespaces: Ignoring Throwable: " + t);
                    }
                }
                Field f = ReflectionUtil.getDeclaredField(c.getClass(), (String)"mNamespaces");
                ReflectionUtil.setAccessible((AccessibleObject)f);
                String[] ns = (String[])f.get(c);
                for (int x = 0; x < ns.length; x += 2) {
                    if (ns[x] == null) {
                        nsMap.put("", ns[x + 1]);
                        continue;
                    }
                    nsMap.put(ns[x], ns[x + 1]);
                }
            }
            catch (Throwable t) {
                try {
                    Field f = ReflectionUtil.getDeclaredField(c.getClass(), (String)"fNamespaceContext");
                    ReflectionUtil.setAccessible((AccessibleObject)f);
                    Object c2 = f.get(c);
                    Enumeration enm = (Enumeration)c2.getClass().getMethod("getAllPrefixes", new Class[0]).invoke(c2, new Object[0]);
                    while (enm.hasMoreElements()) {
                        String s = (String)enm.nextElement();
                        if (s == null) {
                            nsMap.put("", c.getNamespaceURI(null));
                            continue;
                        }
                        nsMap.put(s, c.getNamespaceURI(s));
                    }
                }
                catch (Throwable t2) {
                    if (!isLoggableFinest) break block20;
                    LOG.finest("findExtraNamespaces: Ignoring Throwable t2: " + t2);
                }
            }
        }
        if (!nsMap.isEmpty()) {
            for (int x = 0; x < source.getNamespaceCount(); ++x) {
                String pfx = source.getNamespacePrefix(x);
                if (pfx == null) {
                    nsMap.remove("");
                    continue;
                }
                nsMap.remove(pfx);
            }
            if (!nsMap.isEmpty()) {
                if (isLoggableFinest) {
                    LOG.finest("findExtraNamespaces: Got some extra namespaces: " + nsMap);
                }
                final Map.Entry[] namespaces = nsMap.entrySet().toArray(new Map.Entry[nsMap.size()]);
                source = new DepthXMLStreamReader(source){
                    static final long serialVersionUID = -1888986766212759805L;
                    private static final /* synthetic */ TraceComponent $$$tc$$$;

                    public int getNamespaceCount() {
                        if (this.getDepth() == 0 && this.isStartElement()) {
                            return super.getNamespaceCount() + nsMap.size();
                        }
                        return super.getNamespaceCount();
                    }

                    public String getNamespacePrefix(int arg0) {
                        int i;
                        if (this.getDepth() == 0 && this.isStartElement() && arg0 >= (i = super.getNamespaceCount())) {
                            return (String)namespaces[arg0 -= i].getKey();
                        }
                        return super.getNamespacePrefix(arg0);
                    }

                    public String getNamespaceURI(int arg0) {
                        int i;
                        if (this.getDepth() == 0 && this.isStartElement() && arg0 >= (i = super.getNamespaceCount())) {
                            return (String)namespaces[arg0 -= i].getValue();
                        }
                        return super.getNamespaceURI(arg0);
                    }

                    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                    static {
                        $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBEncoderDecoder$4", 4.class, null, null);
                    }
                };
            }
        }
        XMLStreamReader xMLStreamReader = source;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            xMLStreamReader = xMLStreamReader;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "findExtraNamespaces", xMLStreamReader);
        }
        return xMLStreamReader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Object getElementValue(Object obj) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getElementValue", new Object[]{obj});
        }
        if (null == obj) {
            Object v0 = null;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                v0 = v0;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getElementValue", v0);
            }
            return v0;
        }
        if (obj instanceof JAXBElement) {
            Object object = ((JAXBElement)obj).getValue();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                object = object;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getElementValue", object);
            }
            return object;
        }
        Object object = obj;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            object = object;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getElementValue", object);
        }
        return object;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static Class<?> getClassFromType(Type t) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getClassFromType", new Object[]{t});
        }
        if (t instanceof Class) {
            Class clazz = (Class)t;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getClassFromType", clazz);
            }
            return clazz;
        }
        if (t instanceof GenericArrayType) {
            GenericArrayType g = (GenericArrayType)t;
            Class<?> clazz = Array.newInstance(JAXBEncoderDecoder.getClassFromType(g.getGenericComponentType()), 0).getClass();
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getClassFromType", clazz);
            }
            return clazz;
        }
        if (t instanceof ParameterizedType) {
            ParameterizedType p = (ParameterizedType)t;
            Class<?> clazz = JAXBEncoderDecoder.getClassFromType(p.getRawType());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                clazz = clazz;
                LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "getClassFromType", clazz);
            }
            return clazz;
        }
        assert (false);
        throw new IllegalArgumentException("Cannot get Class object from unknown Type");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public static List<Object> unmarshallArray(Unmarshaller u, Object source, QName elName, Class<?> clazz, List<Object> ret) {
        List<Object> list;
        block12: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshallArray", new Object[]{u, source, elName, clazz, ret});
            }
            try {
                XMLStreamReader reader;
                if (source instanceof XMLStreamReader) {
                    reader = (XMLStreamReader)source;
                } else if (source instanceof Element) {
                    reader = StaxUtils.createXMLStreamReader((Element)((Element)source));
                } else {
                    throw new Fault(new Message("UNKNOWN_SOURCE", LOG, new Object[]{source.getClass().getName()}));
                }
                while (reader.getName().equals(elName)) {
                    JAXBElement type = u.unmarshal(reader, clazz);
                    if (type != null) {
                        ret.add(type.getValue());
                    }
                    while (reader.getEventType() != 1 && reader.getEventType() != 2) {
                        reader.nextTag();
                    }
                }
                list = ret;
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block12;
            }
            catch (Fault ex) {
                throw ex;
            }
            catch (MarshalException ex) {
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getLinkedException().getMessage()}), (Throwable)ex);
            }
            catch (Exception ex) {
                throw new Fault(new Message("UNMARSHAL_ERROR", LOG, new Object[]{ex.getMessage()}), (Throwable)ex);
            }
            list = list;
            LOG.exiting("org.apache.cxf.jaxb.JAXBEncoderDecoder", "unmarshallArray", list);
        }
        return list;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @TraceOptions
    private static final class AddXSITypeStreamReader
    extends StreamReaderDelegate {
        private boolean first = true;
        private int offset = 1;
        private final QName typeQName;
        static final long serialVersionUID = -4793430731840660905L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private AddXSITypeStreamReader(XMLStreamReader reader, QName typeQName) {
            super(reader);
            this.typeQName = typeQName;
        }

        @Override
        public int getAttributeCount() {
            return super.getAttributeCount() + this.offset;
        }

        @Override
        public String getAttributeLocalName(int index) {
            if (this.first && index == 0) {
                return "type";
            }
            return super.getAttributeLocalName(index - this.offset);
        }

        @Override
        public QName getAttributeName(int index) {
            if (this.first && index == 0) {
                return new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
            }
            return super.getAttributeName(index - this.offset);
        }

        @Override
        public String getAttributeNamespace(int index) {
            if (this.first && index == 0) {
                return "http://www.w3.org/2001/XMLSchema-instance";
            }
            return super.getAttributeNamespace(index - this.offset);
        }

        @Override
        public String getAttributePrefix(int index) {
            if (this.first && index == 0) {
                return "xsi";
            }
            return super.getAttributePrefix(index - this.offset);
        }

        @Override
        public String getAttributeType(int index) {
            if (this.first && index == 0) {
                return "#TEXT";
            }
            return super.getAttributeType(index - this.offset);
        }

        @Override
        public String getAttributeValue(int index) {
            if (this.first && index == 0) {
                String pfx = this.getNamespaceContext().getPrefix(this.typeQName.getNamespaceURI());
                if (StringUtils.isEmpty((String)pfx)) {
                    return this.typeQName.getLocalPart();
                }
                return pfx + ":" + this.typeQName.getLocalPart();
            }
            return super.getAttributeValue(index - this.offset);
        }

        @Override
        public int next() throws XMLStreamException {
            this.first = false;
            this.offset = 0;
            return super.next();
        }

        @Override
        public String getAttributeValue(String namespaceUri, String localName) {
            if (this.first && "http://www.w3.org/2001/XMLSchema-instance".equals(namespaceUri) && "type".equals(localName)) {
                String pfx = this.getNamespaceContext().getPrefix(this.typeQName.getNamespaceURI());
                if (StringUtils.isEmpty((String)pfx)) {
                    return this.typeQName.getLocalPart();
                }
                return pfx + ":" + this.typeQName.getLocalPart();
            }
            return super.getAttributeValue(namespaceUri, localName);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"org.apache.cxf.jaxb.JAXBEncoderDecoder$AddXSITypeStreamReader", AddXSITypeStreamReader.class, null, null);
        }
    }
}

