/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.client.internal;

import com.google.gson.JsonParser;
import com.ibm.json.java.JSONObject;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.websphere.ssl.JSSEHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.ssl.NoSSLSocketFactoryException;
import com.ibm.ws.security.common.ssl.SecuritySSLUtils;
import com.ibm.ws.security.openidconnect.client.internal.AccessTokenCacheHelper;
import com.ibm.ws.security.openidconnect.client.internal.AttributeToSubjectExt;
import com.ibm.ws.security.openidconnect.client.internal.OidcClientAuthenticator;
import com.ibm.ws.security.openidconnect.client.jose4j.util.Jose4jUtil;
import com.ibm.ws.security.openidconnect.clients.common.ConvergedClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OIDCClientAuthenticatorUtil;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientConfig;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientUtil;
import com.ibm.ws.security.openidconnect.clients.common.UserInfoHelper;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import com.ibm.ws.webcontainer.security.AuthResult;
import com.ibm.ws.webcontainer.security.ProviderAuthenticationResult;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.common.jwt.JwtParsingUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocketFactory;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.StatusLine;
import org.apache.http.util.EntityUtils;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class AccessTokenAuthenticator {
    private static final TraceComponent tc = Tr.register(AccessTokenAuthenticator.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.client.internal.resources.OidcClientMessages");
    private static final String Authorization_Header = "Authorization";
    private static final String ACCESS_TOKEN = "access_token";
    private static final String INVALID_CLIENT = "invalid_client";
    private static final String INVALID_TOKEN = "invalid_token";
    private static final String JWT_SEGMENTS = "-segments";
    private static final String JWT_SEGMENT_INDEX = "-";
    private static final String BEARER_SCHEME = "bearer ";
    OidcClientUtil oidcClientUtil = new OidcClientUtil();
    SSLSupport sslSupport = null;
    private Jose4jUtil jose4jUtil = null;
    AccessTokenCacheHelper cacheHelper = new AccessTokenCacheHelper();
    static final long serialVersionUID = -1848625957833413368L;

    public AccessTokenAuthenticator() {
    }

    public AccessTokenAuthenticator(AtomicServiceReference<SSLSupport> sslSupportRef) {
        this.sslSupport = (SSLSupport)sslSupportRef.getService();
        this.jose4jUtil = new Jose4jUtil(this.sslSupport);
    }

    /*
     * WARNING - void declaration
     */
    public ProviderAuthenticationResult authenticate(HttpServletRequest req, HttpServletResponse res, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        oidcClientRequest.setTokenType("Access Token");
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        String accessToken = null;
        if (clientConfig.getAccessTokenInLtpaCookie()) {
            accessToken = this.getAccessTokenFromReqAsAttribute(req, true);
        }
        if (accessToken == null) {
            accessToken = AccessTokenAuthenticator.getBearerAccessTokenToken(req, clientConfig);
        }
        if (accessToken == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"access token in the request as attribute: ", (Object[])new Object[]{accessToken});
            }
            oidcClientRequest.setRsFailMsg("", "suppress_CWWKS1704W");
            return oidcResult;
        }
        boolean accessTokenIsJWT = this.isTokenJWT(accessToken);
        ProviderAuthenticationResult cachedResult = null;
        if (clientConfig.getTokenReuse() || !accessTokenIsJWT) {
            cachedResult = this.cacheHelper.getCachedTokenAuthenticationResult(clientConfig, accessToken);
        }
        if (cachedResult != null) {
            req.setAttribute("com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated", (Object)Boolean.TRUE);
            return cachedResult;
        }
        String validationMethod = clientConfig.getValidationMethod();
        String jwtRemoteValidation = "none";
        if (accessTokenIsJWT) {
            oidcClientRequest.setTokenType("Json Web Token");
            jwtRemoteValidation = clientConfig.getJwtAccessTokenRemoteValidation();
            if (!"require".equals(jwtRemoteValidation)) {
                validationMethod = "local";
            }
        }
        SSLSocketFactory sslSocketFactory = null;
        try {
            String validationUrl = this.getPropagationValidationURL(clientConfig, validationMethod);
            sslSocketFactory = this.getSSLSocketFactory(validationUrl, clientConfig.getSSLConfigurationName(), clientConfig.getClientId());
        }
        catch (com.ibm.websphere.ssl.SSLException validationUrl) {
            void e;
            FFDCFilter.processException((Throwable)validationUrl, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"152", (Object)this, (Object[])new Object[]{req, res, clientConfig, oidcClientRequest});
            this.logError(clientConfig, oidcClientRequest, "OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", e, clientConfig.getClientId());
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        if (validationMethod.equalsIgnoreCase("local")) {
            oidcResult = this.parseJwtToken(clientConfig, accessToken, sslSocketFactory, oidcClientRequest);
            if (!this.isAuthenticationResultSuccessful(oidcResult) && "allow".equals(jwtRemoteValidation)) {
                oidcResult = this.doRemoteAccessTokenValidation(clientConfig, oidcClientRequest, accessToken, sslSocketFactory);
            }
        } else {
            oidcResult = this.doRemoteAccessTokenValidation(clientConfig, oidcClientRequest, accessToken, sslSocketFactory);
        }
        if (AuthResult.SUCCESS == oidcResult.getStatus()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"attribute:com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated", (Object[])new Object[0]);
            }
            oidcResult = this.fixSubject(oidcResult);
            req.setAttribute("com.ibm.ws.webcontainer.security.openidconnect.propagation.token.authenticated", (Object)Boolean.TRUE);
            this.cacheHelper.cacheTokenAuthenticationResult(clientConfig, accessToken, oidcResult);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("oidcResult httpStatusCode:" + oidcResult.getHttpStatusCode() + " status:" + oidcResult.getStatus() + " result:" + oidcResult), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Token is owned by '" + oidcResult.getUserName() + "'"), (Object[])new Object[0]);
        }
        return oidcResult;
    }

    boolean isAuthenticationResultSuccessful(ProviderAuthenticationResult result) {
        return result != null && result.getStatus() == AuthResult.SUCCESS;
    }

    ProviderAuthenticationResult doRemoteAccessTokenValidation(OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest, String accessToken, SSLSocketFactory sslSocketFactory) {
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        String validationMethod = clientConfig.getValidationMethod();
        String validationEndpointURL = clientConfig.getValidationEndpointUrl();
        if (validationEndpointURL != null && !validationEndpointURL.isEmpty()) {
            if (!OIDCClientAuthenticatorUtil.checkHttpsRequirement((ConvergedClientConfig)clientConfig, (String)validationEndpointURL)) {
                this.logError(clientConfig, oidcClientRequest, "OIDC_CLIENT_URL_PROTOCOL_NOT_HTTPS", validationEndpointURL);
                return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
            }
            if (validationMethod.equalsIgnoreCase("introspect")) {
                oidcResult = this.introspectToken(clientConfig, accessToken, sslSocketFactory, oidcClientRequest);
                if (oidcResult.getStatus() == AuthResult.SUCCESS) {
                    new UserInfoHelper((ConvergedClientConfig)clientConfig, this.sslSupport).getUserInfoIfPossible(oidcResult, accessToken, oidcResult.getUserName(), sslSocketFactory, oidcClientRequest);
                }
            } else if (validationMethod.equalsIgnoreCase("userinfo")) {
                oidcResult = this.getUserInfoFromToken(clientConfig, accessToken, sslSocketFactory, oidcClientRequest);
            }
        } else {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_INVALID_VALIDATION_URL", validationEndpointURL);
        }
        return oidcResult;
    }

    @FFDCIgnore(value={Exception.class})
    protected boolean isTokenJWT(String token) {
        String[] parts = token.split("\\.");
        if (parts.length > 1) {
            try {
                JsonParser parser = new JsonParser();
                try {
                    parser.parse(JsonTokenUtil.fromBase64ToJsonString((String)parts[0])).getAsJsonObject();
                    return true;
                }
                catch (Exception e1) {
                    parser.parse(JsonTokenUtil.fromBase64ToJsonString((String)parts[1])).getAsJsonObject();
                    return true;
                }
            }
            catch (Exception e2) {
                return false;
            }
        }
        return false;
    }

    ProviderAuthenticationResult fixSubject(ProviderAuthenticationResult oidcResult) {
        return OidcClientAuthenticator.fixSubject(oidcResult);
    }

    private String getAccessTokenFromReqAsAttribute(HttpServletRequest req, boolean remove_attribute) {
        String token = null;
        if (req.getAttribute("oidc_access_token") != null) {
            token = (String)req.getAttribute("oidc_access_token");
            if (remove_attribute) {
                req.removeAttribute("oidc_access_token");
            }
        }
        return token;
    }

    String getPropagationValidationURL(OidcClientConfig clientConfig, String validationMethod) {
        if (validationMethod.equalsIgnoreCase("introspect") || validationMethod.equalsIgnoreCase("userinfo")) {
            return clientConfig.getValidationEndpointUrl();
        }
        if (validationMethod.equalsIgnoreCase("local")) {
            return clientConfig.getJwkEndpointUrl();
        }
        return clientConfig.getTokenEndpointUrl();
    }

    protected SSLContext getSSLContext(String tokenUrl, String sslConfigurationName, String clientId) throws com.ibm.websphere.ssl.SSLException {
        SSLContext sslContext = null;
        JSSEHelper jsseHelper = null;
        if (this.sslSupport != null) {
            jsseHelper = this.sslSupport.getJSSEHelper();
        }
        if (jsseHelper != null) {
            sslContext = jsseHelper.getSSLContext(sslConfigurationName, null, null, true);
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("sslContext () get: " + sslContext), (Object[])new Object[0]);
            }
        }
        if (sslContext == null && tokenUrl != null && tokenUrl.startsWith("https")) {
            throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl conext", clientId}));
        }
        return sslContext;
    }

    /*
     * WARNING - void declaration
     */
    @FFDCIgnore(value={NoSSLSocketFactoryException.class})
    protected SSLSocketFactory getSSLSocketFactory(String tokenUrl, String sslConfigurationName, String clientId) throws com.ibm.websphere.ssl.SSLException {
        SSLSocketFactory sslSocketFactory;
        block3: {
            sslSocketFactory = null;
            try {
                sslSocketFactory = SecuritySSLUtils.getSSLSocketFactory((SSLSupport)this.sslSupport, (String)sslConfigurationName);
            }
            catch (SSLException sSLException) {
                void e;
                FFDCFilter.processException((Throwable)sSLException, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"294", (Object)this, (Object[])new Object[]{tokenUrl, sslConfigurationName, clientId});
                throw new com.ibm.websphere.ssl.SSLException((Exception)e);
            }
            catch (NoSSLSocketFactoryException e) {
                if (tokenUrl == null || !tokenUrl.startsWith("https")) break block3;
                throw new com.ibm.websphere.ssl.SSLException(Tr.formatMessage((TraceComponent)tc, (String)"OIDC_CLIENT_HTTPS_WITH_SSLCONTEXT_NULL", (Object[])new Object[]{"Null ssl socket factory", clientId}));
            }
        }
        return sslSocketFactory;
    }

    JSONObject handleResponseMap(Map<String, Object> responseMap, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        JSONObject jobj = null;
        if (responseMap.get("RESPONSEMAP_CODE") != null) {
            HttpResponse response = (HttpResponse)responseMap.get("RESPONSEMAP_CODE");
            jobj = this.isErrorResponse(response) ? this.extractErrorResponse(clientConfig, oidcClientRequest, response) : this.extractSuccessfulResponse(clientConfig, oidcClientRequest, response);
        }
        return jobj;
    }

    @FFDCIgnore(value={IOException.class})
    JSONObject extractErrorResponse(OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest, HttpResponse response) throws IOException {
        String jresponse = null;
        JSONObject jobj = null;
        JSONObject errorjson = null;
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            jresponse = EntityUtils.toString((HttpEntity)entity);
            try {
                if (jresponse != null) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"received error from OP =", (Object[])new Object[]{jresponse});
                    }
                    errorjson = JSONObject.parse((String)jresponse);
                    this.logErrorMessage(errorjson, clientConfig, oidcClientRequest);
                    return null;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (jresponse == null || jresponse.isEmpty()) {
            Header header = response.getFirstHeader("WWW-Authenticate");
            jresponse = header.getValue();
        }
        if (jresponse != null) {
            String originalError;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"received error from OP and extracted it from the header =", (Object[])new Object[]{jresponse});
            }
            if (jresponse.contains(INVALID_TOKEN)) {
                this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_NOT_ACTIVE", clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl());
            }
            if ((originalError = this.extractErrorDescription(jresponse)) != null && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the original error from OP =", (Object[])new Object[]{originalError});
            }
            this.logError(clientConfig, oidcClientRequest, "OIDC_PROPAGATION_FAIL", originalError, clientConfig.getValidationEndpointUrl());
        } else {
            this.logError(clientConfig, oidcClientRequest, "OIDC_PROPAGATION_FAIL", "", clientConfig.getValidationEndpointUrl());
        }
        jobj = null;
        return jobj;
    }

    JSONObject extractSuccessfulResponse(OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest, HttpResponse response) throws Exception {
        HttpEntity entity = response.getEntity();
        String jresponse = null;
        if (entity != null) {
            jresponse = EntityUtils.toString((HttpEntity)entity);
        }
        if (jresponse == null) {
            return null;
        }
        String contentType = this.getContentType(entity);
        if (contentType == null) {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_INVALID_VALIDATION_URL", clientConfig.getValidationEndpointUrl());
            return null;
        }
        JSONObject jobj = null;
        if (contentType.contains("application/json")) {
            jobj = this.extractClaimsFromJsonResponse(jresponse, clientConfig, oidcClientRequest);
        } else if (contentType.contains("application/jwt")) {
            jobj = this.extractClaimsFromJwtResponse(jresponse, clientConfig, oidcClientRequest);
        }
        return jobj;
    }

    String getContentType(HttpEntity entity) {
        Header contentTypeHeader = entity.getContentType();
        if (contentTypeHeader != null) {
            return contentTypeHeader.getValue();
        }
        return null;
    }

    @FFDCIgnore(value={IOException.class})
    JSONObject extractClaimsFromJsonResponse(String jresponse, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        JSONObject jobj = null;
        try {
            jobj = JSONObject.parse((String)jresponse);
        }
        catch (IOException e) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"the response from OP is not in JSON format = ", (Object[])new Object[]{jresponse});
            }
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_INVALID_VALIDATION_URL", clientConfig.getValidationEndpointUrl());
        }
        return jobj;
    }

    JSONObject extractClaimsFromJwtResponse(String responseString, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        UserInfoHelper userInfoHelper = new UserInfoHelper((ConvergedClientConfig)clientConfig, null);
        String claims = userInfoHelper.extractClaimsFromJwtResponse(responseString, clientConfig, oidcClientRequest);
        if (claims == null) {
            return null;
        }
        return JSONObject.parse((String)claims);
    }

    JSONObject extractClaimsFromJwsResponse(String responseString, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) throws Exception {
        JwtClaims claims;
        JwtContext jwtContext = JwtParsingUtils.parseJwtWithoutValidation((String)responseString);
        if (jwtContext != null && (claims = this.jose4jUtil.validateJwsSignature(jwtContext, (ConvergedClientConfig)clientConfig, oidcClientRequest)) != null) {
            return JSONObject.parse((String)claims.toJson());
        }
        return null;
    }

    protected String extractErrorDescription(String response) {
        if (response == null) {
            return null;
        }
        String regexHeader = "(?:.*[^a-zA-Z0-9])?error_description=(.*)";
        Pattern pattern = Pattern.compile(regexHeader);
        Matcher m = pattern.matcher(response);
        if (!m.matches()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Response did not appear to contain an error description formatted as expected. Returning response as-is", (Object[])new Object[0]);
            }
            return response;
        }
        String description = null;
        if (m.groupCount() > 0 && (description = m.group(1)) != null && description.length() > 1 && description.charAt(0) == '\"' && description.charAt(description.length() - 1) == '\"') {
            description = description.substring(1, description.length() - 1);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Extracted description: [" + description + "]"), (Object[])new Object[0]);
        }
        return description;
    }

    /*
     * WARNING - void declaration
     */
    protected ProviderAuthenticationResult introspectToken(OidcClientConfig clientConfig, String accessToken, SSLSocketFactory sslSocketFactory, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        try {
            Map responseMap = this.oidcClientUtil.checkToken(clientConfig.getValidationEndpointUrl(), clientConfig.getClientId(), clientConfig.getClientSecret(), accessToken, clientConfig.isHostNameVerificationEnabled(), clientConfig.getTokenEndpointAuthMethod(), sslSocketFactory, clientConfig.getUseSystemPropertiesForHttpClientConnections());
            JSONObject jobj = null;
            jobj = this.handleResponseMap(responseMap, clientConfig, oidcClientRequest);
            if (jobj != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"introspectToken=", (Object[])new Object[]{jobj.serialize()});
                }
                if (!this.validateJsonResponse(jobj, clientConfig, oidcClientRequest)) {
                    this.logErrorMessage(jobj, clientConfig, oidcClientRequest);
                    return oidcResult;
                }
                oidcResult = this.createProviderAuthenticationResult(jobj, clientConfig, accessToken);
            }
        }
        catch (Exception responseMap) {
            void e;
            FFDCFilter.processException((Throwable)responseMap, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"516", (Object)this, (Object[])new Object[]{clientConfig, accessToken, sslSocketFactory, oidcClientRequest});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exception during introspectToken =", (Object[])new Object[]{e});
            }
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_INTERNAL_ERR", e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl());
            return oidcResult;
        }
        return oidcResult;
    }

    protected ProviderAuthenticationResult parseJwtToken(OidcClientConfig clientConfig, String accessToken, SSLSocketFactory sslSocketFactory, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        oidcClientRequest.setTokenType("Json Web Token");
        return this.jose4jUtil.createResultWithJose4JForJwt(accessToken, (ConvergedClientConfig)clientConfig, oidcClientRequest);
    }

    private boolean isErrorResponse(HttpResponse response) {
        StatusLine status = response.getStatusLine();
        return status == null || status.getStatusCode() != 200;
    }

    private void logErrorMessage(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        String err = (String)jobj.get((Object)"error");
        String inboundPropagation = clientConfig.getInboundPropagation();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("rs_err:" + err + " inboundPropagation:" + inboundPropagation), (Object[])new Object[0]);
        }
        boolean isPropagationSupported = "supported".equals(inboundPropagation);
        String msgKey = null;
        Object[] msgObjs = null;
        if (err == null) {
            return;
        }
        if (INVALID_CLIENT.equals(err)) {
            msgKey = "PROPAGATION_TOKEN_INVALID_CLIENTID";
            msgObjs = new Object[]{clientConfig.getClientId(), clientConfig.getValidationEndpointUrl()};
        } else if (INVALID_TOKEN.equals(err)) {
            msgKey = "PROPAGATION_TOKEN_NOT_ACTIVE";
            msgObjs = new Object[]{clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl()};
        } else {
            String err_desc = null;
            if ((String)jobj.get((Object)"error_description") != null) {
                err_desc = (String)jobj.get((Object)"error_description");
            }
            msgKey = "OIDC_PROPAGATION_FAIL";
            msgObjs = new Object[]{err_desc, clientConfig.getValidationEndpointUrl()};
        }
        if (msgKey != null) {
            if (oidcClientRequest != null) {
                oidcClientRequest.setRsFailMsg(null, Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])msgObjs));
            }
            if (!isPropagationSupported) {
                Tr.error((TraceComponent)tc, (String)msgKey, (Object[])msgObjs);
            }
        }
    }

    protected ProviderAuthenticationResult getUserInfoFromToken(OidcClientConfig clientConfig, String accessToken, SSLSocketFactory sslSocketFactory, OidcClientRequest oidcClientRequest) {
        ProviderAuthenticationResult oidcResult = new ProviderAuthenticationResult(AuthResult.FAILURE, 401);
        JSONObject jobj = null;
        try {
            Map responseMap = this.oidcClientUtil.getUserinfo(clientConfig.getValidationEndpointUrl(), accessToken, sslSocketFactory, clientConfig.isHostNameVerificationEnabled(), clientConfig.getUseSystemPropertiesForHttpClientConnections());
            jobj = this.handleResponseMap(responseMap, clientConfig, oidcClientRequest);
            if (jobj != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"userinfo=", (Object[])new Object[]{jobj.serialize()});
                }
                if (!this.validateUserinfoJsonResponse(jobj, clientConfig, oidcClientRequest)) {
                    return oidcResult;
                }
                oidcResult = this.createProviderAuthenticationResult(jobj, clientConfig, accessToken);
            }
        }
        catch (IllegalArgumentException responseMap) {
            FFDCFilter.processException((Throwable)responseMap, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"619", (Object)this, (Object[])new Object[]{clientConfig, accessToken, sslSocketFactory, oidcClientRequest});
            Tr.error((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INVALID_VALIDATION_URL", (Object[])new Object[]{clientConfig.getValidationEndpointUrl()});
            oidcClientRequest.setRsFailMsg(null, Tr.formatMessage((TraceComponent)tc, (String)"PROPAGATION_TOKEN_INVALID_VALIDATION_URL", (Object[])new Object[]{clientConfig.getValidationEndpointUrl()}));
            return oidcResult;
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"624", (Object)this, (Object[])new Object[]{clientConfig, accessToken, sslSocketFactory, oidcClientRequest});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exception while getting the userInfo =", (Object[])new Object[]{e.getLocalizedMessage()});
            }
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_INTERNAL_ERR", e.getLocalizedMessage(), clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl());
            return oidcResult;
        }
        this.addUserInfoStringToCustomProperties(oidcResult, jobj);
        return oidcResult;
    }

    void addUserInfoStringToCustomProperties(ProviderAuthenticationResult oidcResult, JSONObject jobj) {
        try {
            String userInfoStr;
            String string = userInfoStr = jobj == null ? null : jobj.serialize();
            if (oidcResult != null && oidcResult.getUserName() != null && userInfoStr != null) {
                oidcResult.getCustomProperties().put("userinfo_string", userInfoStr);
            }
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"644", (Object)this, (Object[])new Object[]{oidcResult, jobj});
        }
    }

    private boolean validateUserinfoJsonResponse(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        String err = (String)jobj.get((Object)"error");
        if (err != null) {
            this.logErrorMessage(jobj, clientConfig, oidcClientRequest);
            return false;
        }
        String issuer = (String)jobj.get((Object)"iss");
        String issuers = null;
        if (issuer != null && (issuer.isEmpty() || (issuers = this.getIssuerIdentifier(clientConfig)) == null || this.notContains(issuers, issuer))) {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_ISS_ERROR", issuers, issuer);
            return false;
        }
        return true;
    }

    boolean notContains(String issuers, String issuer) {
        if (issuers.equals(issuer)) {
            return false;
        }
        StringTokenizer st = new StringTokenizer(issuers, " ,");
        while (st.hasMoreTokens()) {
            String iss = st.nextToken();
            if (!issuer.equals(iss)) continue;
            return false;
        }
        return true;
    }

    protected boolean validateJsonResponse(JSONObject jobj, OidcClientConfig clientConfig) {
        return this.validateJsonResponse(jobj, clientConfig, null);
    }

    protected boolean validateJsonResponse(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest req) {
        if (jobj.get((Object)"active") != null && !((Boolean)jobj.get((Object)"active")).booleanValue()) {
            this.logError(clientConfig, req, "PROPAGATION_TOKEN_NOT_ACTIVE", clientConfig.getValidationMethod(), clientConfig.getValidationEndpointUrl());
            return false;
        }
        if (!this.isExpValid(jobj, clientConfig, req)) {
            return false;
        }
        if (!this.isIatValid(jobj, clientConfig, req)) {
            return false;
        }
        return this.isIssuerValid(jobj, clientConfig, req);
    }

    private boolean isExpValid(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDate = new Date();
        Long exp = 0L;
        if (jobj.get((Object)"exp") != null && (exp = this.getLong(jobj.get((Object)"exp"))) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"exp = ", (Object[])new Object[]{exp});
            }
            if (!this.verifyExpirationTime(exp, currentDate, clientConfig.getClockSkewInSeconds(), clientConfig, oidcClientRequest)) {
                return false;
            }
        } else if (clientConfig.requireExpClaimForIntrospection()) {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_MISSING_REQUIRED_CLAIM_ERR", "exp", "iss, iat, exp");
            return false;
        }
        return true;
    }

    private boolean isIatValid(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDate = new Date();
        Long iat = 0L;
        if (jobj.get((Object)"iat") != null && (iat = this.getLong(jobj.get((Object)"iat"))) != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"iat = ", (Object[])new Object[]{iat});
            }
            if (!this.checkIssueatTime(iat, currentDate, clientConfig.getClockSkewInSeconds(), clientConfig, oidcClientRequest)) {
                return false;
            }
        } else if (clientConfig.requireIatClaimForIntrospection()) {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_MISSING_REQUIRED_CLAIM_ERR", "iat", "iss, iat, exp");
            return false;
        }
        return true;
    }

    private boolean isIssuerValid(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDate = new Date();
        if (this.issuerChecking(jobj, clientConfig, oidcClientRequest)) {
            Long nbf = 0L;
            if (jobj.get((Object)"nbf") != null && (nbf = this.getLong(jobj.get((Object)"nbf"))) != null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"nbf = ", (Object[])new Object[]{nbf});
                }
                if (!this.checkNotBeforeTime(nbf, currentDate, clientConfig.getClockSkewInSeconds(), clientConfig, oidcClientRequest)) {
                    return false;
                }
            }
        } else {
            return false;
        }
        return true;
    }

    boolean issuerChecking(JSONObject jobj, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        String issuer = (String)jobj.get((Object)"iss");
        String issuers = null;
        if (clientConfig.disableIssChecking()) {
            if (issuer != null) {
                this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_ISS_CLAIM_NOT_REQUIRED_ERR", clientConfig.getValidationEndpointUrl(), "iss", "disableIssChecking");
                return false;
            }
            return true;
        }
        if (issuer != null) {
            if (issuer.isEmpty() || (issuers = this.getIssuerIdentifier(clientConfig)) == null || this.notContains(issuers, issuer)) {
                this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_ISS_ERROR", issuers, issuer);
                return false;
            }
        } else {
            this.logError(clientConfig, oidcClientRequest, "PROPAGATION_TOKEN_MISSING_REQUIRED_CLAIM_ERR", "iss", "iss, iat, exp");
            return false;
        }
        return true;
    }

    String getIssuerIdentifier(OidcClientConfig clientConfig) {
        String validationEndpoint;
        String issuer = null;
        issuer = clientConfig.getIssuerIdentifier();
        if ((issuer == null || issuer.isEmpty()) && (validationEndpoint = clientConfig.getValidationEndpointUrl()) != null) {
            int lastSlashIndex = validationEndpoint.lastIndexOf("/");
            issuer = validationEndpoint.substring(0, lastSlashIndex);
        }
        return issuer;
    }

    protected Long getLong(Object obj) {
        if (obj == null || obj instanceof Long) {
            return (Long)obj;
        }
        if (obj instanceof Integer) {
            Integer int_obj = (Integer)obj;
            return (long)int_obj;
        }
        Long result = null;
        try {
            String str = null;
            str = obj instanceof String[] ? ((String[])obj)[0] : (String)obj;
            result = Long.valueOf(str);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"829", (Object)this, (Object[])new Object[]{obj});
        }
        return result;
    }

    private boolean checkNotBeforeTime(Long nbfInSeconds, Date currentDate, long clockSkewInSeconds, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDatePlusClockSkew;
        long nbf = nbfInSeconds * 1000L;
        Date nbfDate = new Date(nbf);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AccessToken nbf : " + nbfDate + ", currentDate:" + currentDate), (Object[])new Object[0]);
        }
        if (nbfDate.after(currentDatePlusClockSkew = new Date(currentDate.getTime() + clockSkewInSeconds * 1000L))) {
            this.logError(clientConfig, true, oidcClientRequest, "PROPAGATION_TOKEN_NBF_ERR", nbfDate.toString(), currentDatePlusClockSkew.toString());
            return false;
        }
        return true;
    }

    protected boolean verifyExpirationTime(Long expInSeconds, Date currentDate, long clockSkewInSeconds, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDateMinusClockSkew;
        long exp = expInSeconds * 1000L;
        Date expDate = new Date(exp);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AccessToken exp: " + expDate + ", currentDate:" + currentDate), (Object[])new Object[0]);
        }
        if (expDate.before(currentDateMinusClockSkew = new Date(currentDate.getTime() - clockSkewInSeconds * 1000L))) {
            this.logError(clientConfig, true, oidcClientRequest, "PROPAGATION_TOKEN_EXPIRED_ERR", expDate.toString(), currentDateMinusClockSkew.toString());
            return false;
        }
        return true;
    }

    protected boolean checkIssueatTime(Long iatInSeconds, Date currentDate, long clockSkewInSeconds, OidcClientConfig clientConfig, OidcClientRequest oidcClientRequest) {
        Date currentDatePlusClockSkew;
        long iat = iatInSeconds * 1000L;
        Date iatDate = new Date(iat);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("AccessToken iat : " + iatDate + ", currentDate:" + currentDate), (Object[])new Object[0]);
        }
        if (iatDate.after(currentDatePlusClockSkew = new Date(currentDate.getTime() + clockSkewInSeconds * 1000L))) {
            this.logError(clientConfig, true, oidcClientRequest, "PROPAGATION_TOKEN_FUTURE_TOKEN_ERR", iatDate.toString(), currentDatePlusClockSkew.toString());
            return false;
        }
        return true;
    }

    protected ProviderAuthenticationResult createProviderAuthenticationResult(JSONObject jobj, OidcClientConfig clientConfig, String accessToken) {
        AttributeToSubjectExt attributeToSubject = new AttributeToSubjectExt(clientConfig, jobj, accessToken);
        if (attributeToSubject.checkUserNameForNull()) {
            return new ProviderAuthenticationResult(AuthResult.SEND_401, 401);
        }
        Hashtable customProperties = attributeToSubject.handleCustomProperties();
        customProperties.put(ACCESS_TOKEN, accessToken);
        customProperties.put("access_token_info", jobj);
        ProviderAuthenticationResult oidcResult = null;
        oidcResult = attributeToSubject.doMapping(customProperties, new Subject());
        return oidcResult;
    }

    public static String getBearerAccessTokenToken(HttpServletRequest req, OidcClientConfig clientConfig) {
        String headerName = clientConfig.getHeaderName();
        if (headerName != null) {
            return AccessTokenAuthenticator.getAccessTokenFromConfiguredHeader(req, headerName);
        }
        return AccessTokenAuthenticator.getAccessTokenFromAuthorizationHeaderOrPostParameter(req);
    }

    @Trivial
    static String getAccessTokenFromConfiguredHeader(HttpServletRequest req, String headerName) {
        String hdrValue = req.getHeader(headerName);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)(headerName + " content="), (Object[])new Object[]{hdrValue});
        }
        if (hdrValue != null) {
            if (AccessTokenAuthenticator.isBearerToken(hdrValue)) {
                hdrValue = hdrValue.substring(7);
            }
            return hdrValue.trim();
        }
        return AccessTokenAuthenticator.getAccessTokenFromHeaderSegments(req, headerName);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    private static String getAccessTokenFromHeaderSegments(HttpServletRequest req, String headerName) {
        String hdrValue;
        block7: {
            hdrValue = null;
            StringBuffer sb1 = new StringBuffer(headerName);
            sb1.append(JWT_SEGMENTS);
            String headerSegments = req.getHeader(sb1.toString());
            if (headerSegments != null) {
                try {
                    int iSegs = Integer.parseInt(headerSegments);
                    StringBuffer sb3 = new StringBuffer();
                    for (int i = 1; i < iSegs + 1; ++i) {
                        StringBuffer sb2 = new StringBuffer(headerName);
                        sb2.append(JWT_SEGMENT_INDEX).append(i);
                        String segHdrValue = req.getHeader(sb2.toString());
                        if (segHdrValue == null) continue;
                        sb3.append(segHdrValue.trim());
                    }
                    hdrValue = sb3.toString();
                    if (hdrValue != null && hdrValue.isEmpty()) {
                        hdrValue = null;
                    } else if (AccessTokenAuthenticator.isBearerToken(hdrValue)) {
                        hdrValue = hdrValue.substring(7);
                    }
                }
                catch (Exception iSegs) {
                    void e;
                    FFDCFilter.processException((Throwable)iSegs, (String)"com.ibm.ws.security.openidconnect.client.internal.AccessTokenAuthenticator", (String)"978", null, (Object[])new Object[]{req, headerName});
                    if (!tc.isDebugEnabled()) break block7;
                    Tr.debug((TraceComponent)tc, (String)"Fail to read Header Segments:", (Object[])new Object[]{e});
                }
            }
        }
        return hdrValue;
    }

    @Trivial
    private static String getAccessTokenFromAuthorizationHeaderOrPostParameter(HttpServletRequest req) {
        String hdrValue = req.getHeader(Authorization_Header);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Authorization header=", (Object[])new Object[]{hdrValue});
        }
        if (AccessTokenAuthenticator.isBearerToken(hdrValue)) {
            hdrValue = hdrValue.substring(7);
        } else {
            String contentType;
            String reqMethod = req.getMethod();
            if ("POST".equalsIgnoreCase(reqMethod) && "application/x-www-form-urlencoded".equals(contentType = req.getHeader("Content-Type"))) {
                hdrValue = req.getParameter(ACCESS_TOKEN);
            }
        }
        return hdrValue;
    }

    @Trivial
    private static boolean isBearerToken(String hdrValue) {
        return hdrValue != null && hdrValue.toLowerCase().startsWith(BEARER_SCHEME);
    }

    public boolean canUseIssuerAsSelectorForInboundPropagation(HttpServletRequest req, OidcClientConfig clientConfig) {
        boolean result = false;
        boolean remove_attribute_from_request = false;
        if (!clientConfig.isInboundPropagationEnabled() || clientConfig.disableIssChecking()) {
            return false;
        }
        String issuer = this.getIssuer(req, clientConfig, remove_attribute_from_request);
        if (issuer != null) {
            String issuers = null;
            if (!issuer.isEmpty() && (issuers = this.getIssuerIdentifier(clientConfig)) != null && !this.notContains(issuers, issuer)) {
                result = true;
            }
        }
        return result;
    }

    @Trivial
    @FFDCIgnore(value={IOException.class})
    private String getIssuer(HttpServletRequest req, OidcClientConfig clientConfig, boolean remove_attribute) {
        String issuer = null;
        String accessToken = this.getAccessToken(req, clientConfig, remove_attribute);
        if (accessToken != null && this.isTokenJWT(accessToken)) {
            try {
                JSONObject payload = JSONObject.parse((String)JsonTokenUtil.fromBase64ToJsonString((String)accessToken.split("\\.")[1]));
                issuer = (String)payload.get((Object)"iss");
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return issuer;
    }

    private String getAccessToken(HttpServletRequest req, OidcClientConfig clientConfig, boolean remove_attribute) {
        String accessToken = null;
        if (clientConfig.getAccessTokenInLtpaCookie()) {
            accessToken = this.getAccessTokenFromReqAsAttribute(req, remove_attribute);
        }
        if (accessToken == null) {
            accessToken = AccessTokenAuthenticator.getBearerAccessTokenToken(req, clientConfig);
        }
        return accessToken;
    }

    void logError(OidcClientConfig oidcClientConfig, OidcClientRequest oidcClientRequest, String msgKey, Object ... objs) {
        this.logError(oidcClientConfig, false, oidcClientRequest, msgKey, objs);
    }

    void logError(OidcClientConfig oidcClientConfig, boolean warningWhenSupported, OidcClientRequest oidcClientRequest, String msgKey, Object ... objs) {
        String inboundPropagation = oidcClientConfig.getInboundPropagation();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ac_err msg:" + msgKey + " inboundPropagation:" + inboundPropagation + " warning?:" + warningWhenSupported), (Object[])new Object[0]);
        }
        if ("supported".equalsIgnoreCase(inboundPropagation)) {
            if (warningWhenSupported) {
                Tr.warning((TraceComponent)tc, (String)msgKey, (Object[])objs);
            }
        } else {
            Tr.error((TraceComponent)tc, (String)msgKey, (Object[])objs);
        }
        if (oidcClientRequest != null) {
            String existingFailMsg = oidcClientRequest.getRsFailMsg();
            if (existingFailMsg == null) {
                String format = Tr.formatMessage((TraceComponent)tc, (String)msgKey, (Object[])objs);
                oidcClientRequest.setRsFailMsg(null, format);
            } else {
                Tr.debug((TraceComponent)tc, (String)("Not setting new RS fail message since one was already found: " + existingFailMsg), (Object[])new Object[0]);
            }
        }
    }
}

